/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.logging;

import com.evermind.server.ejb.AbstractEJBContext;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.logging.EJBMessages;
import com.evermind.server.ejb.logging.i18n.EJBRuntimeMessageBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBContext;
import oracle.j2ee.util.CustomerLogger;

public class EJBRuntimeMessages
extends EJBMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.ejb.runtime", EJBRuntimeMessageBundle.class.getName());

    public static void infoNoneHomeInstance(BeanDescriptor desc) {
        m_logger.log(Level.INFO, "J2EE EJB-02001", new Object[]{EJBRuntimeMessages.getApplicationName(desc), EJBRuntimeMessages.getModuleName(desc), EJBRuntimeMessages.getBeanName(desc)});
    }

    public static void warningNullSFSObject(String appName) {
        m_logger.log(Level.WARNING, "J2EE EJB-02002", new Object[]{appName});
    }

    public static void infoDuplicateTableCreation(String appName) {
        m_logger.log(Level.INFO, "J2EE EJB-02003", new Object[]{appName});
    }

    public static void warningTimeoutWaitingForActiveCalls(String beanName, int count) {
        m_logger.log(Level.WARNING, "J2EE EJB-02004", new Object[]{beanName, new Integer(count)});
    }

    public static void warningMaxInstanceThresholdReached(BeanDescriptor desc, int count, int max) {
        m_logger.log(Level.WARNING, "J2EE EJB-02005", new Object[]{EJBRuntimeMessages.getApplicationName(desc), EJBRuntimeMessages.getModuleName(desc), EJBRuntimeMessages.getBeanName(desc), new Integer(count), new Integer(max)});
    }

    public static void warningMaxMemoryThresholdReached(BeanDescriptor desc, int count, int max) {
        m_logger.log(Level.WARNING, "J2EE EJB-02006", new Object[]{EJBRuntimeMessages.getApplicationName(desc), EJBRuntimeMessages.getModuleName(desc), EJBRuntimeMessages.getBeanName(desc), new Integer(count), new Integer(max)});
    }

    public static void fineNamingException(BeanDescriptor desc, String name, Exception e) {
        if (m_logger.isLoggable(Level.FINE)) {
            EJBRuntimeMessages.logException(m_logger, Level.FINE, "J2EE EJB-02007", new Object[]{EJBRuntimeMessages.getApplicationName(desc), EJBRuntimeMessages.getModuleName(desc), EJBRuntimeMessages.getBeanName(desc), name}, e);
        }
    }

    public static void warningMaxDeliveryCountExceeded(BeanDescriptor desc, String messageId) {
        m_logger.log(Level.WARNING, "J2EE EJB-02008", new Object[]{EJBRuntimeMessages.getApplicationName(desc), EJBRuntimeMessages.getModuleName(desc), EJBRuntimeMessages.getBeanName(desc), messageId});
    }

    public static void warningJMSProviderException(BeanDescriptor desc, Exception e) {
        EJBRuntimeMessages.logException(m_logger, Level.WARNING, "J2EE EJB-02009", new Object[]{EJBRuntimeMessages.getApplicationName(desc), EJBRuntimeMessages.getModuleName(desc), EJBRuntimeMessages.getBeanName(desc), e}, e);
    }

    public static void warningOnListenerMethodException(BeanDescriptor desc, Throwable e, String listenerMethodName) {
        EJBRuntimeMessages.logException(m_logger, Level.WARNING, "J2EE EJB-02010", new Object[]{EJBRuntimeMessages.getApplicationName(desc), EJBRuntimeMessages.getModuleName(desc), EJBRuntimeMessages.getBeanName(desc), listenerMethodName, e}, e);
    }

    public static void finestJMSReceivedMessage(BeanDescriptor desc, String messageId) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE EJB-02011", new Object[]{EJBRuntimeMessages.getApplicationName(desc), EJBRuntimeMessages.getModuleName(desc), EJBRuntimeMessages.getBeanName(desc), messageId});
        }
    }

    public static void fineRetryJMSConnection(BeanDescriptor desc, int maxRetries, int retryCount) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE EJB-02012", new Object[]{EJBRuntimeMessages.getApplicationName(desc), EJBRuntimeMessages.getModuleName(desc), EJBRuntimeMessages.getBeanName(desc), new Integer(retryCount), new Integer(maxRetries)});
        }
    }

    public static void fineRetryJMSConnectionWait(BeanDescriptor desc, int duration) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE EJB-02015", new Object[]{EJBRuntimeMessages.getApplicationName(desc), EJBRuntimeMessages.getModuleName(desc), EJBRuntimeMessages.getBeanName(desc), new Integer(duration)});
        }
    }

    public static void fineJMSProviderExceptionDuringShutdown(BeanDescriptor desc, Exception e) {
        if (m_logger.isLoggable(Level.FINE)) {
            EJBRuntimeMessages.logException(m_logger, Level.FINE, "J2EE EJB-02013", new Object[]{EJBRuntimeMessages.getApplicationName(desc), EJBRuntimeMessages.getModuleName(desc), EJBRuntimeMessages.getBeanName(desc), e}, e);
        }
    }

    public static void warningAllConsumersFinished(BeanDescriptor desc) {
        m_logger.log(Level.WARNING, "J2EE EJB-02014", new Object[]{EJBRuntimeMessages.getApplicationName(desc), EJBRuntimeMessages.getModuleName(desc), EJBRuntimeMessages.getBeanName(desc)});
    }

    public static void warningCMTUserTransaction(EJBContext context) {
        BeanDescriptor desc = ((AbstractEJBContext)context).getBeanDescriptor();
        m_logger.log(Level.WARNING, "J2EE EJB-02020", new Object[]{EJBRuntimeMessages.getApplicationName(desc), EJBRuntimeMessages.getModuleName(desc), EJBRuntimeMessages.getBeanName(desc)});
    }

    public static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }
}

