/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.persistence;

import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.persistence.PersistenceModule;
import com.evermind.util.EJBProperties;
import java.lang.instrument.IllegalClassFormatException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.ClassPreprocessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    protected static final String DEFAULT_ESSENTIALS_PERSISTENCE_PROVIDER_CLASS_NAME = "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider";
    private static final String SERVER_PLATFORM_CLASS_NAME_PROPERTY = "toplink.server.platform.class.name";
    private static final String TARGET_SERVER_PROPERTY_NAME = "toplink.target-server";
    private static final String DEFAULT_TARGET_SERVER = "OC4J";
    private static final String DEFAULT_ESSENTIALS_TARGET_SERVER = "OC4J_10_1_3";
    protected static final String SYSTEM_DEFAULT_PERSISTENCE_UNIT_NAME = "default";
    public static final String DDL_GENERATION = "toplink.ddl-generation";
    public static final String NONE = "none";
    private String name = "default";
    private String description;
    private String persistenceProviderClassName = "essentials".equals(EJBProperties.getDefaultPersistenceProvider()) ? "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider" : EJBProperties.getDefaultPersistenceProvider();
    private PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionType.JTA;
    private List<String> mappingFileNames = new ArrayList<String>(1);
    private List<String> managedClassNames = new ArrayList<String>();
    private boolean excludeUnlistedClasses = false;
    private Properties properties = new Properties();
    private String jtaDataSourceName;
    private String nonJtaDataSourceName;
    private List<String> jarFileNames = new ArrayList<String>(1);
    private DataSource jtaDataSource;
    private DataSource nonJtaDataSource;
    private URL persistentRootUrl;
    private List<URL> jarFileUrls = new ArrayList<URL>(1);
    private PolicyClassLoader classLoader;
    private PolicyClassLoader tempClassLoader;

    public void initialize(PersistenceModule module, URL rootUrl) {
        this.persistentRootUrl = rootUrl;
        this.classLoader = module.getClassLoader();
        if (!this.getProperties().containsKey(TARGET_SERVER_PROPERTY_NAME) && !this.getProperties().containsKey(SERVER_PLATFORM_CLASS_NAME_PROPERTY)) {
            if (this.getPersistenceProviderClassName().indexOf("essentials") != -1) {
                this.getProperties().put(TARGET_SERVER_PROPERTY_NAME, DEFAULT_ESSENTIALS_TARGET_SERVER);
            } else {
                this.getProperties().put(TARGET_SERVER_PROPERTY_NAME, DEFAULT_TARGET_SERVER);
            }
        }
        if (this.jtaDataSourceName == null) {
            this.jtaDataSourceName = module.getDefaultDataSourceName();
        }
        this.jtaDataSource = this.getDataSource(module, this.jtaDataSourceName);
        if (this.nonJtaDataSourceName == null) {
            this.nonJtaDataSourceName = this.jtaDataSourceName;
        }
        this.nonJtaDataSource = this.getDataSource(module, this.nonJtaDataSourceName);
        this.configTableCreation(module);
        for (String jarFileName : this.jarFileNames) {
            try {
                this.jarFileUrls.add(new URL(rootUrl, jarFileName));
            }
            catch (MalformedURLException e) {
                throw DeploymentException.exceptionCreatingJarFileUrl(module, jarFileName, rootUrl.toString(), e);
            }
        }
    }

    public void configTableCreation(PersistenceModule module) {
        if (module.isDeployed()) {
            this.getProperties().put(DDL_GENERATION, NONE);
        }
    }

    private DataSource getDataSource(PersistenceModule module, String dsName) {
        try {
            return (DataSource)module.getApplicationContext().lookup(dsName);
        }
        catch (NamingException e) {
            throw DeploymentException.unableToResolveDataSource(module, dsName, e);
        }
    }

    public void destroy() {
        if (this.tempClassLoader != null) {
            this.tempClassLoader.close();
            this.tempClassLoader = null;
        }
    }

    public String getPersistenceUnitName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public DataSource getNonJtaDataSource() {
        if (this.nonJtaDataSource == null) {
            return this.getJtaDataSource();
        }
        return this.nonJtaDataSource;
    }

    public List<String> getMappingFileNames() {
        return this.mappingFileNames;
    }

    public List<URL> getJarFileUrls() {
        return this.jarFileUrls;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistentRootUrl;
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addTransformer(ClassTransformer transformer) {
        EJBUtils.setClassPreprocessor(this.classLoader, new ClassPreprocessorWrapper(transformer));
    }

    public ClassLoader getNewTempClassLoader() {
        if (this.tempClassLoader == null) {
            this.tempClassLoader = this.classLoader.copy(false, false);
        }
        return this.tempClassLoader;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public void addJarFileUrlName(String jarFileName) {
        this.jarFileNames.add(jarFileName);
    }

    public List<String> getJarFileUrlNames() {
        return this.jarFileNames;
    }

    public void addManagedClassName(String managedClassName) {
        this.managedClassNames.add(managedClassName);
    }

    public void addMappingFileName(String mappingFileName) {
        this.mappingFileNames.add(mappingFileName);
    }

    public void setPersistenceUnitName(String name) {
        this.name = name;
    }

    public void setPersistenceProviderClassName(String persistenceProviderClassName) {
        this.persistenceProviderClassName = persistenceProviderClassName;
    }

    public String getJtaDataSourceName() {
        return this.jtaDataSourceName;
    }

    public void setJtaDataSourceName(String jtaDataSourceName) {
        this.jtaDataSourceName = jtaDataSourceName;
    }

    public String getNonJtaDataSourceName() {
        return this.nonJtaDataSourceName;
    }

    public void setNonJtaDataSourceName(String nonJtaDataSourceName) {
        this.nonJtaDataSourceName = nonJtaDataSourceName;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    private class ClassPreprocessorWrapper
    implements ClassPreprocessor {
        ClassTransformer transformer;

        public ClassPreprocessorWrapper(ClassTransformer transformer) {
            this.transformer = transformer;
        }

        public ClassPreprocessor initialize(ClassLoader loader) {
            return this;
        }

        public byte[] processClass(String className, byte[] origClassBytes, int offset, int length, ProtectionDomain pd, ClassLoader loader) {
            try {
                byte[] newClassBytes = this.transformer.transform(loader, className.replace('.', '/'), null, pd, origClassBytes);
                if (newClassBytes != null) {
                    return newClassBytes;
                }
                return origClassBytes;
            }
            catch (IllegalClassFormatException e) {
                throw DeploymentException.exceptionTransformingEntityClass(className, loader, e);
            }
        }
    }
}

