/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.proxy;

import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.LocalTopLinkEntityEJBHome;
import com.evermind.server.ejb.RemoteTopLinkEntityEJBHome;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.proxy.ProxyGenerator;
import java.lang.reflect.Method;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class EntityHomeProxyGenerator
extends ProxyGenerator {
    private EntityBeanDescriptor ed;
    private Class wrapperClass;
    private Class primaryKeyClass;
    private String concreteClassName;

    public EntityHomeProxyGenerator(EntityBeanDescriptor ed, boolean local) {
        Class clazz = local ? LocalTopLinkEntityEJBHome.class : RemoteTopLinkEntityEJBHome.class;
        super(clazz, local ? ed.getLocalHome() : ed.getRemoteHome());
        this.ed = ed;
        this.wrapperClass = local ? ed.getLocalWrapper() : ed.getRemoteWrapper();
        this.primaryKeyClass = ed.getPrimaryKeyClass();
        this.concreteClassName = ed.getConcreteBeanClassName();
        this.setHome(true);
        this.setRemote(!local);
        this.setCopyByValue(ed.isCopyByValue());
        if (this.isRemote() && ed.getGenerateIIOP()) {
            this.setCorba(true);
        }
    }

    protected String generateProxyClassName() {
        return EJBUtils.getProxyName(this.ed, this.isRemote(), this.isHome());
    }

    protected boolean shouldGenerateMethod(Method method) {
        if ((method.getDeclaringClass() == EJBHome.class || method.getDeclaringClass() == EJBLocalHome.class) && method.getName().equals("remove")) {
            return true;
        }
        return super.shouldGenerateMethod(method);
    }

    protected boolean shouldCloneReturnValue(Method method, Class returnType) {
        if (method.getName().startsWith("find")) {
            return false;
        }
        return super.shouldCloneReturnValue(method, returnType);
    }

    protected void afterGenerateMethods(ClassVisitor cw) {
        this.generateCreateWrapperInstance(cw);
        this.generateGetEJBObject(cw);
        this.generateCreateInstance(cw);
    }

    private void generateCreateWrapperInstance(ClassVisitor cw) {
        String wrapperName = Type.getInternalName((Class)this.wrapperClass);
        CodeVisitor mv = cw.visitMethod(1, "createBeanWrapperInstance", "(Lcom/evermind/server/ejb/EvermindEntityContext;Z)Lcom/evermind/server/ejb/EntityEJBObject;", null, null);
        mv.visitTypeInsn(187, wrapperName);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getProxyClassName(), "pm", "Lcom/oracle/server/ejb/persistence/pm/PersistenceManager;");
        mv.visitMethodInsn(183, wrapperName, "<init>", "(Lcom/evermind/server/ejb/EvermindEntityContext;ZLcom/evermind/server/ejb/AbstractEJBHome;Lcom/oracle/server/ejb/persistence/pm/PersistenceManager;)V");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
    }

    private void generateGetEJBObject(ClassVisitor cw) {
        CodeVisitor mv = cw.visitMethod(1, "getEJBObject", "(Ljava/lang/Object;)Ljavax/ejb/EJBObject;", new String[]{"javax/ejb/EJBException", "javax/ejb/FinderException", "java/rmi/RemoteException"}, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        if (this.primaryKeyClass != Object.class) {
            mv.visitTypeInsn(192, Type.getInternalName((Class)this.primaryKeyClass));
        }
        String methodDesc = Type.getMethodDescriptor((Type)Type.getType((Class)this.wrapperClass), (Type[])new Type[]{Type.getType((Class)this.primaryKeyClass)});
        mv.visitMethodInsn(182, this.getProxyClassName(), "findByPrimaryKey", methodDesc);
        mv.visitTypeInsn(192, "javax/ejb/EJBObject");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
    }

    private void generateCreateInstance(ClassVisitor cw) {
        CodeVisitor mv = cw.visitMethod(1, "createInstance", "()Ljavax/ejb/EntityBean;", null, null);
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitTypeInsn(187, this.concreteClassName);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, this.concreteClassName, "<init>", "()V");
        mv.visitInsn(176);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "com/evermind/server/ejb/EJBUtils", "createEJBException", "(Ljava/lang/Exception;)Ljavax/ejb/EJBException;");
        mv.visitInsn(191);
        mv.visitTryCatchBlock(l0, l1, l1, "java/lang/Exception");
        mv.visitMaxs(0, 0);
    }
}

