/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

public class BNFCharType {
    private static final int OCTET = 0;
    private static final int SP = 1;
    private static final int HT = 2;
    private static final int CR = 4;
    private static final int LF = 8;
    private static final int CRLF = 12;
    private static final int DIGIT = 16;
    private static final int UP_ALPHA = 32;
    private static final int LO_ALPHA = 64;
    private static final int ALPHA = 96;
    private static final int CTL = 128;
    private static final int D_QUOTE = 256;
    private static final int SEPARATOR = 512;
    private static final int CHAR = 1024;
    private static final int HEX = 2048;
    protected static final int[] charType = new int[256];

    private static int getType(char c) {
        int type = 0;
        if (c < '\u0080') {
            type += 1024;
            if (c < ' ') {
                type += 128;
            } else if (c >= '0') {
                if (c <= '9') {
                    type += 16;
                } else if (c >= 'A') {
                    if (c <= 'Z') {
                        type += 32;
                        if (c <= 'F') {
                            type += 2048;
                        }
                    } else if (c >= 'a' && c <= 'z') {
                        type += 64;
                        if (c <= 'f') {
                            type += 2048;
                        }
                    }
                }
            }
            switch (c) {
                case '\t': {
                    return type += 514;
                }
                case '\n': {
                    return type += 8;
                }
                case '\r': {
                    return type += 4;
                }
                case ' ': {
                    return type += 513;
                }
                case '\"': {
                    return type += 768;
                }
                case '\u007f': {
                    return type += 128;
                }
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    return type += 512;
                }
            }
        }
        return type;
    }

    protected static boolean is(int cType, int type) {
        return (cType & type) != 0;
    }

    public static boolean isAlpha(char c) {
        int ct = charType[c];
        return BNFCharType.is(ct, 96);
    }

    public static boolean isLoAlpha(char c) {
        int ct = charType[c];
        return BNFCharType.is(ct, 64);
    }

    public static boolean isUpAlpha(char c) {
        int ct = charType[c];
        return BNFCharType.is(ct, 32);
    }

    public static boolean isChar(char c) {
        return BNFCharType.is(charType[c], 1024);
    }

    public static boolean isCR(char c) {
        return BNFCharType.is(charType[c], 4);
    }

    public static boolean isCRLF(char c) {
        return BNFCharType.is(charType[c], 12);
    }

    public static boolean isCtl(char c) {
        int ct = charType[c];
        return BNFCharType.is(ct, 128);
    }

    public static boolean isDigit(char c) {
        return BNFCharType.is(charType[c], 16);
    }

    public static boolean isHEX(char c) {
        return BNFCharType.is(charType[c], 2048);
    }

    public static boolean isHexadecimal(char c) {
        return BNFCharType.is(charType[c], 2064);
    }

    public static boolean isHT(char c) {
        return BNFCharType.is(charType[c], 2);
    }

    public static boolean isLF(char c) {
        return BNFCharType.is(charType[c], 8);
    }

    public static boolean isQuot(char c) {
        return BNFCharType.is(charType[c], 256);
    }

    public static boolean isSeparator(char c) {
        return BNFCharType.is(charType[c], 512);
    }

    public static boolean isToken(char c) {
        int ct = charType[c];
        return BNFCharType.is(ct, 1024) && !BNFCharType.is(ct, 640);
    }

    public static boolean isSP(char c) {
        return BNFCharType.is(charType[c], 1);
    }

    public static boolean isSpace(char c) {
        int ct = charType[c];
        return BNFCharType.is(ct, 3);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            BNFCharType.charType[i] = BNFCharType.getType((char)i);
        }
    }
}

