/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.io.ChunkedOutputStream;
import com.evermind.server.ThreadState;
import com.evermind.server.http.AJPHttpServletRequest;
import com.evermind.server.http.CookieValueCoder;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpSession;
import com.evermind.server.http.EvermindServletOutputStream;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.server.http.HttpIOException;
import com.evermind.server.http.HttpMessages;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.JspInterface;
import com.evermind.server.http.ServletInstanceInfo;
import com.evermind.server.http.ServletUtils;
import com.evermind.server.http.ServletWriter;
import com.evermind.server.http.deployment.ErrorPage;
import com.evermind.util.ArrayUtils;
import com.evermind.util.ByteString;
import com.evermind.util.HTTPProperties;
import com.evermind.util.ObjectUtils;
import com.evermind.util.ServerProperties;
import com.evermind.util.StringUtils;
import com.evermind.util.SystemUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.j2ee.util.TraceLogger;

public class EvermindHttpServletResponse
implements HttpServletResponse {
    private static final ByteString TEXT_HTML_BYTESTRING = new ByteString("text/html");
    private static final ByteString TEXT_PLAIN_BYTESTRING = new ByteString("text/plain");
    public static final boolean DEBUG_CONTENTLENGTH_SETTING = HTTPProperties.getDebugHttpContentLength();
    private static final byte[] DEFAULT_RESPONSE = "HTTP/1.1 200 OK\r\n".getBytes();
    private static final byte[] NOT_MODIFIED_RESPONSE = "HTTP/1.1 304 Not Modified\r\n".getBytes();
    private static final byte[] RESPONSE_VERSION = "HTTP/1.1 ".getBytes();
    private static final byte[] CONTENT_TYPE_HEADER = "Content-Type: ".getBytes();
    private static final byte[] CONTENT_LENGTH_HEADER = "Content-Length: ".getBytes();
    private static final byte[] LAST_MODIFIED_HEADER = "Last-Modified: ".getBytes();
    private static final byte[] CACHE_CONTROL_PRIVATE_HEADER = "Cache-Control: private\r\n".getBytes();
    private static final byte[] TRANSFER_ENCODING_CHUNKED_HEADER = "Transfer-Encoding: chunked\r\n".getBytes();
    private static final String KEEP_ALIVE_HEADER_S = "Keep-Alive: timeout=15, max=100\r\n";
    private static final byte[] KEEP_ALIVE_HEADER = "Keep-Alive: timeout=15, max=100\r\n".getBytes();
    static final String CONNECTION_KEEP_ALIVE_HEADER_S = "Connection: Keep-Alive\r\n";
    static final byte[] CONNECTION_KEEP_ALIVE_HEADER = "Connection: Keep-Alive\r\n".getBytes();
    private static final byte[] KEEP_ALIVE_COMBO_HEADERS = "Connection: Keep-Alive\r\nKeep-Alive: timeout=15, max=100\r\n".getBytes();
    static final byte[] CONNECTION_CLOSE_HEADER = "Connection: close\r\n".getBytes();
    private static final byte[] ACCEPT_RANGES_BYTES_HEADER = "\r\nAccept-Ranges: bytes\r\n".getBytes();
    private static final byte[] CONTENT_LOCATION = "Content-Location: ".getBytes();
    private static final byte[] CONTENT_BASE = "Content-Base: ".getBytes();
    private static final String EARLY_DATE_STRING = HttpDateFormat.format3(0L);
    public static final byte STATUS_OUTPUTSTREAM = 1;
    public static final byte STATUS_WRITER = 2;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    protected static final byte[][] statusNumAsByteArray = new byte[600][];
    static final String SETLOCALE_DEFAULT_ENCODING;
    private static final int MAX_RESPONSE_HEADER_SIZE;
    private final byte[] responseHeaderBuffer = new byte[MAX_RESPONSE_HEADER_SIZE];
    boolean isLoginOrErrorPage;
    protected OutputStream basicOut;
    final EvermindServletOutputStream out = new EvermindServletOutputStream();
    boolean committed;
    private String[] headers;
    private int headerCount;
    String contentType;
    PrintWriter writer;
    int contentLength = -1;
    int status;
    private boolean isStatusImmutable = false;
    private String statusMessage;
    ServletInstanceInfo chainingHandler;
    ByteString contentLocation;
    byte outputFetchStatus;
    private Cookie[] cookies;
    EvermindHttpServletRequest request;
    byte[] lastModifiedHeader;
    byte[] expiresHeader;
    long lastModified;
    byte[] contentLengthHeader;
    ByteString contentTypeHeader;
    byte[] eTagHeader;
    byte[] sessionCookiePrefix;
    byte[] sessionCookieValue;
    boolean keepAlive;
    protected Locale locale = Locale.getDefault();
    private byte sendingError;
    String charset;
    boolean isCharsetSet = false;
    protected static final String THAI_CHARSET_IANA = "TIS-620";
    protected static final String THAI_CHARSET_JAVA = "TIS620";
    private boolean useJspOutputStream = false;
    private static Logger m_traceLogger;

    public void preset(OutputStream out) {
        this.basicOut = out;
        this.out.reset(this);
    }

    public void resetState() {
        this.isLoginOrErrorPage = false;
        this.lastModified = -1L;
        this.committed = false;
        this.headers = null;
        this.headerCount = 0;
        this.contentLocation = null;
        this.contentType = null;
        this.charset = null;
        this.isCharsetSet = false;
        this.resetPrintWriter();
        this.contentLength = -1;
        this.status = 0;
        this.isStatusImmutable = false;
        this.statusMessage = null;
        this.chainingHandler = null;
        this.outputFetchStatus = 0;
        this.cookies = null;
        this.lastModifiedHeader = null;
        this.expiresHeader = null;
        this.contentLengthHeader = null;
        this.contentTypeHeader = null;
        this.eTagHeader = null;
        this.sessionCookiePrefix = null;
        this.sessionCookieValue = null;
        this.keepAlive = false;
        this.locale = Locale.getDefault();
    }

    public void setHeader(String name, String value) {
        if (this.shouldProceedWithMutation()) {
            this.setHeader_oc4j(name, value);
        }
    }

    public void setStatus(int sc) {
        if (this.shouldProceedWithMutation()) {
            this.setStatus_oc4j(sc);
        }
    }

    public void reset() {
        if (this.shouldProceedWithMutation()) {
            this.reset_oc4j(true);
        }
    }

    public void reset(boolean resetHeaders) {
        if (this.shouldProceedWithMutation()) {
            this.reset_oc4j(resetHeaders);
        }
    }

    public void setCharacterEncoding(String charset) {
        if (this.shouldProceedWithMutation()) {
            this.setCharacterEncoding_oc4j(charset);
        }
    }

    public void setContentLength(int length) {
        if (this.shouldProceedWithMutation()) {
            this.setContentLength_oc4j(length);
        }
    }

    public void setContentType(String type) {
        if (this.shouldProceedWithMutation()) {
            this.setContentType_oc4j(type);
        }
    }

    protected void commitAndIgnoreWrites() throws HttpIOException {
        if (!this.committed) {
            this.commit();
        }
        this.out.setIgnoreWrites();
    }

    void close() {
        if (this.getCurrentWriter() != null) {
            try {
                this.writer.flush();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!this.out.closed) {
            try {
                this.out.closeFinally();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void commit() throws HttpIOException {
        HttpApplication application = this.request.application;
        try {
            byte[] statusMessageArray;
            Object handler;
            boolean hasBody;
            boolean bl = hasBody = this.request.method != "HEAD" && this.status != 204 && (this.status < 100 || this.status >= 200);
            if (this.isLoginOrErrorPage) {
                this.lastModifiedHeader = null;
                this.setHeader_oc4j("Last-Modified", null);
            }
            if (this.committed) {
                if (this.out.out == null) {
                    throw new RuntimeException("Internal Server Error, out was null");
                }
                return;
            }
            if (this.request.isDispatcherChainEmpty()) {
                this.out.checkSetContentLength();
            }
            this.committed = true;
            byte[] buffer = this.responseHeaderBuffer;
            int bufferPos = 0;
            if (!(application == null || application.chainingHandlers == null || this.status != 0 && this.status != 200 || this.contentType == null || this.request.method == "HEAD" || this.status == 204 || this.status >= 100 && this.status < 200 || (handler = application.chainingHandlers.get(this.contentType)) == null)) {
                ServletInstanceInfo info;
                if (handler instanceof ByteString) {
                    try {
                        info = application.findServlet((ByteString)handler);
                        if (info != null) {
                            application.chainingHandlers.put(this.contentType, info);
                        }
                    }
                    catch (ServletException e) {
                        info = null;
                    }
                } else {
                    info = (ServletInstanceInfo)handler;
                }
                if (info != null && (info.invalidated || info.autoReload && info.file != null && (info.file.lastModified() > info.binaryLastModified || info.sourceFile != null && info.sourceFile.lastModified() > info.sourceLastModified))) {
                    application.flushServlet(info.name, true);
                    handler = info.name;
                    info = null;
                }
                if (info == null) {
                    try {
                        info = application.findServlet((ByteString)handler);
                    }
                    catch (ServletException e) {
                        // empty catch block
                    }
                    if (info != null) {
                        application.chainingHandlers.put(this.contentType, info);
                    }
                }
                if (info == null) {
                    this.sendError(500, "Failed to initialize chaining servlet for contenttype " + this.contentType + " (" + handler + ")");
                    if (this.out.contentLength == 0) {
                        this.out.contentLength = -1;
                    }
                } else if (!(this.request.in instanceof ByteArrayInputStream) || this.contentType == null || !this.contentType.equals(this.request.contentType)) {
                    this.chainingHandler = info;
                    if (this.contentLength >= 0) {
                        this.out.contentLength = this.contentLength;
                        this.out.out = new ByteArrayOutputStream(this.contentLength);
                    } else {
                        this.out.out = new ByteArrayOutputStream();
                        this.out.contentLength = -1;
                    }
                    return;
                }
            }
            if (application != null && application.requestTracker != null) {
                this.handleRequestTrackers(application);
            }
            if (this.status == 0) {
                System.arraycopy(DEFAULT_RESPONSE, 0, buffer, bufferPos, DEFAULT_RESPONSE.length);
                bufferPos += DEFAULT_RESPONSE.length;
            } else if (this.status == 304) {
                System.arraycopy(NOT_MODIFIED_RESPONSE, 0, buffer, bufferPos, NOT_MODIFIED_RESPONSE.length);
                bufferPos += NOT_MODIFIED_RESPONSE.length;
                hasBody = false;
            } else {
                System.arraycopy(RESPONSE_VERSION, 0, buffer, 0, RESPONSE_VERSION.length);
                statusMessageArray = statusNumAsByteArray[this.status];
                System.arraycopy(statusMessageArray, 0, buffer, bufferPos += RESPONSE_VERSION.length, statusMessageArray.length);
                bufferPos += statusMessageArray.length;
                statusMessageArray = null;
                String returnMessage = this.statusMessage;
                statusMessageArray = returnMessage != null ? returnMessage.getBytes() : HttpServer.getStatusCodeDescriptionByteArray(this.status, null);
                if (statusMessageArray != null) {
                    buffer[bufferPos++] = 32;
                    System.arraycopy(statusMessageArray, 0, buffer, bufferPos, statusMessageArray.length);
                    bufferPos += statusMessageArray.length;
                }
                buffer[bufferPos++] = 13;
                buffer[bufferPos++] = 10;
            }
            try {
                if (!hasBody) {
                    this.out.contentLength = -2;
                    this.out.out = this.basicOut;
                } else if (!(this.contentLength >= 0 && this.contentLength <= 50000 || this.status == 206 || this.request.getVersion() < 11 || this.containsHeader("Transfer-Encoding"))) {
                    this.keepAlive = true;
                    this.setHeader_oc4j("Transfer-Encoding", "chunked");
                    this.out.out = new ChunkedOutputStream(this.basicOut);
                    this.out.contentLength = -1;
                    this.contentLength = -1;
                    this.contentLengthHeader = null;
                } else {
                    this.out.out = this.basicOut;
                    this.out.contentLength = this.contentLength;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.out.out = this.basicOut;
                this.out.contentLength = this.contentLength;
            }
            statusMessageArray = HttpDateFormat.dateHeader;
            System.arraycopy(statusMessageArray, 0, buffer, bufferPos, statusMessageArray.length);
            System.arraycopy(EvermindHttpServletRequest.HEADER_SERVER, 0, buffer, bufferPos += statusMessageArray.length, EvermindHttpServletRequest.HEADER_SERVER.length);
            bufferPos += EvermindHttpServletRequest.HEADER_SERVER.length;
            if (this.contentLocation != null) {
                ByteString contentLocation = this.contentLocation;
                int contentLocationLength = contentLocation.length;
                if (contentLocationLength < 400) {
                    System.arraycopy(CONTENT_LOCATION, 0, buffer, bufferPos, CONTENT_LOCATION.length);
                    bufferPos += CONTENT_LOCATION.length;
                    buffer[bufferPos++] = 104;
                    buffer[bufferPos++] = 116;
                    buffer[bufferPos++] = 116;
                    buffer[bufferPos++] = 112;
                    if (this.request.site.secure) {
                        buffer[bufferPos++] = 115;
                    }
                    buffer[bufferPos++] = 58;
                    buffer[bufferPos++] = 47;
                    buffer[bufferPos++] = 47;
                    ByteString hostHeader = this.request.getHostnameHeader();
                    if (hostHeader == null) {
                        hostHeader = this.request.site.host;
                    }
                    System.arraycopy(hostHeader.data, hostHeader.offset, buffer, bufferPos, hostHeader.length);
                    bufferPos += hostHeader.length;
                    if (this.request.site.secure ? this.request.site.posingAsPort != 443 : this.request.site.posingAsPort != 80) {
                        buffer[bufferPos++] = 58;
                        bufferPos = ArrayUtils.writeInt(buffer, bufferPos, this.request.site.posingAsPort);
                    }
                    if (application.root != null) {
                        System.arraycopy(application.root.data, application.root.offset, buffer, bufferPos, application.root.length);
                        bufferPos += application.root.length;
                    }
                    System.arraycopy(contentLocation.data, contentLocation.offset, buffer, bufferPos, contentLocationLength);
                    bufferPos += contentLocationLength;
                }
                buffer[bufferPos++] = 13;
                buffer[bufferPos++] = 10;
            }
            if (this.lastModifiedHeader != null) {
                System.arraycopy(this.lastModifiedHeader, 0, buffer, bufferPos, this.lastModifiedHeader.length);
                System.arraycopy(ACCEPT_RANGES_BYTES_HEADER, 0, buffer, bufferPos += this.lastModifiedHeader.length, ACCEPT_RANGES_BYTES_HEADER.length);
                bufferPos += ACCEPT_RANGES_BYTES_HEADER.length;
            }
            if (this.contentLengthHeader != null) {
                System.arraycopy(this.contentLengthHeader, 0, buffer, bufferPos, this.contentLengthHeader.length);
                bufferPos += this.contentLengthHeader.length;
                buffer[bufferPos++] = 13;
                buffer[bufferPos++] = 10;
            } else if (this.contentLength >= 0) {
                System.arraycopy(CONTENT_LENGTH_HEADER, 0, buffer, bufferPos, CONTENT_LENGTH_HEADER.length);
                bufferPos += CONTENT_LENGTH_HEADER.length;
                int magnitude = 1;
                int tempLength = this.contentLength;
                while ((tempLength /= 10) > 0) {
                    ++magnitude;
                }
                int counter = magnitude--;
                tempLength = this.contentLength;
                while (magnitude >= 0) {
                    buffer[bufferPos + magnitude] = (byte)(tempLength % 10 + 48);
                    tempLength /= 10;
                    --magnitude;
                }
                bufferPos += counter;
                buffer[bufferPos++] = 13;
                buffer[bufferPos++] = 10;
            }
            if (this.expiresHeader != null) {
                System.arraycopy(this.expiresHeader, 0, buffer, bufferPos, this.expiresHeader.length);
                bufferPos += this.expiresHeader.length;
                buffer[bufferPos++] = 13;
                buffer[bufferPos++] = 10;
            }
            if (this.eTagHeader != null) {
                System.arraycopy(this.eTagHeader, 0, buffer, bufferPos, this.eTagHeader.length);
                bufferPos += this.eTagHeader.length;
                buffer[bufferPos++] = 13;
                buffer[bufferPos++] = 10;
            }
            if (this.cookies != null || this.sessionCookieValue != null) {
                if (this.cookies != null) {
                    this.basicOut.write(buffer, 0, bufferPos);
                    bufferPos = 0;
                    this.writeCookies(this.cookies);
                }
                if (this.sessionCookieValue != null) {
                    System.arraycopy(this.sessionCookiePrefix, 0, buffer, bufferPos, this.sessionCookiePrefix.length);
                    System.arraycopy(this.sessionCookieValue, 0, buffer, bufferPos += this.sessionCookiePrefix.length, this.sessionCookieValue.length);
                    byte[] sessionCookieSuffix = application.getSessionCookieSuffix();
                    System.arraycopy(sessionCookieSuffix, 0, buffer, bufferPos += this.sessionCookieValue.length, sessionCookieSuffix.length);
                    bufferPos += sessionCookieSuffix.length;
                    if (this.request.isSecure() && !this.request.isApplicationShared() || application.getConfig().getSessionCookieIsSecure()) {
                        System.arraycopy(HttpApplication.SECURE_COOKIE_ATTRIBUTE, 0, buffer, bufferPos, HttpApplication.SECURE_COOKIE_ATTRIBUTE.length);
                        bufferPos += HttpApplication.SECURE_COOKIE_ATTRIBUTE.length;
                    }
                    if (HTTPProperties.getHttpOnly()) {
                        System.arraycopy(HttpApplication.HTTPONLY_COOKIE_ATTRIBUTE, 0, buffer, bufferPos, HttpApplication.HTTPONLY_COOKIE_ATTRIBUTE.length);
                        bufferPos += HttpApplication.HTTPONLY_COOKIE_ATTRIBUTE.length;
                    }
                    buffer[bufferPos++] = 13;
                    buffer[bufferPos++] = 10;
                }
                if (this.headerCount == 0 || !this.containsHeader("Cache-Control")) {
                    System.arraycopy(CACHE_CONTROL_PRIVATE_HEADER, 0, buffer, bufferPos, CACHE_CONTROL_PRIVATE_HEADER.length);
                    bufferPos += CACHE_CONTROL_PRIVATE_HEADER.length;
                }
            }
            if (this.request.site.useKeepAlives && (!hasBody || this.keepAlive || this.contentLength >= 0) && this.request.persistentConnectionRequested()) {
                this.keepAlive = true;
                System.arraycopy(KEEP_ALIVE_COMBO_HEADERS, 0, buffer, bufferPos, KEEP_ALIVE_COMBO_HEADERS.length);
                bufferPos += KEEP_ALIVE_COMBO_HEADERS.length;
            } else {
                this.keepAlive = false;
                System.arraycopy(CONNECTION_CLOSE_HEADER, 0, buffer, bufferPos, CONNECTION_CLOSE_HEADER.length);
                bufferPos += CONNECTION_CLOSE_HEADER.length;
            }
            if (this.contentType == null) {
                this.contentType = application.getMimeType(this.request.requestURI.toString());
                if (this.contentType == null && application.getConfig().isExplicitDefaultContentType()) {
                    this.contentType = application.defaultContentType;
                    if (this.charset != null) {
                        this.contentType = EvermindHttpServletResponse.constructContentType(this.contentType, this.charset);
                    }
                }
            }
            if (this.contentTypeHeader != null || this.contentType != null) {
                System.arraycopy(CONTENT_TYPE_HEADER, 0, buffer, bufferPos, CONTENT_TYPE_HEADER.length);
                bufferPos += CONTENT_TYPE_HEADER.length;
                if (this.contentTypeHeader != null) {
                    System.arraycopy(this.contentTypeHeader.data, this.contentTypeHeader.offset, buffer, bufferPos, this.contentTypeHeader.length);
                    bufferPos += this.contentTypeHeader.length;
                    if (!EvermindHttpServletResponse.isCompleteContentTypeHeader(this.contentTypeHeader.toString())) {
                        HttpMessages.warnIncompleteContentTypeHeader(this.contentTypeHeader.toString(), this.getRequestURI());
                    }
                } else {
                    String combinedContentType = this.contentType.toString();
                    statusMessageArray = combinedContentType.getBytes();
                    System.arraycopy(statusMessageArray, 0, buffer, bufferPos, statusMessageArray.length);
                    bufferPos += statusMessageArray.length;
                    if (!EvermindHttpServletResponse.isCompleteContentTypeHeader(combinedContentType)) {
                        HttpMessages.warnIncompleteContentTypeHeader(combinedContentType, this.getRequestURI());
                    }
                }
                buffer[bufferPos++] = 13;
                buffer[bufferPos++] = 10;
            } else {
                HttpMessages.warnNoContentTypeHeader(this.getRequestURI());
            }
            if (this.headerCount != 0 && (bufferPos = this.writeDefinedHeaders(this.headers, buffer, bufferPos)) >= buffer.length - 2) {
                this.basicOut.write(buffer, 0, bufferPos);
                bufferPos = 0;
            }
            buffer[bufferPos++] = 13;
            buffer[bufferPos++] = 10;
            if (m_traceLogger.isLoggable(Level.FINEST)) {
                m_traceLogger.log(Level.FINEST, "*********** RESPONSE ************");
                m_traceLogger.log(Level.FINEST, new String(buffer, 0, bufferPos));
                m_traceLogger.log(Level.FINEST, "*********** RESPONSE DONE ************");
            }
            if (this.out.bufferLength >= this.out.bufferPos + bufferPos && this.out.out == this.basicOut && this.chainingHandler == null && this.request.originalApplication == null) {
                if (this.out.bufferPos > 0) {
                    System.arraycopy(this.out.buffer, 0, this.out.buffer, bufferPos, this.out.bufferPos);
                }
                System.arraycopy(buffer, 0, this.out.buffer, 0, bufferPos);
                this.out.bufferPos += bufferPos;
                this.out.lastByteFlushed = -1;
            } else {
                this.basicOut.write(buffer, 0, bufferPos);
            }
        }
        catch (IOException e) {
            this.committed = false;
            this.request.application.log(e.getMessage());
        }
        catch (Throwable t) {
            HttpMessages.internalErrorWhileCommitting(t);
            throw (RuntimeException)t;
        }
    }

    private void writeCookies(Cookie[] cookies) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            buffer.append("Set-Cookie: ");
            this.writeCookieValue(buffer, cookie);
            buffer.append("\r\n");
        }
        this.basicOut.write(buffer.toString().getBytes());
    }

    protected void writeCookieValue(StringBuffer buffer, Cookie cookie) {
        int version = cookie.getVersion();
        if (EvermindHttpServletRequest.ENCODE_COOKIE) {
            buffer.append(CookieValueCoder.defaultInstance().responseRepresentation(cookie.getName(), cookie.getValue()));
        } else {
            buffer.append(cookie.getName());
            buffer.append("=");
            if (cookie.getValue() != null) {
                buffer.append(cookie.getValue());
            }
        }
        if (version != 0) {
            buffer.append("; Version=");
            buffer.append(String.valueOf(cookie.getVersion()));
        }
        String comment = cookie.getComment();
        String path = cookie.getPath();
        String domain = cookie.getDomain();
        if (comment != null) {
            buffer.append("; Comment=");
            buffer.append(comment);
        }
        int maxAge = cookie.getMaxAge();
        if (domain != null) {
            buffer.append("; Domain=");
            buffer.append(domain);
        }
        if (maxAge != -1) {
            if (version > 0) {
                buffer.append("; Max-Age=");
                buffer.append(String.valueOf(maxAge));
            } else {
                buffer.append("; Expires=");
                if (maxAge == 0) {
                    buffer.append(EARLY_DATE_STRING);
                } else {
                    buffer.append(HttpDateFormat.format3(System.currentTimeMillis() + (long)maxAge * 1000L));
                }
            }
        }
        if (path != null) {
            buffer.append("; Path=");
            buffer.append(path);
        }
        if (cookie.getSecure()) {
            buffer.append("; Secure");
        }
    }

    private int writeDefinedHeaders(String[] headers, byte[] buffer, int bufferPos) throws IOException {
        int headerCount = this.headerCount;
        for (int i = 0; i < headerCount; ++i) {
            if (headers[i * 2 + 1] == null) continue;
            String key = headers[i * 2];
            int keyLength = key.length();
            String value = headers[i * 2 + 1];
            int valueLength = value.length();
            boolean keyWritten = false;
            boolean valueWritten = false;
            if (keyLength + bufferPos > buffer.length) {
                this.basicOut.write(buffer, 0, bufferPos);
                bufferPos = 0;
                if (keyLength > buffer.length) {
                    byte[] keyData = key.getBytes("ISO-8859-1");
                    this.basicOut.write(keyData, 0, keyData.length);
                    keyWritten = true;
                }
            }
            if (!keyWritten) {
                for (int x = 0; x < keyLength; ++x) {
                    buffer[bufferPos++] = ObjectUtils.toByte(key.charAt(x));
                }
            }
            if (bufferPos >= buffer.length - 1) {
                this.basicOut.write(buffer, 0, bufferPos);
                bufferPos = 0;
            }
            buffer[bufferPos++] = 58;
            buffer[bufferPos++] = 32;
            if (valueLength + bufferPos > buffer.length) {
                this.basicOut.write(buffer, 0, bufferPos);
                bufferPos = 0;
                if (valueLength > buffer.length) {
                    byte[] valueData = value.getBytes("ISO-8859-1");
                    this.basicOut.write(valueData, 0, valueData.length);
                    valueWritten = true;
                }
            }
            if (!valueWritten) {
                for (int x = 0; x < valueLength; ++x) {
                    buffer[bufferPos++] = ObjectUtils.toByte(value.charAt(x));
                }
            }
            if (bufferPos >= buffer.length) {
                this.basicOut.write(buffer, 0, bufferPos);
                bufferPos = 0;
            }
            buffer[bufferPos++] = 13;
            buffer[bufferPos++] = 10;
        }
        return bufferPos;
    }

    public String getCharacterEncoding() {
        if (this.charset != null) {
            return this.charset;
        }
        String acceptHeader = this.request.getHeader(EvermindHttpServletRequest.ACCEPT_CHARSET_HEADER);
        if (acceptHeader != null && acceptHeader.indexOf("*") <= -1) {
            this.charset = acceptHeader.indexOf(44) >= 0 ? acceptHeader.substring(0, acceptHeader.indexOf(44)).trim() : acceptHeader;
            this.isCharsetSet = true;
            int semi = this.charset.indexOf(59);
            if (semi != -1) {
                this.charset = this.charset.substring(0, semi);
            }
        } else {
            this.charset = "ISO-8859-1";
        }
        return this.charset;
    }

    ServletOutputStream getJspOutputStream() throws IOException {
        if (!this.isCharsetSet && !this.isCommitted()) {
            this.contentType = EvermindHttpServletResponse.constructContentType(this.contentType, "ISO-8859-1");
            this.contentTypeHeader = null;
            this.isCharsetSet = true;
        }
        if (this.request.method == "HEAD") {
            this.out.setIgnoreWrites();
        }
        if (this.getCurrentWriter() != null) {
            this.writer.flush();
        }
        return this.out;
    }

    ServletOutputStream getInternalOutputStream() throws IOException {
        if (this.outputFetchStatus == 2) {
            throw new IllegalStateException("Writer already retrieved");
        }
        this.outputFetchStatus = 1;
        if (this.request.method == "HEAD") {
            this.out.setIgnoreWrites();
        }
        if (this.getCurrentWriter() != null) {
            this.writer.flush();
        }
        return this.out;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.useJspOutputStream ? this.getJspOutputStream() : this.getInternalOutputStream();
    }

    public void setUseJspOutputStream(boolean useJspOutputStreamValue) {
        this.useJspOutputStream = useJspOutputStreamValue;
    }

    protected void resetPrintWriter() {
        if (this.writer != null) {
            ((ServletWriter)this.writer).primeReset();
        }
    }

    private PrintWriter createOrResetPrintWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        if (this.writer == null) {
            return new ServletWriter(out, encoding);
        }
        ((ServletWriter)this.writer).reset(out, encoding);
        return this.writer;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputFetchStatus == 1) {
            throw new IllegalStateException("OutputStream already retrieved");
        }
        if (!this.isCharsetSet) {
            this.setCharacterEncoding_oc4j("ISO-8859-1");
        }
        this.outputFetchStatus = (byte)2;
        if (this.writer == null || ((ServletWriter)this.writer).needsReset()) {
            if (this.request.method == "HEAD") {
                this.out.setIgnoreWrites();
            }
            try {
                this.writer = this.createOrResetPrintWriter((OutputStream)((Object)this.out), this.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                if (this.getCharacterEncoding().equalsIgnoreCase(THAI_CHARSET_IANA)) {
                    this.writer = this.createOrResetPrintWriter((OutputStream)((Object)this.out), THAI_CHARSET_JAVA);
                }
                if (this.contentType != null && this.contentType.indexOf("charset=") >= 0) {
                    throw e;
                }
                this.writer = this.createOrResetPrintWriter((OutputStream)((Object)this.out), "ISO-8859-1");
                this.charset = "ISO-8859-1";
            }
        }
        return this.writer;
    }

    protected String getInternalJavaCharacterEncoding() {
        String t_charset = this.getCharacterEncoding();
        if (t_charset != null && t_charset.equalsIgnoreCase(THAI_CHARSET_IANA)) {
            return THAI_CHARSET_JAVA;
        }
        return t_charset;
    }

    private void setContentType_oc4j(String type) {
        if (this.isCommitted()) {
            return;
        }
        if (type != null && type.trim().length() == 0) {
            type = null;
        }
        if (this.outputFetchStatus == 2) {
            type = EvermindHttpServletResponse.removeCharsetFromContentType(type);
        }
        this.setInternalContentType(type);
    }

    private void setContentLength_oc4j(int length) {
        if (this.committed) {
            return;
        }
        if (DEBUG_CONTENTLENGTH_SETTING) {
            m_traceLogger.log(Level.FINE, "Debug content lenght setting", new Throwable("setting contentLength to " + length));
        }
        this.contentLength = length < 0 ? -1 : length;
        if (this.outputFetchStatus == 2) {
            ((ServletWriter)this.writer).setContentLength(this.contentLength);
        }
        this.out.setContentLength(this.contentLength);
        this.contentLengthHeader = null;
    }

    protected int getContentLength() {
        return this.contentLength;
    }

    protected void addSessionCookie(EvermindHttpSession session) {
        this.addCookie_oc4j(session.createSessionCookie());
    }

    private void addCookie_oc4j(Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new Cookie[1];
            this.cookies[0] = cookie;
            return;
        }
        Cookie[] oldCookies = this.cookies;
        this.cookies = new Cookie[oldCookies.length + 1];
        System.arraycopy(oldCookies, 0, this.cookies, 0, oldCookies.length);
        this.cookies[oldCookies.length] = cookie;
    }

    public void addCookie(Cookie cookie) {
        if (this.shouldProceedWithMutation()) {
            this.addCookie_oc4j(cookie);
        }
    }

    public boolean containsHeader(String name) {
        if (this.headerCount == 0) {
            return false;
        }
        for (int i = 0; i < this.headerCount; ++i) {
            if (!this.headers[i * 2].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void setStatus(int sc, String sm) {
        if (this.shouldProceedWithMutation()) {
            this.statusMessage = sm;
            this.setStatus_oc4j(sc);
        }
    }

    private void setStatus_oc4j(int sc) {
        if (!this.isStatusImmutable) {
            this.status = sc;
        }
    }

    private void setImmutableStatus_oc4j(int sc) {
        this.setStatus_oc4j(sc);
        this.isStatusImmutable = true;
    }

    private void setHeader_oc4j(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            this.setContentType_oc4j(value);
            return;
        }
        if (name.equalsIgnoreCase("Last-modified")) {
            this.lastModifiedHeader = null;
        } else if (name.equalsIgnoreCase("Expires")) {
            this.expiresHeader = null;
        } else if (name.equalsIgnoreCase("Content-Location")) {
            this.contentLocation = null;
        } else if (name.equalsIgnoreCase("Content-Length")) {
            this.setContentLength_oc4j(Integer.parseInt(value));
            return;
        }
        if (this.headers == null) {
            this.headers = new String[4];
        }
        for (int i = 0; i < this.headerCount; ++i) {
            if (!this.headers[i * 2].equalsIgnoreCase(name)) continue;
            this.headers[i * 2 + 1] = value;
            return;
        }
        if (this.headerCount * 2 >= this.headers.length) {
            String[] newHeaders = new String[this.headers.length * 2];
            System.arraycopy(this.headers, 0, newHeaders, 0, this.headers.length);
            this.headers = newHeaders;
        }
        this.headers[this.headerCount * 2] = name;
        this.headers[this.headerCount * 2 + 1] = value;
        ++this.headerCount;
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, HttpDateFormat.format(date));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendError(int sc, String message) throws IOException {
        block38: {
            String headerMessage;
            block36: {
                if (DEBUG_CONTENTLENGTH_SETTING) {
                    m_traceLogger.log(Level.FINE, "sendError for " + this.request.requestURI + ": " + sc + ", " + message);
                }
                if (this.isCommitted()) {
                    throw new IllegalStateException("Response has already been committed");
                }
                this.reset_oc4j(false);
                headerMessage = HttpServer.getStatusCodeDescription(sc, message);
                if (this.request.application != null && this.request.application.errorPage != null) {
                    try {
                        block37: {
                            RequestDispatcher dispatcher;
                            String path = null;
                            if (sc < this.request.application.errorPage.length) {
                                path = this.request.application.errorPage[sc];
                            }
                            if (path == null) break block36;
                            if (path.startsWith("*")) {
                                if ((path = path.substring(1)).indexOf("://") < 0) {
                                    path = (this.request.site.secure ? "https://" : "http://") + this.request.site.host + (this.request.site.secure ? (this.request.site.posingAsPort == 443 ? "" : String.valueOf(this.request.site.posingAsPort)) : (this.request.site.posingAsPort == 80 ? "" : String.valueOf(this.request.site.posingAsPort))) + path;
                                }
                                this.sendRedirect(path);
                                break block36;
                            }
                            this.setStatus_oc4j(sc);
                            if (!path.startsWith("/")) {
                                path = "/" + path;
                            }
                            if ((dispatcher = this.request.application.getRequestDispatcher(path)) == null) break block36;
                            try {
                                if (message != null) {
                                    this.request.setAttribute_oc4j("javax.servlet.error.message", message);
                                }
                                this.request.setAttribute_oc4j("javax.servlet.error.status_code", new Integer(sc));
                                this.setStatus_oc4j(sc);
                                this.request.setAttribute_oc4j("javax.servlet.error.request_uri", this.request.getRequestURI());
                                this.request.setAttribute_oc4j("javax.servlet.error.servlet_name", this.request.servletName);
                                if (this.sendingError >= 8) {
                                    this.request.application.log("Recursive error in error-page calling for " + path, new ServletException("Recursive error in error-page calling for " + path + " (status " + this.status + ")"));
                                    try {
                                        this.getOutputStream().println("Recursive error in error-page calling for " + path + ", see the application log for details.");
                                        this.setStatus_oc4j(500);
                                    }
                                    catch (Throwable t) {}
                                    break block37;
                                }
                                this.sendingError = (byte)(this.sendingError + 1);
                                try {
                                    String mimeType = this.request.application.getMimeType(path);
                                    if (mimeType != null) {
                                        if (this.charset != null && mimeType.startsWith("text") && mimeType.indexOf("charset") == -1) {
                                            this.contentType = mimeType + "; charset=" + this.charset;
                                            this.contentTypeHeader = null;
                                        } else {
                                            this.contentType = mimeType;
                                            this.contentTypeHeader = null;
                                        }
                                    }
                                    this.setContentLength_oc4j(-1);
                                    String[] headers = this.getHeaders();
                                    String authHeaderName = null;
                                    String authHeaderValue = null;
                                    if (headers != null) {
                                        for (int i = 0; i < headers.length; ++i) {
                                            if (headers[i] == null || !headers[i].startsWith("WWW-Authenticate")) continue;
                                            authHeaderName = headers[i];
                                            authHeaderValue = headers[i + 1];
                                            i += 2;
                                        }
                                    }
                                    this.headerCount = 0;
                                    this.headers = null;
                                    this.cookies = null;
                                    if (authHeaderName != null) {
                                        this.setHeader_oc4j(authHeaderName, authHeaderValue);
                                    }
                                    dispatcher.forward((ServletRequest)this.request, (ServletResponse)this);
                                }
                                finally {
                                    this.sendingError = (byte)(this.sendingError - 1);
                                }
                            }
                            catch (Throwable t) {
                                if (t instanceof IOException) break block37;
                                this.request.application.log("Error in errorPage " + path, t);
                            }
                        }
                        this.commitAndIgnoreWrites();
                        return;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
            try {
                byte[] b;
                this.setStatus_oc4j(sc);
                this.statusMessage = headerMessage;
                StringBuffer buffer = new StringBuffer();
                buffer.append("<HTML><HEAD><TITLE>");
                buffer.append(sc);
                if (headerMessage != null) {
                    buffer.append(' ');
                    buffer.append(headerMessage);
                }
                buffer.append("</TITLE></HEAD><BODY><H1>");
                buffer.append(sc);
                if (headerMessage != null) {
                    buffer.append(' ');
                    buffer.append(headerMessage);
                }
                buffer.append("</H1>");
                if (message != null) {
                    buffer.append(message);
                }
                buffer.append("</BODY></HTML>");
                if (this.charset != null) {
                    this.contentType = "text/html; charset=" + this.charset;
                    this.contentTypeHeader = null;
                } else {
                    this.contentType = "text/html";
                    this.contentTypeHeader = null;
                }
                ServletUtils.setDefaultContentType(this.request, this);
                if (this.outputFetchStatus == 2) {
                    this.writer.print(buffer.toString());
                    this.writer.flush();
                    break block38;
                }
                try {
                    b = buffer.toString().getBytes(this.getInternalJavaCharacterEncoding());
                }
                catch (Throwable th) {
                    b = buffer.toString().getBytes();
                }
                if (this.request.method != "HEAD") {
                    this.out.write(b);
                }
                this.out.flush();
            }
            catch (Throwable t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                this.request.application.log("Internal error in sendError()", t);
            }
        }
        this.commitAndIgnoreWrites();
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    public void sendRedirect(String location) throws IllegalStateException, IOException {
        if (this.committed) {
            throw new IllegalStateException("Response has already been committed, be sure not to write to the OutputStream or to trigger a commit due to any other action before calling this method.");
        }
        location = this.toAbsolute(location);
        this.status = 302;
        this.setHeader_oc4j("Location", location);
        if (this.request.method != "HEAD" && !this.isCommitted()) {
            byte[] output = ("<HTML><HEAD><TITLE>Redirect to " + location + "</TITLE></HEAD><BODY>" + "<A HREF=\"" + location + "\">" + location + "</A></BODY></HTML>").getBytes();
            if (this.charset != null) {
                this.contentType = "text/html; charset=" + this.charset;
                this.contentTypeHeader = null;
            } else {
                this.contentType = "text/html";
                this.contentTypeHeader = null;
            }
            if (this.out == null) {
                this.getOutputStream();
            } else {
                this.out.resetBuffer();
            }
            this.out.write(output);
        }
        this.commitAndIgnoreWrites();
    }

    protected String getSessionId() {
        return this.request.session.id.toString();
    }

    public String encodeURL(String url) {
        if (!this.isEncodeable(url)) {
            return url;
        }
        int length = url.length();
        for (int i = 0; i < length; ++i) {
            int oldIDPos;
            char c = url.charAt(i);
            if (c != '?' && c != '#' && c != ';') continue;
            if (c == ';' && (oldIDPos = url.indexOf(";jsessionid=")) >= 0) {
                int oldIDEndPos = -1;
                for (int x = oldIDPos + ";jsessionid".length(); x < url.length(); ++x) {
                    c = url.charAt(x);
                    if (c != '?' && c != '#' && c != '&') continue;
                    oldIDEndPos = x;
                    break;
                }
                if (oldIDEndPos < 0) {
                    oldIDEndPos = url.length();
                }
                return url.substring(0, oldIDPos + ";jsessionid=".length()) + this.getSessionId() + url.substring(oldIDEndPos);
            }
            return url.substring(0, i) + ";jsessionid=" + this.getSessionId() + url.substring(i);
        }
        return url + ";jsessionid=" + this.getSessionId();
    }

    public String encodeRedirectURL(String url) {
        if (!this.isEncodeable(url)) {
            return url;
        }
        int length = url.length();
        for (int i = 0; i < length; ++i) {
            int oldIDPos;
            char c = url.charAt(i);
            if (c != '?' && c != '#' && c != ';') continue;
            if (c == ';' && (oldIDPos = url.indexOf(";jsessionid=")) >= 0) {
                int oldIDEndPos = -1;
                for (int x = oldIDPos + ";jsessionid".length(); x < url.length(); ++x) {
                    c = url.charAt(x);
                    if (c != '?' && c != '#' && c != '&') continue;
                    oldIDEndPos = x;
                    break;
                }
                if (oldIDEndPos < 0) {
                    oldIDEndPos = url.length();
                }
                return url.substring(0, oldIDPos + ";jsessionid=".length()) + this.getSessionId() + url.substring(oldIDEndPos);
            }
            return url.substring(0, i) + ";jsessionid=" + this.getSessionId() + url.substring(i);
        }
        return url + ";jsessionid=" + this.getSessionId();
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String getHttpDate(Date date) {
        return null;
    }

    public static String transferEncodeURL(String url) {
        if (url.indexOf(32) < 0) {
            return url;
        }
        StringBuffer buffer = new StringBuffer();
        int oldPos = 0;
        int pos = 0;
        while ((pos = url.indexOf(32, pos)) >= 0) {
            buffer.append(url.substring(oldPos, pos));
            buffer.append("%20");
            oldPos = ++pos;
        }
        buffer.append(url.substring(oldPos, url.length()));
        return buffer.toString();
    }

    public void handleException(Throwable t) throws IOException {
        this.handleException(t, this.request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(Throwable t, EvermindHttpServletRequest request) throws IOException {
        if (EvermindHttpServletRequest.executeBreakpointMethods) {
            EvermindHttpServletRequest.debugBreakpointMethod();
        }
        while (t instanceof ServletException && ((ServletException)t).getRootCause() != null) {
            t = ((ServletException)t).getRootCause();
        }
        if (t instanceof HttpIOException) {
            return;
        }
        if (this.out.out == null) {
            this.setContentLength_oc4j(-1);
            this.contentLengthHeader = null;
        }
        if (t instanceof HttpIOException) {
            throw (IOException)t;
        }
        if (request != null && request.application != null && request.application.exceptionPages != null) {
            Iterator iterator = request.application.exceptionPages.iterator();
            while (iterator.hasNext()) {
                ErrorPage errorPage = (ErrorPage)iterator.next();
                try {
                    Class<?> exceptionClass = Class.forName(errorPage.getExceptionType(), true, t.getClass().getClassLoader());
                    if (!exceptionClass.isAssignableFrom(t.getClass())) continue;
                    String path = errorPage.getLocation();
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    this.setErrorAttributes(request, t);
                    request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
                    request.setAttribute("javax.servlet.error.status_code", new Integer(500).toString());
                    request.setAttribute("javax.servlet.error.servlet_name", request.servletName);
                    this.setImmutableStatus_oc4j(500);
                    RequestDispatcher dispatcher = request.application.getRequestDispatcher(path);
                    if (dispatcher != null) {
                        if (this.sendingError >= 8) {
                            if (!(t instanceof IOException)) {
                                request.application.log("Recursive error in error-page calling for " + path, t);
                            }
                            try {
                                this.getOutputStream().println("Recursive error in error-page calling for " + path + ", see the application log for details.");
                                this.setStatus_oc4j(500);
                            }
                            catch (Throwable extraThrowable) {}
                        } else {
                            this.sendingError = (byte)(this.sendingError + 1);
                            try {
                                String mimeType = this.request.application.getMimeType(path);
                                if (mimeType != null) {
                                    if (this.charset != null && mimeType.startsWith("text") && mimeType.indexOf("charset") == -1) {
                                        this.contentType = mimeType + "; charset=" + this.charset;
                                        this.contentTypeHeader = null;
                                    } else {
                                        this.contentType = mimeType;
                                        this.contentTypeHeader = null;
                                    }
                                }
                                if (this.committed) {
                                    this.setContentLength_oc4j(-1);
                                    dispatcher.include((ServletRequest)request, (ServletResponse)this);
                                } else {
                                    dispatcher.forward((ServletRequest)request, (ServletResponse)this);
                                }
                            }
                            catch (Throwable requestException) {
                                this.handleException(requestException);
                            }
                            finally {
                                this.sendingError = (byte)(this.sendingError - 1);
                            }
                        }
                        return;
                    }
                    this.sendError(500, "Error-page '" + errorPage.getLocation() + "' not found");
                    return;
                }
                catch (Throwable t2) {
                }
            }
        }
        if (request != null) {
            if (request.application != null) {
                request.application.log("Servlet error", t, request);
                if (request.application.errorPage != null) {
                    this.setErrorAttributes(request, t);
                }
            } else if (request.site != null) {
                HttpMessages.internalErrorWithHeaderInfo(request.getHeadersFormatted(), t);
            }
        }
        String html = null;
        if (this.isSensitiveException(t)) {
            html = "<PRE>Servlet error: An exception occurred. For security reasons, it may not be included in this response. Please consult the application log for details.</PRE>";
        } else if (!request.getApplication().getConfig().isDevelopment()) {
            html = "<PRE>Servlet error: An exception occurred. The current application deployment descriptors do not allow for including it in this response. Please consult the application log for details.</PRE>";
        } else {
            String exceptionString = EvermindHttpServletResponse.throwableToString(t);
            if (request.application != null) {
                exceptionString = this.handleOracleJspLineMap(request.application, exceptionString, t);
                exceptionString = request.application.jspPageNameEncode(exceptionString, null);
                exceptionString = request.application.application.serverEncode(exceptionString);
            }
            exceptionString = EvermindHttpServletResponse.markupEncode(exceptionString);
            String string = html = t instanceof ServletException && t.getMessage() != null ? "<PRE>Servlet error: " + EvermindHttpServletResponse.escapeHTML(t.getMessage()) + "</PRE>" : "<PRE>" + exceptionString + "</PRE>";
        }
        if (!this.committed) {
            if (t instanceof UnavailableException) {
                if (((UnavailableException)t).isPermanent()) {
                    this.sendError(404, html);
                } else {
                    this.sendError(503, html);
                }
            } else {
                this.sendError(500, html);
            }
        } else {
            html = html + "</BODY></HTML>";
            byte[] htmlData = html.getBytes();
            if (this.out.contentLength == -1 || this.out.contentLength > this.out.bytesWritten + htmlData.length) {
                this.out.write(htmlData);
            }
        }
    }

    private boolean isSensitiveException(Throwable t) {
        return t.getClass().getName().startsWith("java.security.");
    }

    private void setErrorAttributes(EvermindHttpServletRequest request, Throwable t) {
        if (t != null) {
            request.setAttribute("javax.servlet.jsp.jspException", t);
            request.setAttribute("javax.servlet.error.exception", t);
            request.setAttribute("javax.servlet.error.exception_type", t.getClass());
            if (t.getMessage() != null) {
                request.setAttribute("javax.servlet.error.message", t.getMessage());
            }
        }
    }

    public static String throwableToString(Throwable t) throws IOException {
        ByteArrayOutputStream textOut = new ByteArrayOutputStream();
        t.printStackTrace(new PrintWriter(textOut, true));
        textOut.close();
        String msg = t.getMessage();
        if (msg != null) {
            String st = new String(textOut.toByteArray());
            int idx = st.indexOf(msg);
            if (idx == -1 || idx + msg.length() > st.length()) {
                return EvermindHttpServletResponse.escapeHTML(st);
            }
            return st.substring(0, idx) + EvermindHttpServletResponse.escapeHTML(msg) + st.substring(idx + msg.length());
        }
        return new String(textOut.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleOracleJspLineMap(ServletContext sc, String exceptionString, Throwable t) {
        try {
            JspInterface ojsp = null;
            if (this.request.getApplication().jspServletInstance != null) {
                ojsp = this.request.getApplication().jspServletInstance.jsp;
            }
            if (ojsp != null) {
                exceptionString = ojsp.insertJspLineInfo(exceptionString);
                return exceptionString;
            }
        }
        catch (Throwable th) {
            m_traceLogger.log(Level.FINE, "Error in handleOracleJspLineMap", th);
        }
        finally {
            return exceptionString;
        }
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setLocale(Locale locale) {
        if (this.shouldProceedWithMutation()) {
            String language;
            if (locale == null || this.isCommitted()) {
                return;
            }
            this.locale = locale;
            if (!this.isCharsetSet && this.outputFetchStatus != 2) {
                String _charset = this.request.application.config.getEncoding(locale.toString());
                if (_charset == null) {
                    _charset = this.request.application.config.getEncoding(locale.getLanguage());
                }
                if (_charset == null) {
                    _charset = SETLOCALE_DEFAULT_ENCODING;
                }
                if (!(this.contentType == null || this.charset != null && this.charset.equalsIgnoreCase(_charset))) {
                    this.contentType = EvermindHttpServletResponse.constructContentType(this.contentType, _charset);
                    this.contentTypeHeader = null;
                }
                this.charset = _charset;
            }
            if ((language = locale.getLanguage()) != null && language.length() > 0) {
                String country = locale.getCountry();
                if (country != null && country.length() > 0) {
                    this.setHeader_oc4j("Content-Language", language + "-" + country);
                } else {
                    this.setHeader_oc4j("Content-Language", language);
                }
            }
        }
    }

    public static String markupEncode(String exceptionString) {
        if (exceptionString.indexOf(60) >= 0) {
            exceptionString = StringUtils.replace(exceptionString, '<', "&lt;");
        }
        if (exceptionString.indexOf(62) >= 0) {
            exceptionString = StringUtils.replace(exceptionString, '>', "&gt;");
        }
        if (exceptionString.indexOf(LINE_SEPARATOR) >= 0) {
            exceptionString = StringUtils.replace(exceptionString, LINE_SEPARATOR, "<br>");
        }
        return exceptionString;
    }

    public void addHeader(String name, String value) {
        if (this.shouldProceedWithMutation()) {
            if (name.equalsIgnoreCase("Content-Type")) {
                this.setContentType_oc4j(value);
                return;
            }
            if (name.equalsIgnoreCase("Last-modified")) {
                this.lastModifiedHeader = null;
            } else if (name.equalsIgnoreCase("Expires")) {
                this.expiresHeader = null;
            } else if (name.equalsIgnoreCase("Content-Location")) {
                this.contentLocation = null;
            } else if (name.equalsIgnoreCase("Content-Length")) {
                this.setContentLength_oc4j(Integer.parseInt(value));
                return;
            }
            if (this.headers == null) {
                this.headers = new String[4];
            }
            if (this.headerCount * 2 >= this.headers.length) {
                String[] newHeaders = new String[this.headers.length * 2];
                System.arraycopy(this.headers, 0, newHeaders, 0, this.headers.length);
                this.headers = newHeaders;
            }
            this.headers[this.headerCount * 2] = name;
            this.headers[this.headerCount * 2 + 1] = value;
            ++this.headerCount;
        }
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, HttpDateFormat.format(date));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException("Response has already been committed");
        }
        PrintWriter writer = this.getCurrentWriter();
        if (writer != null) {
            int outLength = this.out.contentLength;
            try {
                this.out.contentLength = -3;
                ((ServletWriter)writer).resetBuffer();
            }
            finally {
                this.out.contentLength = outLength;
            }
        }
        this.out.bytesWritten = 0;
        this.out.bufferPos = 0;
    }

    private void reset_oc4j(boolean resetHeaders) {
        this.resetBuffer();
        this.contentLength = -1;
        this.contentLengthHeader = null;
        this.contentTypeHeader = null;
        this.contentType = null;
        if (resetHeaders) {
            this.cookies = null;
            this.headerCount = 0;
            this.headers = null;
        }
        this.status = 0;
    }

    public void flushBuffer() throws IOException {
        this.out.flushBuffer();
    }

    public void setBufferSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        if (size > 40960) {
            size = 40960;
        }
        if (this.out.bytesWritten > 0) {
            throw new IllegalStateException("Data has already been written to the OutputStream");
        }
        if (this.out.buffer == null) {
            this.out.buffer = new byte[size];
        } else if (this.out.buffer != null) {
            if (this.out.bufferPos > size) {
                throw new IllegalStateException("Data has already been written to the OutputStream");
            }
            if (this.out.buffer.length < size) {
                byte[] newBuffer = new byte[size];
                if (this.out.bufferPos > 0) {
                    System.arraycopy(this.out.buffer, 0, newBuffer, 0, this.out.bufferPos);
                }
                this.out.buffer = newBuffer;
            }
        }
        this.out.bufferLength = size;
    }

    public int getBufferSize() {
        if (this.out.buffer == null) {
            return 0;
        }
        return this.out.buffer.length;
    }

    protected OutputStream getBasicOut() {
        return this.basicOut;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void handleRequestTrackers(HttpApplication application) {
        for (int i = 0; i < application.requestTracker.length; ++i) {
            try {
                application.requestTracker[i].servlet.service((ServletRequest)this.request, (ServletResponse)this);
                continue;
            }
            catch (Throwable t) {
                application.log("Error in RequestTracker " + application.requestTracker[i].name, t, this.request);
            }
        }
    }

    protected byte[] getResponseHeaderBuffer() {
        return this.responseHeaderBuffer;
    }

    protected String getStatusMessage() {
        return this.statusMessage;
    }

    protected Cookie[] getCookies() {
        return this.cookies;
    }

    public int getHeaderCount() {
        return this.headerCount;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    private static String getCharsetFromContentType(String type) {
        int charsetLoc;
        if (type == null) {
            return null;
        }
        int semi = type.indexOf(";");
        if (semi != -1 && (charsetLoc = type.indexOf("charset=")) != -1 && charsetLoc > semi) {
            return type.substring(charsetLoc + 8).replace('\"', ' ').trim();
        }
        return null;
    }

    public void setInternalContentType(String type) {
        if (type == null) {
            this.contentType = null;
            this.contentTypeHeader = null;
            return;
        }
        String _charset = EvermindHttpServletResponse.getCharsetFromContentType(type);
        if (_charset != null) {
            if (this.outputFetchStatus == 2 && this.charset != null && !_charset.equalsIgnoreCase(this.charset)) {
                return;
            }
            this.charset = _charset;
            this.isCharsetSet = true;
            this.contentType = type;
            this.contentTypeHeader = null;
        } else if (type == "text/html") {
            if (this.charset == null || !this.isCharsetSet) {
                this.contentTypeHeader = TEXT_HTML_BYTESTRING;
                this.contentType = type;
            } else {
                this.contentTypeHeader = null;
                this.contentType = EvermindHttpServletResponse.constructContentType(type, this.charset);
            }
        } else if (type == "text/plain") {
            if (this.charset == null || !this.isCharsetSet) {
                this.contentTypeHeader = TEXT_PLAIN_BYTESTRING;
                this.contentType = type;
            } else {
                this.contentTypeHeader = null;
                this.contentType = EvermindHttpServletResponse.constructContentType(type, this.charset);
            }
        } else {
            this.contentTypeHeader = null;
            this.contentType = type;
        }
    }

    protected static String constructContentType(String type, String charset) {
        if (type == null) {
            return null;
        }
        if (charset == null) {
            return type;
        }
        int semi = type.indexOf(";");
        if (semi != -1) {
            type = type.substring(0, semi);
        }
        return type + "; charset=" + charset;
    }

    private boolean isEncodeable(String location) {
        if (!this.request.application.getConfig().getSessionCookieIsURLRewriting()) {
            return false;
        }
        if (location == null) {
            return false;
        }
        if (this.request.site.secure) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        EvermindHttpServletRequest hreq = this.request;
        HttpSession session = hreq.getSession(false);
        if (session == null) {
            return false;
        }
        if (hreq.isRequestedSessionIdFromCookie()) {
            return false;
        }
        URL url = null;
        boolean _wasAbsolute = true;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            try {
                _wasAbsolute = false;
                url = new URL(this.toAbsolute(location));
            }
            catch (MalformedURLException e2) {
                return false;
            }
        }
        if (_wasAbsolute) {
            int urlPort;
            if (!hreq.getScheme().equalsIgnoreCase(url.getProtocol())) {
                return false;
            }
            if (!hreq.getServerName().equalsIgnoreCase(url.getHost())) {
                return false;
            }
            int serverPort = hreq.getServerPort();
            if (serverPort == -1) {
                serverPort = "https".equals(hreq.getScheme()) ? 443 : 80;
            }
            if ((urlPort = url.getPort()) == -1) {
                urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
            }
            if (serverPort != urlPort) {
                return false;
            }
        }
        String contextPath = hreq.getContextPath();
        String file = null;
        return !(contextPath != null && contextPath.length() > 0 ? (file = url.getFile()) == null || !file.startsWith(contextPath) : contextPath != null && contextPath.length() == 0 && (file = url.getFile()).startsWith(".."));
    }

    private String toAbsolute(String location) {
        int pos;
        if (location.indexOf(":/") < 0) {
            StringBuffer url = new StringBuffer();
            String scheme = null;
            String hostName = null;
            if (this.request instanceof AJPHttpServletRequest) {
                String string = scheme = ((AJPHttpServletRequest)this.request).isSecure() ? "https" : "http";
                if (!HTTPProperties.getAjpUseServername() && this.request.getHostnameHeader() != null) {
                    hostName = this.request.getHostnameHeader().toString();
                }
            } else {
                scheme = this.request.getScheme();
            }
            int port = this.request.getServerPort();
            url.append(scheme);
            url.append("://");
            if (hostName == null) {
                hostName = this.request.getServerName();
            }
            url.append(hostName);
            if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                url.append(':');
                url.append(port);
            }
            if (!location.startsWith("/")) {
                String requestFile = this.request.getRequestURI();
                url.append(requestFile.substring(0, requestFile.lastIndexOf(47) + 1));
            } else {
                try {
                    if (ServerProperties.getApplicationServerDebug() && HTTPProperties.getHttpRedirectDebug() && m_traceLogger.isLoggable(Level.FINE)) {
                        m_traceLogger.log(Level.FINE, "--------------------------- " + location + " -------------------------");
                        m_traceLogger.log(Level.FINE, "Not root app: " + (this.request.application != this.request.site.getDefaultApplication()) + "(" + this.request.application.getConfig().getDisplayName() + " vs " + this.request.site.getDefaultApplication().getConfig().getDisplayName() + ")");
                        m_traceLogger.log(Level.FINE, "Site-relative resource exists: " + (this.request.application.site.getDefaultApplication().getRequestDispatcher(location) != null));
                        m_traceLogger.log(Level.FINE, "App-relative resource exists: " + (this.request.application.getRequestDispatcher(location) != null));
                        m_traceLogger.log(Level.FINE, "------------------------------------------------------------------");
                    }
                }
                catch (InstantiationException e) {
                    // empty catch block
                }
            }
            url.append(location);
            location = url.toString();
        }
        pos = (pos = location.indexOf("://")) < 0 ? 0 : (pos += 3);
        while (pos < location.length() && location.charAt(pos) != '?') {
            if (location.charAt(pos) == '/') {
                if (pos > 0 && location.charAt(pos - 1) == '/') {
                    location = location.substring(0, pos - 1) + location.substring(pos, location.length());
                    continue;
                }
                if (pos > 1 && location.charAt(pos - 1) == '.' && location.charAt(pos - 2) == '/') {
                    location = location.substring(0, pos - 2) + location.substring(pos, location.length());
                    --pos;
                    continue;
                }
                if (pos > 3 && location.charAt(pos - 1) == '.' && location.charAt(pos - 2) == '.' && location.charAt(pos - 3) == '/') {
                    int prevSegmentStart;
                    for (prevSegmentStart = pos - 4; prevSegmentStart > 0 && location.charAt(prevSegmentStart) != '/'; --prevSegmentStart) {
                    }
                    if (pos - prevSegmentStart == 6 && location.charAt(prevSegmentStart + 1) == '.' && location.charAt(prevSegmentStart + 2) == '.') {
                        ++pos;
                        continue;
                    }
                    location = location.substring(0, prevSegmentStart) + location.substring(pos, location.length());
                    pos = prevSegmentStart;
                    continue;
                }
                ++pos;
                continue;
            }
            ++pos;
        }
        return location;
    }

    protected static String escapeHTML(String message) {
        int messagelen = message.length();
        if (messagelen != 0) {
            StringBuffer newMessage = new StringBuffer();
            boolean foundSpecialChar = false;
            for (int counter = 0; counter < messagelen; ++counter) {
                char charElement = message.charAt(counter);
                if (charElement == '<') {
                    newMessage.append("&lt;");
                    foundSpecialChar = true;
                    continue;
                }
                if (charElement == '>') {
                    newMessage.append("&gt;");
                    foundSpecialChar = true;
                    continue;
                }
                if (!(charElement != '&' || messagelen - counter > 4 && message.charAt(counter + 1) == 'a' && message.charAt(counter + 2) == 'm' && message.charAt(counter + 3) == 'p' && message.charAt(counter + 4) == ';' || messagelen - counter > 3 && message.charAt(counter + 1) == 'l' && message.charAt(counter + 2) == 't' && message.charAt(counter + 3) == ';' || messagelen - counter > 3 && message.charAt(counter + 1) == 'g' && message.charAt(counter + 2) == 't' && message.charAt(counter + 3) == ';')) {
                    newMessage.append("&amp;");
                    foundSpecialChar = true;
                    continue;
                }
                newMessage.append(charElement);
            }
            if (foundSpecialChar) {
                return newMessage.toString();
            }
        }
        return message;
    }

    public String getContentType() {
        if (this.contentType == null && this.request.application.getConfig().isExplicitDefaultContentType()) {
            this.contentType = EvermindHttpServletResponse.constructContentType(this.request.application.defaultContentType, this.charset);
        }
        return this.contentType;
    }

    private void setCharacterEncoding_oc4j(String charset) {
        if (this.isCommitted() || this.outputFetchStatus == 2) {
            return;
        }
        if (charset != null && charset.length() == 0) {
            charset = null;
        }
        this.charset = charset;
        this.isCharsetSet = true;
        this.contentType = EvermindHttpServletResponse.constructContentType(this.contentType, charset);
        this.contentTypeHeader = null;
    }

    PrintWriter getCurrentWriter() {
        return this.outputFetchStatus == 2 ? this.writer : null;
    }

    static String removeCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int semi = contentType.indexOf(";");
        if (semi != -1) {
            return contentType.substring(0, semi);
        }
        return contentType;
    }

    public static EvermindHttpServletResponse getThreadResponse() {
        return ThreadState.getInheritableCurrentState().getApplicationServerThread().httpHandler.response;
    }

    private static boolean isCompleteContentTypeHeader(String cth) {
        if (cth.trim().startsWith("text")) {
            int length = cth.length();
            int semi = cth.indexOf(59);
            int slash = cth.indexOf(47);
            int equal = cth.indexOf(61);
            return slash > 0 && semi > slash + 1 && equal > semi + 6 && length > equal;
        }
        return true;
    }

    private String getRequestURI() {
        try {
            return this.request.requestURI.toString();
        }
        catch (Throwable t) {
            return "Unable to determine the request URI.";
        }
    }

    private boolean shouldProceedWithMutation() {
        if (this.request.isIncluded()) {
            if (!this.request.isJSPRequest() && this.request.getApplication().getConfig().isDevelopment()) {
                HttpMessages.warningHeaderModificationIsRejected(this.request.application.getName());
            }
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < statusNumAsByteArray.length; ++i) {
            EvermindHttpServletResponse.statusNumAsByteArray[i] = String.valueOf(i).getBytes();
        }
        SETLOCALE_DEFAULT_ENCODING = HTTPProperties.getSetLocaleDefaultEncoding();
        MAX_RESPONSE_HEADER_SIZE = SystemUtils.getSystemInteger("oracle.oc4j.ajp.responseheader.size", 8192);
        m_traceLogger = TraceLogger.getLogger(EvermindHttpServletResponse.class);
    }
}

