/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.EvermindJSPEngineInfo;
import com.evermind.server.http.EvermindPageContext;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspEngineInfo;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import oracle.oc4j.security.OC4JPrivilegedAction;
import oracle.oc4j.security.OC4JSecurity;

public class EvermindJSPFactory
extends JspFactory {
    private static EvermindPageContext[] contexts = new EvermindPageContext[10];
    private static int freeContexts;
    private static Object lock;
    private JspEngineInfo info;

    public PageContext getPageContext(final Servlet servlet, final ServletRequest request, final ServletResponse response, final String errorPageURL, final boolean needsSession, final int bufferSize, final boolean autoFlush) {
        if (!OC4JSecurity.isSecurityOn()) {
            return EvermindJSPFactory.getCachedPageContext(servlet, request, response, errorPageURL, needsSession, bufferSize, autoFlush);
        }
        OC4JPrivilegedAction.NoException action = new OC4JPrivilegedAction.NoException(){

            public Object oc4jRun() {
                return EvermindJSPFactory.getCachedPageContext(servlet, request, response, errorPageURL, needsSession, bufferSize, autoFlush);
            }
        };
        return (PageContext)OC4JSecurity.doPrivileged(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPageContextsPool() {
        Object object = lock;
        synchronized (object) {
            int index = contexts.length;
            while (--index >= 0) {
                EvermindJSPFactory.contexts[index] = null;
            }
            freeContexts = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PageContext getCachedPageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) {
        EvermindPageContext context;
        Object object = lock;
        synchronized (object) {
            context = freeContexts > 0 ? contexts[--freeContexts] : null;
        }
        if (context == null) {
            context = new EvermindPageContext();
        }
        try {
            context.initialize(servlet, request, response, errorPageURL, needsSession, bufferSize, autoFlush);
        }
        catch (IOException i) {
            return null;
        }
        return context;
    }

    public JspEngineInfo getEngineInfo() {
        if (this.info == null) {
            this.info = new EvermindJSPEngineInfo();
        }
        return this.info;
    }

    public void releasePageContext(PageContext genericContext) {
        this.releaseCachedPageContext(genericContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseCachedPageContext(PageContext genericContext) {
        try {
            EvermindPageContext pageContext = (EvermindPageContext)genericContext;
            pageContext.release();
            Object object = lock;
            synchronized (object) {
                if (freeContexts >= contexts.length) {
                    EvermindPageContext[] oldContexts = contexts;
                    contexts = new EvermindPageContext[oldContexts.length * 2];
                    System.arraycopy(oldContexts, 0, contexts, 0, oldContexts.length);
                }
                EvermindJSPFactory.contexts[EvermindJSPFactory.freeContexts++] = pageContext;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    static {
        lock = new Object();
    }
}

