/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.HttpIOException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

class EvermindServletInputStream
extends ServletInputStream {
    private EvermindHttpServletRequest request;
    private InputStream in;
    long bytesRead;
    long contentLength;
    private byte[] buffer;
    private int bufferPos;
    private int bufferLength;

    public EvermindServletInputStream(EvermindHttpServletRequest request, InputStream in, int contentLength) {
        this.request = request;
        this.in = in;
        this.contentLength = contentLength;
    }

    public int read() throws HttpIOException {
        if (this.bytesRead >= this.contentLength && this.contentLength >= 0L) {
            return -1;
        }
        if (this.request.inputStartPos < this.request.inputEndPos) {
            ++this.bytesRead;
            return (char)this.request.getInput()[this.request.inputStartPos++] & 0xFF;
        }
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        while (this.bufferPos >= this.bufferLength) {
            this.bufferPos = 0;
            if (this.contentLength < 0L) {
                if (this.bufferLength < 0) {
                    return -1;
                }
                this.bufferLength = 0;
                while (this.bufferPos >= this.bufferLength) {
                    this.bufferPos = 0;
                    try {
                        this.bufferLength = this.in.read(this.buffer, 0, this.buffer.length);
                        if (this.bufferLength >= 0) continue;
                        return -1;
                    }
                    catch (IOException e) {
                        throw new HttpIOException(e.getMessage());
                    }
                }
                if (this.bufferLength >= 0) continue;
                return -1;
            }
            long lengthLeft = this.contentLength - this.bytesRead;
            try {
                do {
                    this.bufferLength = this.in.read(this.buffer, 0, (long)this.buffer.length > lengthLeft ? (int)lengthLeft : this.buffer.length);
                } while (this.bufferLength == 0);
            }
            catch (IOException e) {
                throw new HttpIOException(e.getMessage());
            }
            if (this.bufferLength >= 0) continue;
            this.bufferLength = 0;
            throw new HttpIOException("Premature end of stream reached");
        }
        ++this.bytesRead;
        return (char)this.buffer[this.bufferPos++] & 0xFF;
    }

    public int read(byte[] data, int offset, int length) throws HttpIOException {
        int bytesToRead;
        if (offset < 0 || length < 0 || offset + length > data.length) {
            if (offset < 0) {
                throw new IndexOutOfBoundsException("The supplied offset was below zero (" + offset + ")");
            }
            if (length < 0) {
                throw new IndexOutOfBoundsException("The supplied length was below zero (" + length + ")");
            }
            throw new IndexOutOfBoundsException("The supplied offset + length did not fit into the supplied byte[] (offset + length = " + offset + " + " + length + " = " + (offset + length) + " vs byte[].length = " + data.length + ")");
        }
        if (this.bytesRead >= this.contentLength && this.contentLength >= 0L) {
            return -1;
        }
        if (this.bytesRead + (long)length >= this.contentLength) {
            if (this.contentLength >= 0L) {
                bytesToRead = (int)(this.contentLength - this.bytesRead);
            } else {
                if (this.bytesRead < 0L) {
                    return -1;
                }
                bytesToRead = length;
            }
        } else {
            bytesToRead = length;
        }
        int bytesActuallyRead = 0;
        if (this.request.inputStartPos < this.request.inputEndPos) {
            if (bytesToRead <= this.request.inputEndPos - this.request.inputStartPos) {
                this.bytesRead += (long)bytesToRead;
                System.arraycopy(this.request.getInput(), this.request.inputStartPos, data, offset, bytesToRead);
                this.request.inputStartPos += bytesToRead;
                return bytesToRead;
            }
            this.bytesRead += (long)(this.request.inputEndPos - this.request.inputStartPos);
            System.arraycopy(this.request.getInput(), this.request.inputStartPos, data, offset, this.request.inputEndPos - this.request.inputStartPos);
            bytesActuallyRead = this.request.inputEndPos - this.request.inputStartPos;
            bytesToRead -= bytesActuallyRead;
            bytesActuallyRead = this.request.inputEndPos - this.request.inputStartPos;
            this.request.inputStartPos = this.request.inputEndPos;
            return bytesActuallyRead;
        }
        if (this.buffer != null && this.bufferPos < this.bufferLength) {
            if (bytesToRead <= this.bufferLength - this.bufferPos) {
                this.bytesRead += (long)bytesToRead;
                System.arraycopy(this.buffer, this.bufferPos, data, offset, bytesToRead);
                this.bufferPos += bytesToRead;
                return bytesActuallyRead + bytesToRead;
            }
            System.arraycopy(this.buffer, this.bufferPos, data, offset, this.bufferLength - this.bufferPos);
            this.bytesRead += (long)(this.bufferLength - this.bufferPos);
            bytesToRead -= this.bufferLength - this.bufferPos;
            this.bufferPos = this.bufferLength;
            return bytesActuallyRead += this.bufferLength - this.bufferPos;
        }
        try {
            int inRead = this.in.read(data, offset + bytesActuallyRead, bytesToRead);
            if (inRead < 0) {
                this.bytesRead = this.contentLength;
                if (this.bytesRead < 0L && this.bufferLength == 0 && bytesActuallyRead == 0) {
                    return -1;
                }
            } else {
                bytesActuallyRead += inRead;
            }
            this.bytesRead += (long)bytesActuallyRead;
        }
        catch (IOException e) {
            throw new HttpIOException(e.getMessage());
        }
        return bytesActuallyRead;
    }

    public void empty() throws HttpIOException {
        int attempts = 0;
        if (this.contentLength < 0L) {
            if (this.buffer == null) {
                this.buffer = new byte[4096];
            }
            try {
                while (this.in.read(this.buffer) >= 0) {
                }
            }
            catch (IOException e) {
                throw new HttpIOException(e.getMessage());
            }
        } else {
            while (this.bytesRead < this.contentLength) {
                long skipped = this.skip(this.contentLength - this.bytesRead);
                if (skipped < 0L) {
                    throw new HttpIOException("premature POST end");
                }
                if (skipped != 0L || ++attempts < 10) continue;
                throw new HttpIOException("premature POST end");
            }
        }
    }

    private int reliableSocketRead(byte[] data, int offset, int length) throws HttpIOException {
        try {
            int i;
            int bytesRead = 0;
            while ((i = this.in.read(data, offset, length)) >= 0 && length > 0) {
                bytesRead += i;
                offset += i;
                length -= i;
            }
            return bytesRead;
        }
        catch (IOException e) {
            throw new HttpIOException(e.getMessage());
        }
    }

    public long skip(long length) throws HttpIOException {
        if (length > this.contentLength - this.bytesRead) {
            if (this.contentLength < 0L) {
                if (this.bufferPos < this.bufferLength) {
                    if (length > (long)(this.bufferLength - this.bufferPos)) {
                        int wasInBuffer = this.bufferLength - this.bufferPos;
                        length -= (long)(this.bufferLength - this.bufferPos);
                        this.bufferPos = this.bufferLength;
                        try {
                            return (long)wasInBuffer + this.in.skip(length);
                        }
                        catch (IOException e) {
                            throw new HttpIOException(e.getMessage());
                        }
                    }
                    this.bufferPos = (int)((long)this.bufferPos + length);
                    return length;
                }
            } else {
                length = this.contentLength - this.bytesRead;
            }
        }
        int bytesSkipped = 0;
        if (this.request.inputStartPos < this.request.inputEndPos) {
            int diff = this.request.inputEndPos - this.request.inputStartPos;
            if ((long)diff >= length) {
                this.request.inputStartPos = (int)((long)this.request.inputStartPos + length);
                this.bytesRead += length;
                return length;
            }
            bytesSkipped = diff;
            this.bytesRead += (long)diff;
            length -= (long)diff;
            this.request.inputStartPos = this.request.inputEndPos;
        }
        if (this.bufferPos < this.bufferLength) {
            int bufferLeft = this.bufferLength - this.bufferPos;
            if ((long)bufferLeft >= length) {
                this.bufferPos = (int)((long)this.bufferPos + length);
                this.bytesRead += length;
                return length;
            }
            this.bufferPos += bufferLeft;
            bytesSkipped += bufferLeft;
            this.bytesRead += (long)bufferLeft;
            length -= (long)bufferLeft;
        }
        try {
            int skipLength;
            if (length > 0L && (skipLength = (int)this.in.skip(length)) > 0) {
                bytesSkipped += skipLength;
                this.bytesRead += (long)skipLength;
            }
            return bytesSkipped;
        }
        catch (IOException e) {
            throw new HttpIOException(e.getMessage());
        }
    }
}

