/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class HttpApplicationReference
implements XMLizable {
    private String applicationName;
    private String httpApplicationName;
    private String root;
    private boolean preload;
    private long maxInactivityTime;
    private boolean share;
    private boolean isAccessLog = false;
    private boolean isDefault;
    private Object globalTldCache;
    private boolean ohsRouting = true;

    public HttpApplicationReference(String application, String name) {
        this.applicationName = application;
        this.httpApplicationName = name;
    }

    public boolean implies(HttpApplicationReference other) {
        if (other.applicationName != null && !other.applicationName.equals(this.applicationName)) {
            return false;
        }
        return other.httpApplicationName == null || other.httpApplicationName.equals(this.httpApplicationName);
    }

    public HttpApplicationReference(Node node, boolean isDefault) throws InstantiationException {
        this.isDefault = isDefault;
        this.applicationName = XMLUtils.getNodeAttribute(node, "application");
        this.httpApplicationName = XMLUtils.getNodeAttribute(node, "name");
        boolean bl = this.ohsRouting = !"false".equalsIgnoreCase(XMLUtils.getNodeAttribute(node, "ohs-routing"));
        if (this.applicationName == null) {
            throw new InstantiationException("Missing 'application' attribute in " + (isDefault ? "default-web-app" : "web-app") + " tag");
        }
        if (this.httpApplicationName == null) {
            throw new InstantiationException("Missing 'name' attribute in " + (isDefault ? "default-web-app" : "web-app") + " tag");
        }
        String root = XMLUtils.getNodeAttribute(node, "root");
        if (root != null) {
            if ((root = root.trim()).equals("") && !isDefault) {
                throw new InstantiationException("\nApplication " + this.applicationName + ":" + this.httpApplicationName + " bind \"" + root + "\" context root is not allowed!");
            }
            if (!root.startsWith("/")) {
                root = "/" + root;
            }
            if (!root.equals("/") && root.endsWith("/")) {
                root = root.substring(0, root.length() - 1);
            }
        }
        if (isDefault) {
            this.setRoot(root);
            this.preload = !"false".equalsIgnoreCase(XMLUtils.getNodeAttribute(node, "load-on-startup"));
        } else {
            if (root == null) {
                throw new InstantiationException("No root attribute specified in <web-app> tag");
            }
            this.setRoot(root);
            this.preload = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(node, "load-on-startup"));
        }
        long timeout = -1L;
        this.share = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(node, "shared"));
        this.isAccessLog = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(node, "access-log"));
        String timeoutString = XMLUtils.getNodeAttribute(node, "max-inactivity-time");
        if (timeoutString != null) {
            try {
                this.maxInactivityTime = Long.parseLong(timeoutString) * 60L * 1000L;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getHttpApplicationName() {
        return this.httpApplicationName;
    }

    public void setRoot(String root) {
        if (root == null) {
            this.root = "/";
            return;
        }
        this.root = root;
    }

    public long getMaxInactivityTime() {
        return this.maxInactivityTime;
    }

    public String getRoot() {
        return this.root;
    }

    public boolean preload() {
        return this.preload;
    }

    public final void setPreload() {
        this.preload = true;
    }

    public final void setPreload(boolean val) {
        this.preload = val;
    }

    public final void unsetPreload() {
        this.preload = false;
    }

    public void setShared(boolean isShared) {
        this.share = isShared;
    }

    public boolean isShared() {
        return this.share;
    }

    public void setAccessLog(boolean val) {
        this.isAccessLog = val;
    }

    public boolean isAccessLog() {
        return this.isAccessLog;
    }

    public String toString() {
        return "Web-app reference " + (this.applicationName == null ? "<all>" : this.applicationName) + ":" + (this.httpApplicationName == null ? "<all>" : this.httpApplicationName);
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        if (!this.isDefault && this.root == null) {
            throw new IllegalArgumentException("root attribute for web-app tag was not set");
        }
        if (this.isDefault) {
            out.write(indention + "<default-web-app");
        } else {
            out.write(indention + "<web-app");
        }
        if (this.applicationName != null) {
            out.write(" application=\"" + XMLUtils.encode(this.applicationName) + "\"");
        }
        if (this.httpApplicationName != null) {
            out.write(" name=\"" + XMLUtils.encode(this.httpApplicationName) + "\"");
        }
        if (this.preload != this.isDefault) {
            out.write(" load-on-startup=\"" + (this.preload ? "true" : "false") + "\"");
        }
        if (!(this.root == null || this.root.equals("/") && this.isDefault)) {
            out.write(" root=\"" + XMLUtils.encode(this.root) + "\"");
        }
        if (this.maxInactivityTime > 0L) {
            out.write(" max-inactivity-time=\"" + this.maxInactivityTime + "\"");
        }
        if (this.share) {
            out.write(" shared=\"true\"");
        }
        if (this.isAccessLog) {
            out.write(" access-log=\"true\"");
        }
        if (!this.ohsRouting) {
            out.write(" ohs-routing=\"false\"");
        }
        out.println(" />");
    }

    boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Object getTldCache() {
        return this.globalTldCache;
    }

    public void setTldCache(Object globalTldCache) {
        this.globalTldCache = globalTldCache;
    }

    public void setOHSRouting(boolean value) {
        this.ohsRouting = value;
    }

    public boolean getOHSRouting() {
        return this.ohsRouting;
    }
}

