/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ThreadState;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.FileRequestDispatcher;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;

public class ResourceFilterChain
implements FilterChain {
    static final ResourceFilterChain INSTANCE = new ResourceFilterChain();

    public void doFilter(ServletRequest servletrequest, ServletResponse servletresponse) throws ServletException, IOException {
        EvermindHttpServletRequest evermindhttpservletrequest;
        if (servletrequest instanceof EvermindHttpServletRequest) {
            evermindhttpservletrequest = (EvermindHttpServletRequest)servletrequest;
        } else if (servletrequest instanceof HttpServletRequestWrapper) {
            evermindhttpservletrequest = ResourceFilterChain.unwrapRequest((ServletRequestWrapper)((HttpServletRequestWrapper)servletrequest));
        } else {
            ApplicationServerThread t = ThreadState.getInheritableCurrentState().getApplicationServerThread();
            evermindhttpservletrequest = t.httpHandler.request;
        }
        FileRequestDispatcher filerequestdispatcher = evermindhttpservletrequest.currentPostFilterFile;
        if (filerequestdispatcher != null) {
            block11: {
                if (evermindhttpservletrequest.currentFilePostFilterInclude) {
                    if (servletrequest instanceof EvermindHttpServletRequest && servletresponse instanceof EvermindHttpServletResponse) {
                        filerequestdispatcher.application.include(servletrequest, servletresponse, filerequestdispatcher.file, filerequestdispatcher.requestURI, true, filerequestdispatcher.fileInformation);
                        return;
                    }
                    filerequestdispatcher.application.includeGeneric(servletrequest, servletresponse, filerequestdispatcher.file, filerequestdispatcher.requestURI, true, filerequestdispatcher.fileInformation);
                    return;
                }
                try {
                    ((EvermindHttpServletResponse)servletresponse).contentTypeHeader = filerequestdispatcher.contentType;
                    ((EvermindHttpServletResponse)servletresponse).contentType = filerequestdispatcher.contentTypeString;
                }
                catch (ClassCastException _ex) {
                    if (filerequestdispatcher.contentType == null) break block11;
                    servletresponse.setContentType(filerequestdispatcher.contentType.toString());
                }
            }
            if (servletrequest instanceof EvermindHttpServletRequest && servletresponse instanceof EvermindHttpServletResponse) {
                filerequestdispatcher.application.include(servletrequest, servletresponse, filerequestdispatcher.file, filerequestdispatcher.requestURI, false, filerequestdispatcher.fileInformation);
                return;
            }
            filerequestdispatcher.application.includeGeneric(servletrequest, servletresponse, filerequestdispatcher.file, filerequestdispatcher.requestURI, false, filerequestdispatcher.fileInformation);
            return;
        }
        if (evermindhttpservletrequest.currentPostFilterServlet != null) {
            evermindhttpservletrequest.currentPostFilterServlet.service(servletrequest, servletresponse);
        }
    }

    private static EvermindHttpServletRequest unwrapRequest(ServletRequestWrapper originalRequest) {
        Object req = originalRequest.getRequest();
        try {
            while (!(req instanceof EvermindHttpServletRequest)) {
                req = ((ServletRequestWrapper)req).getRequest();
            }
        }
        catch (Throwable t) {
            req = ThreadState.getInheritableCurrentState().getApplicationServerThread().httpHandler.request;
        }
        return (EvermindHttpServletRequest)req;
    }
}

