/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.compiler.CompilationException;
import com.evermind.naming.ContextUtils;
import com.evermind.naming.archive.MemoryArchiveContext;
import com.evermind.server.Application;
import com.evermind.server.ServerComponent;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.compilation.Compilation;
import com.evermind.server.http.deployment.HttpApplicationDescriptor;
import com.evermind.util.ByteString;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.Notifier;

public class WrapperClassGenerator {
    private static Logger m_traceLogger = TraceLogger.getLogger(WrapperClassGenerator.class);

    private WrapperClassGenerator() {
    }

    public static void generateWebServiceArts(Application application, HttpApplication webApp, Notifier notifier) throws InstantiationException {
        String wsDeployed;
        HttpApplicationDescriptor webBundle = (HttpApplicationDescriptor)webApp.getConfig();
        String webAppDeployed = webBundle.isSynthetic() ? null : webBundle.isDeployed();
        ServerComponent webServicesDescriptor = (ServerComponent)((Object)webBundle.getWebServicesDescriptor());
        String string = webBundle.isSynthetic() ? null : (wsDeployed = webBundle.getWebServicesDescriptor() == null ? null : webServicesDescriptor.isDeployed());
        if (wsDeployed != null) {
            WrapperClassGenerator.generateTiesAndStubs(application, webBundle, webApp, webServicesDescriptor, notifier);
        } else if (!webBundle.getServiceReferences().isEmpty()) {
            if (webBundle.getWebServicesDescriptor() != null) {
                WrapperClassGenerator.generateTiesAndStubs(application, webBundle, webApp, webServicesDescriptor, notifier);
            } else {
                Compilation compilation = new Compilation(application, webBundle, webApp.getClasspath(), webApp.getClassLoader());
                try {
                    compilation.compileServiceRefs();
                }
                catch (CompilationException e) {
                    try {
                        throw new InstantiationException("Error compiling  :" + webBundle.getContext().getNameInNamespace() + ": " + e.getMessage());
                    }
                    catch (NamingException ne) {
                        throw new InstantiationException("Error compiling : " + webBundle.getName() + ": " + e.getMessage() + ":" + ne.getMessage());
                    }
                }
            }
            try {
                webBundle.storeDeployment();
            }
            catch (IOException e) {
                WrapperClassGenerator.throwStoreDeploymentError(webBundle, e, notifier);
            }
        }
        application.flushPropDD(webBundle, notifier);
    }

    private static void generateTiesAndStubs(Application application, HttpApplicationDescriptor webBundle, HttpApplication webApp, ServerComponent webServicesDescriptor, Notifier notifier) throws InstantiationException {
        try {
            Compilation compilation1 = new Compilation(application, webBundle, webApp.getClassPath(), webApp.getClassLoader());
            compilation1.compile();
            webBundle.mapWsdlImports();
            webServicesDescriptor.storeDeployment();
        }
        catch (CompilationException e) {
            try {
                throw new InstantiationException("Error compiling  :" + webBundle.getContext().getNameInNamespace() + ": " + e.getMessage());
            }
            catch (NamingException ne) {
                throw new InstantiationException("Error compiling : " + webBundle.getName() + ": " + e.getMessage() + ":" + ne.getMessage());
            }
        }
        catch (IOException e) {
            WrapperClassGenerator.throwStoreDeploymentError(webBundle, e, notifier);
        }
    }

    private static void throwStoreDeploymentError(HttpApplicationDescriptor webBundle, IOException e, Notifier notifier) throws InstantiationException {
        String msg = "Error storing oracle webservice deployment descriptor for web app " + webBundle.getName() + " : " + e.getMessage();
        if (notifier != null) {
            String[] params = new String[]{webBundle.getName()};
            notifier.sendNotification("ERROR_STORING_WEBSERVICE_DEPLOYMENT_DESC", params, e);
        } else {
            m_traceLogger.log(Level.FINE, msg);
        }
        throw new InstantiationException(msg);
    }

    public static File getWebServicesDeploymentCache(Context deploymentContext, String dcName) throws InstantiationException {
        File dcFile = null;
        try {
            Object object = deploymentContext.lookup(dcName);
            Context dcContext = null;
            if (object instanceof Context) {
                dcContext = (Context)object;
            } else if (object instanceof byte[]) {
                byte[] data = (byte[])object;
                dcContext = new MemoryArchiveContext(deploymentContext, dcName, data, 0, data.length, false);
            } else if (object instanceof ByteString) {
                ByteString string = (ByteString)object;
                dcContext = new MemoryArchiveContext(deploymentContext, dcName, string.data, string.offset, string.length, false);
            }
            if (dcContext != null) {
                dcFile = ContextUtils.getFile(dcContext, false);
            }
        }
        catch (NameNotFoundException e) {
        }
        catch (NamingException e) {
        }
        catch (ClassCastException e) {
            m_traceLogger.log(Level.FINEST, "Exception: " + e.getMessage(), e);
        }
        catch (IOException e) {
            m_traceLogger.log(Level.FINEST, "Exception: " + e.getMessage(), e);
        }
        return dcFile;
    }
}

