/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.administration;

import com.evermind.server.XMLApplicationServerConfig;
import com.evermind.server.XMLServerConfig;
import com.evermind.server.http.HttpApplicationReference;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.HttpSite;
import com.evermind.server.http.XMLHttpSiteConfig;
import com.evermind.server.http.administration.DefaultHttpApplicationAdministrator;
import com.evermind.server.http.administration.DefaultHttpSiteAdministrator;
import com.evermind.server.http.administration.HttpApplicationAdministrator;
import com.evermind.server.http.administration.HttpServerAdministrator;
import com.evermind.server.http.administration.HttpSiteAdministrator;
import com.evermind.ssl.SSLConfig;
import com.evermind.util.ConfigUtils;
import com.evermind.xml.XMLConfig;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultHttpServerAdministrator
implements HttpServerAdministrator {
    private HttpServer server;

    public DefaultHttpServerAdministrator(HttpServer server) {
        this.server = server;
    }

    public HttpApplicationAdministrator getDefaultHttpApplication() throws InstantiationException {
        return new DefaultHttpApplicationAdministrator(null, this.server.getConfig().getDefaultHttpApplicationConfig().getConfiguration());
    }

    public List getSites() {
        List sites = this.server.getSites();
        ArrayList<DefaultHttpSiteAdministrator> admins = new ArrayList<DefaultHttpSiteAdministrator>();
        for (int i = 0; i < sites.size(); ++i) {
            HttpSite site = (HttpSite)sites.get(i);
            admins.add(new DefaultHttpSiteAdministrator(site, site.getConfig()));
        }
        return admins;
    }

    public List getSiteNames() {
        List sites = this.server.getSites();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < sites.size(); ++i) {
            HttpSite site = (HttpSite)sites.get(i);
            names.add(site.getName());
        }
        return names;
    }

    public HttpSiteAdministrator getSite(String name) {
        List sites = this.server.getSites();
        for (int i = 0; i < sites.size(); ++i) {
            HttpSite site = (HttpSite)sites.get(i);
            if (site.getName().equals(name)) {
                return new DefaultHttpSiteAdministrator(site, site.getConfig());
            }
            if (!site.getName().endsWith(".xml")) continue;
            String friendlyName = site.getName().substring(site.getName().lastIndexOf(47) + 1, site.getName().lastIndexOf(46));
            if (name.equals(friendlyName)) {
                return new DefaultHttpSiteAdministrator(site, site.getConfig());
            }
            try {
                URL url = new URL(name);
                File file = new File(url.getFile());
                String path = file.getCanonicalFile().toURL().toString();
                if (!site.getName().equals(path)) continue;
                return new DefaultHttpSiteAdministrator(site, site.getConfig());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    public HttpSiteAdministrator createSite(String displayName, String hostName, int port, String virtualHosts, String p_szProvider, String p_szFactory, String p_szKSPath, String p_szKSPasswd, String p_szClientAuth, String defaultWebAppApplication, String defaultWebAppName) throws IOException, InstantiationException {
        XMLHttpSiteConfig config = new XMLHttpSiteConfig((XMLServerConfig)((Object)this.server.getConfig()), (XMLApplicationServerConfig)this.server.getApplicationServer().getConfig());
        config.setAddress(InetAddress.getByName(hostName));
        config.setDisplayName(displayName);
        config.setPort(port);
        if (p_szKSPath != null) {
            config.setSecure(true);
            SSLConfig l_sslCfg = new SSLConfig(p_szProvider, p_szFactory, p_szKSPath, p_szKSPasswd, p_szClientAuth);
            config.setSSLConfig(l_sslCfg);
        }
        config.setVirtualHosts(virtualHosts);
        String filename = displayName;
        if (filename == null) {
            filename = virtualHosts != null ? virtualHosts : hostName + "_" + port;
        }
        filename = filename + "-web-site.xml";
        URL l_url = ConfigUtils.getURL(((XMLConfig)((Object)this.server.getConfig())).getURL(), filename);
        config.addApplication(new HttpApplicationReference(defaultWebAppApplication, defaultWebAppName));
        try {
            config.setURL(l_url);
            config.store();
        }
        catch (InstantiationException e) {
            // empty catch block
        }
        ((XMLApplicationServerConfig)this.server.getApplicationServer().getConfig()).addHttpSite("./" + filename, config);
        this.server.getApplicationServer().getConfig().store();
        this.server.setSites();
        Iterator iterator = this.server.getSites().iterator();
        while (iterator.hasNext()) {
            HttpSite site = (HttpSite)iterator.next();
            if (!site.getConfig().equals(config)) continue;
            return new DefaultHttpSiteAdministrator(site, config);
        }
        return null;
    }

    public HttpSiteAdministrator getSiteByHP(String p_szHost, int p_iPort) throws UnknownHostException, RemoteException, InstantiationException {
        List l_l = this.getSites();
        InetAddress l_iaAll = InetAddress.getByName("0.0.0.0");
        InetAddress l_iaInputAddress = InetAddress.getByName(p_szHost);
        InetAddress l_iaLocalHost = InetAddress.getByName("127.0.0.1");
        InetAddress l_iaLocalIP = InetAddress.getLocalHost();
        if (!(l_iaInputAddress.equals(l_iaAll) || l_iaInputAddress.equals(l_iaLocalHost) || l_iaInputAddress.equals(l_iaLocalIP))) {
            throw new InstantiationException("Invalid host name.");
        }
        for (int i = 0; i < l_l.size(); ++i) {
            HttpSiteAdministrator l_hsa = (HttpSiteAdministrator)l_l.get(i);
            Map l_map = l_hsa.getConfigurationInfo();
            Integer l_IPort = (Integer)l_map.get("port");
            if (l_IPort != p_iPort) continue;
            return l_hsa;
        }
        return null;
    }
}

