/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindDestination;
import com.evermind.server.jms.EvermindSession;
import com.evermind.server.jms.JMSDomain;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSObject;
import com.evermind.server.jms.JMSUtils;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import javax.management.j2ee.statistics.JMSEndpointStats;
import javax.management.j2ee.statistics.JMSProducerStats;

public class EvermindMessageProducer
extends JMSObject
implements MessageProducer,
JMSDomain {
    private final JMSProducerStats m_stats;
    private final EvermindSession m_sess;
    private final Destination m_dest;
    private final int m_domain;
    private int m_deliveryMode = 2;
    private int m_priority = 4;
    private long m_ttl = 0L;
    private boolean m_noMsgID = false;
    private boolean m_noTimestamp = false;
    public static final int MIN_PRIORITY = 0;
    public static final int MAX_PRIORITY = 9;
    public static final int NUM_PRIORITY = 10;

    EvermindMessageProducer(EvermindSession sess, Destination dest, int domain) throws JMSException {
        super("Producer", sess);
        this.m_sess = sess;
        this.m_dest = dest;
        this.m_domain = domain;
        EvermindDestination.checkDestination(dest);
        if ("jms/Oc4jJmsExceptionQueue".equals(JMSUtils.getName(dest))) {
            JMSUtils.toInvalidDestinationException(JMSMessages.getMessage("J2EE JMS-01800", dest));
        }
        this.m_sess.attach(this);
        this.state("domain", JMSUtils.pp(this.m_domain), true);
        this.state("destination", JMSUtils.getName(this.m_dest), true);
        this.state("deliveryMode", JMSUtils.ppDelMode(this.m_deliveryMode));
        this.state("priority", new Integer(this.m_priority));
        this.state("timeToLive", new Long(this.m_ttl));
        this.state("disableMessageID", new Boolean(this.m_noMsgID));
        this.state("disableMessageTimestamp", new Boolean(this.m_noTimestamp));
        this.initPhase("messageWaitTime");
        this.initEvent("expiredMessageCount");
        this.initEvent("messageCount");
        this.initEvent("pendingMessageCount");
        this.m_stats = EvermindMessageProducer.getProxy().getJMSProducerStats(JMSUtils.getName(this.m_dest), this.getJMSStats().getName());
        this.m_sess.add((JMSEndpointStats)this.m_stats);
        this.state("stats", this.m_stats, true);
    }

    public String toString() {
        String d = this.m_dest == null ? "" : "," + this.m_dest;
        return (this.m_domain == 0 ? "QueueSender" : (this.m_domain == 1 ? "TopicPublisher" : "MessageProducer")) + "[" + this.getID() + d + "]";
    }

    protected final void localClose() {
        this.m_sess.remove((JMSEndpointStats)this.m_stats);
    }

    protected final void localNextTrans() {
        this.initEvent("pendingMessageCount");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int getDeliveryMode() throws JMSException {
        this.lock("getDeliveryMode");
        try {
            int n = this.m_deliveryMode;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Destination getDestination() throws JMSException {
        this.lock("getDestination");
        try {
            Destination destination = this.m_dest;
            return destination;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean getDisableMessageID() throws JMSException {
        this.lock("getDisableMessageID");
        try {
            boolean bl = this.m_noMsgID;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean getDisableMessageTimestamp() throws JMSException {
        this.lock("getDisableMessageTimestamp");
        try {
            boolean bl = this.m_noTimestamp;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int getPriority() throws JMSException {
        this.lock("getPriority");
        try {
            int n = this.m_priority;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized long getTimeToLive() throws JMSException {
        this.lock("getTimeToLive");
        try {
            long l = this.m_ttl;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    public final synchronized void send(Message msg) throws JMSException {
        this.send(false, this.m_dest, msg, this.m_deliveryMode, this.m_priority, this.m_ttl);
    }

    public final synchronized void send(Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.send(false, this.m_dest, msg, deliveryMode, priority, ttl);
    }

    public final synchronized void send(Destination dest, Message msg) throws JMSException {
        this.send(true, dest, msg, this.m_deliveryMode, this.m_priority, this.m_ttl);
    }

    public final synchronized void send(Destination dest, Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.send(true, dest, msg, deliveryMode, priority, ttl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setDeliveryMode(int deliveryMode) throws JMSException {
        this.lock("setDeliveryMode");
        try {
            this.checkDeliveryMode(deliveryMode);
            this.m_deliveryMode = deliveryMode;
            this.state("deliveryMode", JMSUtils.ppDelMode(this.m_deliveryMode));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setDisableMessageID(boolean noMsgID) throws JMSException {
        this.lock("setDiableMessageID");
        try {
            this.m_noMsgID = noMsgID;
            this.state("disableMessageID", new Boolean(this.m_noMsgID));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setDisableMessageTimestamp(boolean noTimestamp) throws JMSException {
        this.lock("setDisableMessageTimestamp");
        try {
            this.m_noTimestamp = noTimestamp;
            this.state("disableMessageTimestamp", new Boolean(this.m_noTimestamp));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setPriority(int priority) throws JMSException {
        this.lock("setPriority");
        try {
            this.checkPriority(priority);
            this.m_priority = priority;
            this.state("priority", new Integer(this.m_priority));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setTimeToLive(long ttl) throws JMSException {
        this.lock("setTimeToLive");
        try {
            this.checkTtl(ttl);
            this.m_ttl = ttl;
            this.state("timeToLive", new Long(this.m_ttl));
        }
        finally {
            this.unlock();
        }
    }

    public final boolean isXA() {
        return this.m_sess.isXA();
    }

    public final int getDomain() {
        return this.m_domain;
    }

    private void checkDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode != 2 && deliveryMode != 1) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01801", this, new Integer(deliveryMode)));
        }
    }

    private void checkPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 9) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01802", this, new Integer(priority)));
        }
    }

    private void checkTtl(long ttl) throws JMSException {
        if (ttl < 0L) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01803", this, new Long(ttl)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(boolean explicitDest, Destination dest, Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.lock("send");
        try {
            if (explicitDest) {
                if (this.m_dest != null) {
                    throw new UnsupportedOperationException(JMSMessages.getMessage("J2EE JMS-01804", this, dest));
                }
                if (dest == null) {
                    JMSUtils.toInvalidDestinationException(JMSMessages.getMessage("J2EE JMS-01805", this));
                }
                EvermindDestination.checkDestination(dest);
            } else if (this.m_dest == null) {
                throw new UnsupportedOperationException(JMSMessages.getMessage("J2EE JMS-01805", this));
            }
            this.checkDeliveryMode(deliveryMode);
            this.checkPriority(priority);
            this.checkTtl(ttl);
            if (msg == null) {
                throw new MessageFormatException(JMSMessages.getMessage("J2EE JMS-01806", this));
            }
            this.m_sess.send(this, dest, msg, deliveryMode, priority, ttl, this.m_noMsgID, this.m_noTimestamp, this.getJMSStats());
        }
        finally {
            this.unlock();
        }
    }
}

