/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.CMTTricks;
import com.evermind.server.jms.ConfigPropertyEvent;
import com.evermind.server.jms.ConfigPropertyListener;
import com.evermind.server.jms.DummyStats;
import com.evermind.server.jms.EvermindBytesMessage;
import com.evermind.server.jms.EvermindConnection;
import com.evermind.server.jms.EvermindDestination;
import com.evermind.server.jms.EvermindMapMessage;
import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.EvermindMessageBrowser;
import com.evermind.server.jms.EvermindMessageConsumer;
import com.evermind.server.jms.EvermindMessageProducer;
import com.evermind.server.jms.EvermindObjectMessage;
import com.evermind.server.jms.EvermindQueueBrowser;
import com.evermind.server.jms.EvermindStreamMessage;
import com.evermind.server.jms.EvermindTemporaryDestination;
import com.evermind.server.jms.EvermindTemporaryQueue;
import com.evermind.server.jms.EvermindTemporaryTopic;
import com.evermind.server.jms.EvermindTextMessage;
import com.evermind.server.jms.EvermindTopicBrowser;
import com.evermind.server.jms.EvermindTopicSubscriber;
import com.evermind.server.jms.JMSCommands;
import com.evermind.server.jms.JMSDomain;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSObject;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.SessionID;
import com.evermind.server.jms.Tset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.management.j2ee.statistics.JMSEndpointStats;
import javax.management.j2ee.statistics.JMSSessionStats;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class EvermindSession
extends JMSObject
implements Session,
XAResource,
CMTTricks,
JMSDomain {
    private int m_subCount = 0;
    private final EvermindConnection m_conn;
    private final JMSSessionStats m_stats;
    private final boolean m_transacted;
    private final int m_ackMode;
    private final boolean m_isXA;
    private final int m_domain;
    private MessageListener m_listener = null;
    private final List m_msgs = new ArrayList();
    private long m_txid = 0L;
    private String m_localID;
    private final Tset m_inList = new Tset(false);
    private final Tset m_sessMod = new Tset(false);
    private final Tset m_sessRecovered = new Tset(false);
    private final Set m_listeners = new HashSet();
    private final Tset m_inLocal = new Tset(false);
    private int m_xaTimeout = Integer.MAX_VALUE;
    private Transaction m_appTrans = null;
    private Xid m_currXid = null;
    private String m_currXidStr = "null";
    private final Map m_xids = new HashMap();
    private final List m_prepXids = new ArrayList();
    private int m_prepCur = -1;
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(EvermindSession.class);
    private boolean m_xaEnlistmentWarningGiven;
    public static int s_listenerAttempts = (Integer)EvermindSession.getProxy().getPropertiesController().listenToConfigProperty("oc4j.jms.listenerAttempts", new ConfigPropertyListener(){

        public void onConfigPropertyChange(ConfigPropertyEvent event) {
            EvermindSession.setListenerAttempts((Integer)event.getPropertyValue());
        }
    });
    private static final boolean PSEUDO_TRANSACTION_ENLISTMENT = (Boolean)EvermindSession.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.pseudoTransactionEnlistment");

    EvermindSession(EvermindConnection conn, boolean transacted, int ackMode, boolean isXA, int domain) throws JMSException {
        super("Session", conn);
        if (PSEUDO_TRANSACTION_ENLISTMENT) {
            if (!transacted) {
                EvermindSession.verifyAckMode(ackMode);
            }
        } else if (!isXA && !transacted) {
            EvermindSession.verifyAckMode(ackMode);
        }
        this.m_conn = conn;
        this.m_transacted = transacted;
        this.m_ackMode = ackMode;
        this.m_isXA = isXA;
        this.m_domain = domain;
        this.setLocalID();
        this.m_conn.attach(this);
        this.state("domain", JMSUtils.pp(this.m_domain), true);
        this.state("isXA", new Boolean(this.m_isXA), true);
        this.state("transacted", new Boolean(this.m_transacted), true);
        this.state("acknowledgeMode", JMSUtils.ppAckMode(this.m_transacted, this.m_ackMode), true);
        this.state("durableSubscriptionCount", new Integer(0));
        this.initPhase("messageWaitTime");
        this.initEvent("expiredMessageCount");
        this.initEvent("messageCount");
        this.initEvent("pendingMessageCount");
        this.m_stats = EvermindSession.getProxy().getJMSSessionStats(this.getJMSStats().getName());
        this.state("stats", this.m_stats, true);
        this.m_conn.add(this.m_stats, this.m_transacted);
    }

    public String toString() {
        return JMSUtils.pp(this.m_isXA, this.m_domain) + "Session[" + this.getID() + "," + this.m_transacted + "," + JMSUtils.ppAckMode(this.m_transacted, this.m_ackMode) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void commit() throws JMSException {
        this.lock("commit");
        try {
            this.assertTransacted("commit");
            this.getServer().commit(new SessionID(this.getLocalID()));
            this.bumpTXID();
            this.m_inLocal.set(false);
            this.clearPending();
            if (this.m_inList.test()) {
                this.m_sessMod.set(true);
            }
            this.state("txid", new Long(this.m_txid));
        }
        finally {
            this.unlock();
        }
    }

    public final synchronized QueueBrowser createBrowser(Queue q) throws JMSException {
        return this.createBrowser(q, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized QueueBrowser createBrowser(Queue q, String selector) throws JMSException {
        this.lock("createBrowser");
        try {
            JMSUtils.assertDomain(this, 0, this.m_domain);
            EvermindQueueBrowser evermindQueueBrowser = new EvermindQueueBrowser(this, q, selector);
            return evermindQueueBrowser;
        }
        finally {
            this.unlock();
        }
    }

    public final synchronized BytesMessage createBytesMessage() throws JMSException {
        return (BytesMessage)this.makeMessage("createBytesMessage", 1, null);
    }

    public final synchronized MessageConsumer createConsumer(Destination dest) throws JMSException {
        return this.createConsumer(dest, null, false);
    }

    public final synchronized MessageConsumer createConsumer(Destination dest, String selector) throws JMSException {
        return this.createConsumer(dest, selector, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized MessageConsumer createConsumer(Destination dest, String selector, boolean noLocal) throws JMSException {
        this.lock("createConsumer");
        try {
            this.checkTemporaryDomain(dest);
            EvermindMessageConsumer evermindMessageConsumer = new EvermindMessageConsumer(this, dest, null, selector, noLocal, 2);
            return evermindMessageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    public final synchronized TopicSubscriber createDurableSubscriber(Topic t, String name) throws JMSException {
        return this.createDurableSubscriber(t, name, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized TopicSubscriber createDurableSubscriber(Topic t, String name, String selector, boolean noLocal) throws JMSException {
        this.lock("createDurableSubscriber");
        try {
            JMSUtils.assertDomain(this, 1, this.m_domain);
            if (JMSUtils.isNull(name)) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01201", this));
            }
            EvermindTopicSubscriber sub = new EvermindTopicSubscriber(this, t, name, selector, noLocal);
            this.state("durableSubscriptionCount", new Integer(++this.m_subCount));
            EvermindTopicSubscriber evermindTopicSubscriber = sub;
            return evermindTopicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    public final synchronized MapMessage createMapMessage() throws JMSException {
        return (MapMessage)this.makeMessage("createMapMessage", 2, null);
    }

    public final synchronized Message createMessage() throws JMSException {
        return this.makeMessage("createMessage", 3, null);
    }

    public final synchronized ObjectMessage createObjectMessage() throws JMSException {
        return (ObjectMessage)this.makeMessage("createObjectMessage", 4, null);
    }

    public final synchronized ObjectMessage createObjectMessage(Serializable body) throws JMSException {
        return (ObjectMessage)this.makeMessage("createObjectMessage", 4, body, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized MessageProducer createProducer(Destination dest) throws JMSException {
        this.lock("createProducer");
        try {
            this.checkTemporaryDomain(dest);
            EvermindMessageProducer evermindMessageProducer = new EvermindMessageProducer(this, dest, 2);
            return evermindMessageProducer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Queue createQueue(String qName) throws JMSException {
        this.lock("createQueue");
        try {
            JMSUtils.assertDomain(this, 0, this.m_domain);
            if (JMSUtils.isNull(qName)) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01900", this));
            }
            Queue queue = this.m_conn.createQueue(qName);
            return queue;
        }
        finally {
            this.unlock();
        }
    }

    public final synchronized StreamMessage createStreamMessage() throws JMSException {
        return (StreamMessage)this.makeMessage("createStreamMessage", 5, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized TemporaryQueue createTemporaryQueue() throws JMSException {
        this.lock("createTemporaryQueue");
        try {
            JMSUtils.assertDomain(this, 0, this.m_domain);
            String dName = JMSUtils.newID("TemporaryQueue");
            this.getServer().createTemporary(dName, true, this.m_domain);
            EvermindTemporaryQueue evermindTemporaryQueue = new EvermindTemporaryQueue(dName, this.m_conn, this.m_domain);
            return evermindTemporaryQueue;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized TemporaryTopic createTemporaryTopic() throws JMSException {
        this.lock("createTemporaryTopic");
        try {
            JMSUtils.assertDomain(this, 1, this.m_domain);
            String dName = JMSUtils.newID("TemporaryTopic");
            this.getServer().createTemporary(dName, false, this.m_domain);
            EvermindTemporaryTopic evermindTemporaryTopic = new EvermindTemporaryTopic(dName, this.m_conn, this.m_domain);
            return evermindTemporaryTopic;
        }
        finally {
            this.unlock();
        }
    }

    public final synchronized TextMessage createTextMessage() throws JMSException {
        return (TextMessage)this.makeMessage("createTextMessage", 6, null);
    }

    public final synchronized TextMessage createTextMessage(String body) throws JMSException {
        return (TextMessage)this.makeMessage("createTextMessage", 6, body, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Topic createTopic(String tName) throws JMSException {
        this.lock("createTopic");
        try {
            JMSUtils.assertDomain(this, 1, this.m_domain);
            if (JMSUtils.isNull(tName)) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01900", this));
            }
            Topic topic = this.m_conn.createTopic(tName);
            return topic;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int getAcknowledgeMode() throws JMSException {
        this.lock("getAcknowledgeMode");
        try {
            int n = this.m_transacted ? 0 : this.m_ackMode;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized MessageListener getMessageListener() throws JMSException {
        this.lock("getMessageListener");
        try {
            MessageListener messageListener = this.m_listener;
            return messageListener;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean getTransacted() throws JMSException {
        this.lock("getTransacted");
        try {
            boolean bl = this.m_transacted;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void recover() throws JMSException {
        this.lock("recover");
        try {
            this.assertNotTransacted("recover");
            this.getServer().rollback(new SessionID(this.getLocalID()));
            this.bumpTXID();
            this.m_inLocal.set(false);
            this.clearPending();
            if (this.m_inList.test()) {
                this.m_sessMod.set(true);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void rollback() throws JMSException {
        this.lock("rollback");
        try {
            this.assertTransacted("rollback");
            this.getServer().rollback(new SessionID(this.getLocalID()));
            this.bumpTXID();
            this.m_inLocal.set(false);
            this.clearPending();
            if (this.m_inList.test()) {
                this.m_sessMod.set(true);
            }
            this.state("txid", new Long(this.m_txid));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void run() {
        try {
            this.lock("run");
            try {
                Iterator iter = this.m_msgs.iterator();
                while (iter.hasNext()) {
                    EvermindMessage msg = (EvermindMessage)iter.next();
                    this.doListener(this.m_listener, msg, null);
                }
            }
            finally {
                this.unlock();
            }
        }
        catch (Throwable ex) {
            JMSMessages.severeSessionRunError(this, ex);
        }
        finally {
            this.m_msgs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setMessageListener(MessageListener listener) throws JMSException {
        this.lock("setMessageListener");
        try {
            if (this.m_msgs.size() != 0 && listener == null) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01901", this, new Integer(this.m_msgs.size())));
            }
            this.m_listener = listener;
            this.state("sessionListener", listener);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void unsubscribe(String name) throws JMSException {
        this.lock("unsubscribe");
        try {
            JMSUtils.assertDomain(this, 1, this.m_domain);
            this.getServer().unsubscribe(name);
            this.state("durableSubscriptionCount", new Integer(--this.m_subCount));
        }
        finally {
            this.unlock();
        }
    }

    public String getTXID() {
        return String.valueOf(this.m_txid);
    }

    public String getXID() {
        return this.m_currXidStr;
    }

    public String getSessionListener() {
        return String.valueOf(this.m_listener);
    }

    public JMSSessionStats getJMSSessionStats() {
        return this.m_stats;
    }

    public final synchronized void delistCurrent() throws JMSException {
        try {
            if (this.m_appTrans != null) {
                this.m_appTrans.delistResource((XAResource)this, 0x2000000);
                this.m_appTrans = null;
            }
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("delistResource()", ex);
        }
    }

    public final boolean isXA() {
        return this.m_isXA;
    }

    public final int getDomain() {
        return this.m_domain;
    }

    protected final void localClose() throws JMSException {
        if (this.m_msgs.size() > 0) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01901", this, new Integer(this.m_msgs.size())));
        }
        if (this.m_transacted || this.m_ackMode == 2) {
            this.getServer().rollback(new SessionID(this.getLocalID()));
            this.bumpTXID();
            this.clearPending();
        }
        this.m_conn.remove(this.m_stats);
    }

    protected final void localNextTrans() {
        this.initEvent("pendingMessageCount");
        this.nextTrans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit(Xid xid, boolean singlePhase) throws XAException {
        try {
            this.lockXA("commit");
            try {
                this.locateCheck(xid, "commit", singlePhase, true);
                this.remove(xid);
                this.getServer().commit(new SessionID(xid));
                this.clearPending();
            }
            finally {
                this.unlock();
            }
        }
        catch (XAException xaException) {
            throw xaException;
        }
        catch (Throwable ex) {
            JMSUtils.toXAException("commit(" + xid + "," + singlePhase + ")", -3, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void end(Xid xid, int flags) throws XAException {
        try {
            this.lockXA("end");
            try {
                Tstate ts = this.locate(xid, "end");
                ts.updateState(xid, flags);
                if (this.m_currXid == xid) {
                    this.m_currXid = null;
                }
                this.state("xid", this.m_currXid);
            }
            finally {
                this.unlock();
            }
        }
        catch (XAException xaException) {
            throw xaException;
        }
        catch (Throwable ex) {
            JMSUtils.toXAException("end(" + xid + "," + flags + ")", -3, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forget(Xid xid) throws XAException {
        try {
            this.lockXA("forget");
            try {
                JMSUtils.toXAException(JMSMessages.getMessage("J2EE JMS-01917", this, xid), -3);
            }
            finally {
                this.unlock();
            }
        }
        catch (XAException xaException) {
            throw xaException;
        }
        catch (Throwable ex) {
            JMSUtils.toXAException("forget(" + xid + ")", -3, ex);
        }
    }

    public synchronized int getTransactionTimeout() throws XAException {
        int ret = 0;
        try {
            this.lockXA("getTransactionTimeout");
            ret = this.m_xaTimeout;
            this.unlock();
        }
        catch (Throwable ex) {
            JMSUtils.toXAException("getTransactionTimeout()", -3, ex);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isSameRM(XAResource xar) throws XAException {
        boolean ret = false;
        try {
            this.lockXA("isSameRM");
            try {
                ret = xar == null ? false : (xar instanceof EvermindSession ? ((EvermindSession)xar).getID().equals(this.getID()) : false);
            }
            finally {
                this.unlock();
            }
        }
        catch (Throwable ex) {
            JMSUtils.toXAException("isSameRM(" + xar + ")", -3, ex);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int prepare(Xid xid) throws XAException {
        try {
            this.lockXA("prepare");
            try {
                this.locateCheck(xid, "prepare", true);
                if (!this.m_prepXids.contains(xid)) {
                    this.m_prepXids.add(xid);
                    this.getServer().prepareX(new SessionID(xid));
                }
            }
            finally {
                this.unlock();
            }
        }
        catch (XAException xaException) {
            throw xaException;
        }
        catch (Throwable ex) {
            JMSUtils.toXAException("prepare(" + xid + ")", -3, ex);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Xid[] recover(int flags) throws XAException {
        if (this.m_prepCur == -1 && !this.matches(flags, 0x1000000)) {
            JMSUtils.toXAException(JMSMessages.getMessage("J2EE JMS-01902", this, "recover(" + flags + ")"), -6);
        }
        if (this.matches(flags, 0x1000000)) {
            this.m_prepCur = 0;
        } else if (flags != 0 && (flags ^ 0x1800000) != 0) {
            JMSUtils.toXAException(JMSMessages.getMessage("J2EE JMS-01903", this, "recover(" + flags + ")"), -5);
        }
        try {
            this.lockXA("recover");
            try {
                SessionID[] xids = this.getServer().recoverX();
                if (xids != null) {
                    for (int i = 0; i < xids.length; ++i) {
                        Xid id;
                        if (!xids[i].isXA() || this.m_prepXids.contains(id = xids[i].xid())) continue;
                        this.m_prepXids.add(id);
                        this.m_xids.put(id, new Tstate());
                    }
                }
                this.m_sessRecovered.set(true);
            }
            finally {
                this.unlock();
            }
        }
        catch (Throwable ex) {
            JMSUtils.toXAException("recover()", -3, ex);
        }
        ArrayList l = new ArrayList();
        while (this.m_prepCur < this.m_prepXids.size()) {
            if (this.m_prepXids.get(this.m_prepCur) != null) {
                l.add(this.m_prepXids.get(this.m_prepCur));
            }
            ++this.m_prepCur;
        }
        if (this.matches(flags, 0x800000)) {
            this.m_prepXids.clear();
            this.m_prepCur = -1;
        }
        Xid[] xids = new Xid[l.size()];
        l.toArray(xids);
        return xids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(Xid xid) throws XAException {
        try {
            this.lockXA("rollback");
            try {
                this.locate(xid, "rollback", true);
                this.remove(xid);
                this.getServer().rollback(new SessionID(xid));
                this.clearPending();
            }
            finally {
                this.unlock();
            }
        }
        catch (XAException xaException) {
            throw xaException;
        }
        catch (Throwable ex) {
            JMSUtils.toXAException("rollback(" + xid + ")", -3, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setTransactionTimeout(int val) throws XAException {
        try {
            this.lockXA("setTransactionTimeout");
            try {
                if (val == 0) {
                    this.m_xaTimeout = Integer.MAX_VALUE;
                } else if (val > 0) {
                    this.m_xaTimeout = val;
                } else {
                    JMSUtils.toXAException(JMSMessages.getMessage("J2EE JMS-01904", this, "setTransactionTimeout(" + val + ")"), -5);
                }
            }
            finally {
                this.unlock();
            }
        }
        catch (Throwable ex) {
            JMSUtils.toXAException("setTransactionTimeout(" + val + ")", -3, ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(Xid xid, int flags) throws XAException {
        try {
            this.lockXA("start");
            try {
                Tstate ts;
                if (!PSEUDO_TRANSACTION_ENLISTMENT && !this.m_isXA) {
                    throw new JMSException(JMSMessages.getMessage("J2EE JMS-01920", this, "start(" + xid + "," + flags + ")"));
                }
                if (this.m_currXid != null) {
                    JMSUtils.toXAException(JMSMessages.getMessage("J2EE JMS-01905", this, "start(" + xid + "," + flags + ")", this.m_currXid), -6);
                }
                if ((ts = (Tstate)this.m_xids.get(xid)) == null) {
                    ts = new Tstate();
                    this.m_xids.put(xid, ts);
                } else if (flags != 0x200000 && flags != 0x8000000) {
                    JMSUtils.toXAException(JMSMessages.getMessage("J2EE JMS-01906", this, "start(" + xid + "," + flags + ")"), -8);
                }
                ts.updateState(xid, flags);
                if (ts.getState() == 1) {
                    this.setCurrXid(xid);
                }
                this.state("xid", this.m_currXid);
            }
            finally {
                this.unlock();
            }
        }
        catch (XAException xaException) {
            throw xaException;
        }
        catch (Throwable ex) {
            JMSUtils.toXAException("start(" + xid + "," + flags + ")", -3, ex);
        }
    }

    void add(JMSEndpointStats s) {
        EvermindSession.getProxy().addEndpoint(this.m_stats, s);
    }

    void remove(JMSEndpointStats s) {
        EvermindSession.getProxy().removeEndpoint(this.m_stats, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized EvermindMessageBrowser makeBrowser(Destination d, String name, String selector) throws JMSException {
        this.lock("makeBrowser");
        EvermindMessageBrowser ret = null;
        try {
            this.checkTemporaryDomain(d);
            ret = JMSUtils.isQ(d) ? new EvermindQueueBrowser(this, (Queue)d, selector) : new EvermindTopicBrowser(this, (Topic)d, name, selector);
        }
        finally {
            this.unlock();
        }
        return ret;
    }

    public final synchronized void sendToExceptionQueue(Message msg, Map headers) throws JMSException {
        if (!(msg instanceof EvermindMessage)) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01918", this, msg.getClass().getName()));
        }
        EvermindMessage nmsg = ((EvermindMessage)msg).wrapException(headers);
        this.setJMSXSend(nmsg);
        boolean keepState = this.m_transacted || this.m_currXid != null || this.m_ackMode == 2;
        EvermindDestination dest = (EvermindDestination)msg.getJMSDestination();
        if (JMSUtils.isNull(dest.getPersistenceFile())) {
            nmsg.setJMSDeliveryMode(1);
        }
        this.getServer().enqMessage("jms/Oc4jJmsExceptionQueue", this.getSessionID(), keepState, nmsg, this.m_currXid != null);
    }

    final EvermindConnection getConnection() {
        return this.m_conn;
    }

    final JMSCommands getServer() throws JMSException {
        return this.m_conn.getServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void acknowledge() throws JMSException {
        this.lock("acknowledge");
        try {
            if (this.m_transacted || this.m_currXid != null) {
                return;
            }
            if (this.m_ackMode != 2) {
                return;
            }
            this.getServer().commit(new SessionID(this.getLocalID()));
            this.bumpTXID();
            this.m_inLocal.set(false);
            this.clearPending();
            if (this.m_inList.test()) {
                this.m_sessMod.set(true);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void send(MessageProducer prod, Destination dest, Message omsg, int deliveryMode, int priority, long ttl, boolean noMsgID, boolean noTimestamp, DummyStats jstats) throws JMSException {
        try {
            Message message = omsg;
            synchronized (message) {
                EvermindMessage msg = (EvermindMessage)JMSUtils.convert(this, omsg);
                String id = "ID:" + JMSUtils.newID("Message");
                long millis = System.currentTimeMillis();
                msg.setJMSDestination(dest);
                msg.setJMSDeliveryMode(deliveryMode);
                msg.setJMSPriority(priority);
                msg.setID(id, noMsgID);
                msg.setTimestamp(millis, noTimestamp);
                msg.setJMSExpiration(ttl <= 0L ? 0L : ttl + millis);
                this.checkForCMT();
                boolean keepState = this.m_transacted || this.m_currXid != null;
                this.setJMSXSend(msg);
                this.getServer().enqMessage(JMSUtils.getName(dest), this.getSessionID(), keepState, msg, this.m_currXid != null);
                jstats.event("messageCount");
                this.event("messageCount");
                if (keepState) {
                    jstats.event("pendingMessageCount");
                    this.event("pendingMessageCount");
                }
                if (!this.m_inLocal.test()) {
                    this.m_inLocal.set(keepState && this.m_currXid == null);
                }
                if (msg != omsg) {
                    JMSUtils.convertHeaders(omsg, msg, false);
                }
            }
        }
        catch (Exception ex) {
            JMSUtils.toJMSException("send(" + prod + "," + dest + "," + omsg + ")", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void assertNoListener() throws JMSException {
        Set set = this.m_listeners;
        synchronized (set) {
            if (this.m_listeners.size() > 0) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01907", this, new Integer(this.m_listeners.size())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized boolean handleMessage(int consID, MessageListener listener, EvermindMessageConsumer cons, DummyStats jstats) throws JMSException {
        boolean ok = this.lockReceive(null);
        if (!ok) {
            return false;
        }
        try {
            EvermindMessage msg = this.receive(consID, true, jstats);
            if (msg == null) {
                boolean bl = false;
                return bl;
            }
            this.doListener(listener, msg, cons);
            if (!this.m_transacted && this.m_currXid == null && this.m_ackMode != 2 && !this.m_sessMod.test()) {
                this.getServer().commit(new SessionID(this.getLocalID()));
                this.bumpTXID();
                this.m_inLocal.set(false);
                this.clearPending();
            }
        }
        finally {
            this.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized Message getOneMessage(int consID, DummyStats jstats) throws JMSException {
        boolean ok = this.lockReceive(null);
        if (!ok) {
            return null;
        }
        try {
            EvermindMessage evermindMessage = this.receive(consID, false, jstats);
            return evermindMessage;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addListener(String consID) throws JMSException {
        Set set = this.m_listeners;
        synchronized (set) {
            if (this.isStarted() && this.m_listeners.size() > 0 && !this.m_listeners.contains(consID)) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01908", this, new Integer(this.m_listeners.size()), this.m_conn));
            }
            this.m_listeners.add(consID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeListener(String consID) {
        Set set = this.m_listeners;
        synchronized (set) {
            this.m_listeners.remove(consID);
        }
    }

    final synchronized void loadMessage(Message msg) {
        this.m_msgs.add(msg);
    }

    private static void verifyAckMode(int ackMode) throws JMSException {
        if (ackMode != 1 && ackMode != 2 && ackMode != 3 && ackMode != 0) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01909", new Integer(ackMode)));
        }
    }

    private void assertTransacted(String func) throws JMSException {
        if (!this.m_transacted) {
            JMSUtils.toIllegalStateException(JMSMessages.getMessage("J2EE JMS-01910", this, func));
        }
        if (this.m_isXA) {
            JMSUtils.toTransactionInProgressException(JMSMessages.getMessage("J2EE JMS-01911", this, func));
        }
        if (this.m_currXid != null) {
            JMSUtils.toTransactionInProgressException(JMSMessages.getMessage("J2EE JMS-01912", this, func, this.m_currXid));
        }
    }

    private void assertNotTransacted(String func) throws JMSException {
        if (this.m_transacted) {
            JMSUtils.toIllegalStateException(JMSMessages.getMessage("J2EE JMS-01913", this, func));
        }
        if (this.m_currXid != null) {
            JMSUtils.toIllegalStateException(JMSMessages.getMessage("J2EE JMS-01912", this, func, this.m_currXid));
        }
    }

    private void checkTemporaryDomain(Destination d) throws JMSException {
        if (d == null || !JMSUtils.isTemp(d)) {
            return;
        }
        EvermindDestination.checkDestination(d);
        EvermindTemporaryDestination td = (EvermindTemporaryDestination)d;
        JMSUtils.assertDomain(td, this.m_domain, td.getDomain());
    }

    private EvermindMessage receive(int consID, boolean inListener, DummyStats jstats) throws JMSException {
        this.checkForCMT();
        boolean keepState = this.m_transacted || this.m_currXid != null || inListener || this.m_ackMode == 2;
        EvermindMessage msg = this.getServer().deqMessage(consID, this.getSessionID(), this.getTx(), keepState, this.m_currXid != null);
        if (msg == null) {
            return null;
        }
        jstats.event("messageCount");
        this.event("messageCount");
        if (keepState) {
            jstats.event("pendingMessageCount");
            this.event("pendingMessageCount");
        }
        long ms = msg.getRcvTimestamp();
        jstats.addPhase("messageWaitTime", ms);
        this.addPhase("messageWaitTime", ms);
        if (!this.m_inLocal.test()) {
            this.m_inLocal.set(keepState && this.m_currXid == null);
        }
        msg.setReadOnly(true);
        msg.setHdrReadOnly(true);
        msg.setSession(this);
        msg.setInXA(this.m_currXid != null);
        return msg;
    }

    private static EvermindMessage clone(EvermindMessage msg) throws JMSException {
        EvermindMessage ret = msg.cloneMessage();
        ret.setReadOnly(true);
        ret.setHdrReadOnly(true);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doListener(MessageListener listener, EvermindMessage msg, EvermindMessageConsumer cons) {
        this.m_sessMod.set(false);
        int count = 0;
        ArrayList<Throwable> exList = new ArrayList<Throwable>();
        while (count < EvermindSession.getListenerAttempts()) {
            try {
                this.m_inList.set(true);
                listener.onMessage((Message)EvermindSession.clone(msg));
                break;
            }
            catch (Throwable ex) {
                if (this.m_sessMod.test()) break;
                ++count;
                s_traceLogger.fine("onMessage", ex);
                exList.add(ex);
            }
            finally {
                this.m_inList.set(false);
            }
        }
        if (count >= EvermindSession.getListenerAttempts()) {
            JMSMessages.severeListenerError(this, listener, msg, count);
            try {
                EvermindMessage nmsg = msg.wrapUndeliverable(this.m_conn.clientID(), cons, exList);
                boolean keepState = this.m_transacted || this.m_currXid != null || this.m_ackMode == 2;
                this.setJMSXSend(nmsg);
                this.getServer().enqMessage("jms/Oc4jJmsExceptionQueue", this.getSessionID(), keepState, nmsg, this.m_currXid != null);
            }
            catch (Throwable ex) {
                s_traceLogger.fine("exceptionQueue", ex);
            }
        }
    }

    private Message makeMessage(String func, int type, Object body) throws JMSException {
        return this.makeMessage(func, type, body, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message makeMessage(String func, int type, Object body, boolean useBody) throws JMSException {
        this.lock(func);
        Object var5_5 = null;
        try {
            void var5_14;
            switch (type) {
                case 1: {
                    EvermindBytesMessage evermindBytesMessage = new EvermindBytesMessage();
                    return var5_14;
                }
                case 2: {
                    EvermindMapMessage evermindMapMessage = new EvermindMapMessage();
                    return var5_14;
                }
                case 3: {
                    EvermindMessage evermindMessage = new EvermindMessage();
                    return var5_14;
                }
                case 4: {
                    if (useBody) {
                        EvermindObjectMessage evermindObjectMessage = new EvermindObjectMessage((Serializable)body);
                        return var5_14;
                    }
                    EvermindObjectMessage evermindObjectMessage = new EvermindObjectMessage();
                    return var5_14;
                }
                case 5: {
                    EvermindStreamMessage evermindStreamMessage = new EvermindStreamMessage();
                    return var5_14;
                }
                case 6: {
                    if (useBody) {
                        EvermindTextMessage evermindTextMessage = new EvermindTextMessage((String)body);
                        return var5_14;
                    }
                    EvermindTextMessage evermindTextMessage = new EvermindTextMessage();
                    return var5_14;
                }
            }
            return var5_14;
        }
        finally {
            this.unlock();
        }
    }

    private SessionID getSessionID() {
        return this.m_currXid == null ? new SessionID(this.getLocalID()) : new SessionID(this.m_currXid);
    }

    private void bumpTXID() {
        ++this.m_txid;
        this.setLocalID();
    }

    private void setLocalID() {
        this.m_localID = this.getID() + "." + String.valueOf(this.m_txid);
    }

    private String getLocalID() {
        return this.m_localID;
    }

    private void setCurrXid(Xid xid) {
        this.m_currXid = xid;
        this.m_currXidStr = String.valueOf(this.m_currXid);
    }

    private String getTx() {
        return this.m_currXid == null ? (this.m_transacted ? this.getLocalID() : "") : this.m_currXidStr;
    }

    private void setJMSXSend(EvermindMessage msg) throws JMSException {
        msg.forceObjectProperty("JMSXProducerTXID", this.getTx());
        msg.forceObjectProperty("JMSXUserID", JMSUtils.fold(this.m_conn.getUser()));
    }

    private void checkForCMT() throws JMSException {
        block10: {
            if (PSEUDO_TRANSACTION_ENLISTMENT) {
                try {
                    Transaction tx = EvermindSession.getProxy().getEnlistingTrans();
                    if (this.m_isXA || !EvermindSession.getProxy().doEnlist(this.m_appTrans, tx)) {
                        return;
                    }
                    if (this.m_currXid != null) {
                        this.end(this.m_currXid, 0x2000000);
                    }
                    if (tx == null) {
                        this.m_appTrans = null;
                        this.setCurrXid(null);
                        this.state("xid", this.m_currXid);
                        break block10;
                    }
                    if (this.m_inLocal.test()) {
                        JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01915", this, tx, this.getTx()));
                    }
                    this.m_appTrans = tx;
                    if (!this.m_xaEnlistmentWarningGiven) {
                        JMSMessages.infoDirectEnlistment();
                        this.m_xaEnlistmentWarningGiven = true;
                    }
                    this.m_appTrans.enlistResource((XAResource)this);
                }
                catch (Throwable ex) {
                    JMSUtils.toJMSException("enlistResource()", ex);
                }
            } else if (this.m_isXA && this.m_currXid == null) {
                throw new JMSException(JMSMessages.getMessage("J2EE JMS-01921", this));
            }
        }
    }

    private Tstate locate(Xid xid, String func) throws XAException {
        return this.locate(xid, func, false);
    }

    private Tstate locate(Xid xid, String func, boolean doRecover) throws XAException {
        if (!this.m_xids.containsKey(xid)) {
            if (doRecover && !this.m_sessRecovered.test()) {
                this.recover(0x1000000);
            }
            if (!this.m_xids.containsKey(xid)) {
                JMSUtils.toXAException(func + "(" + xid + "):", -4);
            }
        }
        return (Tstate)this.m_xids.get(xid);
    }

    private Tstate locateCheck(Xid xid, String func, boolean doTimeoutCheck) throws XAException {
        return this.locateCheck(xid, func, doTimeoutCheck, false);
    }

    private Tstate locateCheck(Xid xid, String func, boolean doTimeoutCheck, boolean doRecover) throws XAException {
        Tstate ts = this.locate(xid, func, doRecover);
        if (ts.doFail()) {
            JMSUtils.toXAException(func + "(" + xid + "):", 100);
        }
        if (doTimeoutCheck && (long)ts.howLong() > (long)this.m_xaTimeout * 1000L) {
            JMSUtils.toXAException(func + "(" + xid + "):", 106);
        }
        return ts;
    }

    private void remove(Xid xid) {
        this.m_xids.remove(xid);
        int i = this.m_prepXids.indexOf(xid);
        if (i != -1) {
            this.m_prepXids.remove(i);
        }
    }

    private boolean matches(int val, int flag) {
        return (val & flag) != 0;
    }

    private void clearPending() {
        this.localNextTrans();
    }

    private static void setListenerAttempts(int attempts) {
        s_listenerAttempts = attempts;
    }

    private static int getListenerAttempts() {
        return s_listenerAttempts;
    }

    private static final class Tstate {
        public static final int NOT_ASSOCIATED = 0;
        public static final int ASSOCIATED = 1;
        public static final int SUSPENDED = 2;
        int m_state = 0;
        boolean m_doFail = false;
        long m_start = System.currentTimeMillis();

        private Tstate() {
        }

        public void updateState(Xid xid, int flags) throws XAException {
            if (this.m_state == 0 && flags == 0) {
                this.m_state = 1;
            } else if (this.m_state == 2 && flags == 0x8000000) {
                this.m_state = 1;
            } else if (this.m_state == 2 && flags == 0x200000) {
                this.m_state = 1;
            } else if (PSEUDO_TRANSACTION_ENLISTMENT && this.m_state == 2 && flags == 0x2000000) {
                this.m_state = 2;
            } else if (this.m_state == 1 && flags == 0x2000000) {
                this.m_state = 2;
            } else if (this.m_state == 1 && flags == 0x20000000) {
                this.m_state = 0;
            } else if (this.m_state == 2 && flags == 0x20000000) {
                this.m_state = 0;
            } else if (this.m_state == 1 && flags == 0x4000000) {
                this.m_state = 0;
            } else if (this.m_state == 2 && flags == 0x4000000) {
                this.m_state = 0;
            } else {
                JMSUtils.toXAException(JMSMessages.getMessage("J2EE JMS-01916", xid, new Integer(this.m_state), new Integer(flags)), -5);
            }
            if (flags == 0x20000000) {
                this.m_doFail = true;
            }
        }

        public int getState() {
            return this.m_state;
        }

        public boolean doFail() {
            return this.m_doFail;
        }

        public int howLong() {
            return (int)(System.currentTimeMillis() - this.m_start);
        }
    }
}

