/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindConnectionFactory;
import com.evermind.server.jms.EvermindTopicConnection;
import com.evermind.server.jms.JMSServerProxy;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.SecureOperation;
import java.net.InetAddress;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;

public class EvermindTopicConnectionFactory
extends EvermindConnectionFactory
implements TopicConnectionFactory {
    static final long serialVersionUID = 5004126822176888298L;

    EvermindTopicConnectionFactory(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass, String clientID, boolean isXA) {
        super(addr, port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass, clientID, isXA, 1);
    }

    public final synchronized TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(this.getUser(), this.getPass());
    }

    public final synchronized TopicConnection createTopicConnection(final String user, final String pass) throws JMSException {
        TopicConnection conn = null;
        try {
            conn = (TopicConnection)JMSServerProxy.getProxy().doSecureOp(new SecureOperation(){

                public Object execute() throws Exception {
                    return EvermindTopicConnectionFactory.this.unprivileged_createTopicConnection(user, pass);
                }
            });
        }
        catch (JMSException jex) {
            throw jex;
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception ex) {
            JMSUtils.toJMSSecurityException(ex.getMessage());
        }
        return conn;
    }

    private TopicConnection unprivileged_createTopicConnection(String user, String pass) throws JMSException {
        return new EvermindTopicConnection(this.getAddr(), this.getPort(), this.getTunnel(), this.getKeystore(), this.getKeystorePassword(), this.getTruststore(), this.getTruststorePassword(), this.getProvider(), user, pass, this.getClientID(), false);
    }
}

