/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindTopicConnectionFactory;
import com.evermind.server.jms.EvermindXAConnection;
import com.evermind.server.jms.EvermindXATopicConnection;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.SecureOperation;
import java.net.InetAddress;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;

public final class EvermindXATopicConnectionFactory
extends EvermindTopicConnectionFactory
implements XATopicConnectionFactory {
    static final long serialVersionUID = -9111518262707259277L;

    EvermindXATopicConnectionFactory(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass, String clientID) {
        super(addr, port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass, clientID, true);
    }

    public synchronized XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(this.getUser(), this.getPass());
    }

    public synchronized XAConnection createXAConnection(final String user, final String pass) throws JMSException {
        XAConnection conn = null;
        try {
            conn = (XAConnection)this.getProxy().doSecureOp(new SecureOperation(){

                public Object execute() throws Exception {
                    return EvermindXATopicConnectionFactory.this.unprivileged_createXAConnection(user, pass);
                }
            });
        }
        catch (JMSException jex) {
            throw jex;
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception ex) {
            JMSUtils.toJMSSecurityException(ex.getMessage());
        }
        return conn;
    }

    private XAConnection unprivileged_createXAConnection(String user, String pass) throws JMSException {
        return new EvermindXAConnection(this.getAddr(), this.getPort(), this.getTunnel(), this.getKeystore(), this.getKeystorePassword(), this.getTruststore(), this.getTruststorePassword(), this.getProvider(), user, pass, this.getClientID(), 2);
    }

    public synchronized XATopicConnection createXATopicConnection() throws JMSException {
        return this.createXATopicConnection(this.getUser(), this.getPass());
    }

    public synchronized XATopicConnection createXATopicConnection(final String user, final String pass) throws JMSException {
        XATopicConnection conn = null;
        try {
            conn = (XATopicConnection)this.getProxy().doSecureOp(new SecureOperation(){

                public Object execute() throws Exception {
                    return EvermindXATopicConnectionFactory.this.unprivileged_createXATopicConnection(user, pass);
                }
            });
        }
        catch (JMSException jex) {
            throw jex;
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception ex) {
            JMSUtils.toJMSSecurityException(ex.getMessage());
        }
        return conn;
    }

    private XATopicConnection unprivileged_createXATopicConnection(String user, String pass) throws JMSException {
        return new EvermindXATopicConnection(this.getAddr(), this.getPort(), this.getTunnel(), this.getKeystore(), this.getKeystorePassword(), this.getTruststore(), this.getTruststorePassword(), this.getProvider(), user, pass, this.getClientID());
    }
}

