/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.DummyStats;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSRemoteServer;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.SecureOperation;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import oracle.oc4j.security.OC4JSSLSocketFactory;
import oracle.oc4j.security.SSLUtilValues;
import oracle.oc4j.security.SSLUtils;

public final class HTTPJMSRemoteServer
extends JMSRemoteServer {
    private HttpURLConnection httpConnection;
    private long sequenceNumber = 1L;
    private boolean isSSL = false;
    private String m_tunnel;
    private String m_keystore;
    private String m_keystorePassword;
    private String m_truststore;
    private String m_truststorePassword;
    private String m_provider;
    public static final long HTTP_INITIAL_RESEND_INTERVAL = (Long)HTTPJMSRemoteServer.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.httpInitialResendInterval");
    public static final long HTTP_MAX_RESEND_INTERVAL = (Long)HTTPJMSRemoteServer.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.httpMaxResendInterval");
    public static final long HTTP_RESPONSE_TIMEOUT = (Long)HTTPJMSRemoteServer.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.httpResponseTimeout");
    public static final int RECONNECT_ATTEMPTS = (Integer)HTTPJMSRemoteServer.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.reconnectAttempts");

    HTTPJMSRemoteServer(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass) throws JMSException {
        this.m_addr = addr;
        this.m_port = port;
        this.m_tunnel = tunnel;
        this.m_keystore = keystore;
        this.m_keystorePassword = keystorePassword;
        this.m_truststore = truststore;
        this.m_truststorePassword = truststorePassword;
        this.m_provider = provider;
        this.m_user = user;
        this.m_pass = pass;
        final String self = "RemoteServer." + this.m_name;
        this.m_jstats = (DummyStats)HTTPJMSRemoteServer.getProxy().doSecureOpNoException(new SecureOperation(){

            public Object executeNoException() {
                return JMSRemoteServer.getProxy().createStats("/JMS", self, "TCPJMSRemoteServer");
            }
        });
        this.m_jstats.state("address", this.m_addr, true);
        this.m_jstats.state("host", JMSUtils.normalize(this.m_addr), true);
        this.m_jstats.state("port", new Integer(this.m_port), true);
        this.m_jstats.state("tunnel", this.m_tunnel, true);
        this.m_jstats.state("keystore", this.m_keystore, true);
        this.m_jstats.state("keystore-password", this.m_keystorePassword, true);
        this.m_jstats.state("truststore", this.m_truststore, true);
        this.m_jstats.state("truststore-password", this.m_truststorePassword, true);
        this.m_jstats.state("provider", this.m_provider, true);
        this.m_jstats.state("user", this.m_user, true);
    }

    public synchronized void closeConnection() {
        if (this.connectionState == 2) {
            return;
        }
        this.connectionState = 2;
        try {
            this.execute(new JMSRemoteServer.Op(){

                public String name() {
                    return "closeConnection";
                }

                public void sendRequest() throws Throwable {
                    HTTPJMSRemoteServer.this.m_dout.writeInt(1002);
                }

                public Object getReply() throws Throwable {
                    return null;
                }
            });
            if (this.isSSL) {
                OC4JSSLSocketFactory.reset(this.m_connID);
            }
        }
        catch (Throwable ex) {
            s_traceLogger.throwing("closeConnection", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute(JMSRemoteServer.Op op) throws JMSException {
        Object ret = null;
        Throwable lastEx = null;
        long waitInterval = HTTP_INITIAL_RESEND_INTERVAL;
        long totalWait = 0L;
        boolean responseReceived = false;
        boolean reconnecting = false;
        do {
            long token = this.m_jstats.phase(op.name());
            try {
                if (!reconnecting) {
                    this.sendHTTPRequest(op);
                    ret = this.readHTTPResponse(op);
                    responseReceived = true;
                    continue;
                }
                this.reconnectAfterServerOutage();
                reconnecting = false;
            }
            catch (Throwable ex) {
                s_traceLogger.fine("execute", ex);
                if (ex instanceof SequenceNumberTooLargeException) {
                    if (RECONNECT_ATTEMPTS == 0) {
                        lastEx = ex;
                    } else {
                        reconnecting = true;
                    }
                }
                if (ex instanceof JMSException || totalWait > HTTP_RESPONSE_TIMEOUT) {
                    lastEx = ex;
                    continue;
                }
                JMSUtils.sleep(waitInterval);
                totalWait += waitInterval;
                waitInterval += waitInterval;
                if (waitInterval <= HTTP_MAX_RESEND_INTERVAL) continue;
                waitInterval = HTTP_MAX_RESEND_INTERVAL;
            }
            finally {
                this.m_jstats.phase(op.name(), token);
            }
        } while (lastEx == null && !responseReceived);
        ++this.sequenceNumber;
        if (lastEx != null) {
            JMSUtils.toJMSException("Connection failure", lastEx);
        }
        return ret;
    }

    protected void processFlag(JMSRemoteServer.Op op) throws Throwable {
        switch (this.m_dinp.readInt()) {
            case 1234: {
                break;
            }
            case -1234: {
                throw new SequenceNumberTooLargeException("JMS Server restarted, connection lost");
            }
            case 4321: {
                JMSException remoteEx = (JMSException)((Object)JMSUtils.read(this.m_dinp));
                JMSUtils.initCause(remoteEx, (Throwable)JMSUtils.clone((Serializable)((Object)remoteEx)));
                throw remoteEx.fillInStackTrace();
            }
            default: {
                JMSUtils.toIOException(JMSMessages.getMessage("J2EE JMS-03309", this, op.name()));
            }
        }
    }

    private void reconnectAfterServerOutage() throws Throwable {
        s_traceLogger.fine("reconnectAfterServerOutage");
        this.m_badSess.addAll(this.m_sess);
        this.m_sess.clear();
        this.sequenceNumber = 1L;
        if (this.connectionState == 1) {
            JMSRemoteServer.Op registerOp = this.registerConnectionOp(this.m_clientID, this.m_connID, this.m_cuser);
            this.sendHTTPRequest(registerOp);
            this.readHTTPResponse(registerOp);
            ++this.sequenceNumber;
        }
        Iterator iter = this.m_cons.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Integer consID = (Integer)entry.getKey();
            JMSRemoteServer.Consumer cons = (JMSRemoteServer.Consumer)entry.getValue();
            JMSRemoteServer.Op consumerOp = this.createConsumerOp(cons.getDestination(), cons.getName(), cons.getSelector(), cons.getNoLocal());
            Integer newID = null;
            this.sendHTTPRequest(consumerOp);
            newID = (Integer)this.readHTTPResponse(consumerOp);
            ++this.sequenceNumber;
            if (consID.intValue() == newID.intValue()) continue;
            s_traceLogger.fine("redoOps: mapping {0} to {1}", new Object[]{consID, newID});
            this.m_consMap.put(consID, newID);
        }
    }

    private void sendHTTPRequest(JMSRemoteServer.Op op) throws Throwable {
        URL url = new URL(this.m_tunnel);
        URLConnection genericConnection = url.openConnection();
        this.httpConnection = (HttpURLConnection)genericConnection;
        this.httpConnection.setRequestMethod("POST");
        this.httpConnection.setDoOutput(true);
        if (this.httpConnection instanceof HttpsURLConnection) {
            this.establishSSLConfig((HttpsURLConnection)this.httpConnection);
            this.isSSL = true;
        }
        this.m_dout = new DataOutputStream(this.httpConnection.getOutputStream());
        this.sendProtocol(-559038634);
        JMSUtils.write(this.m_addr, this.m_dout);
        this.m_dout.writeInt(this.m_port);
        this.m_dout.writeUTF(this.m_connID);
        this.m_dout.writeLong(this.sequenceNumber);
        this.sendLogin(this.m_user, this.m_pass);
        this.sendRequest(op);
    }

    private Object readHTTPResponse(JMSRemoteServer.Op op) throws Throwable {
        this.httpConnection.getContent();
        InputStream in = this.httpConnection.getInputStream();
        this.m_dinp = new DataInputStream(in);
        this.readProtocol(-559038634);
        this.readLogin(this.m_user);
        if (this.sequenceNumber == 1L) {
            this.m_name = (String)((Object)JMSUtils.read(this.m_dinp));
        }
        return this.readResponse(op);
    }

    private void establishSSLConfig(HttpsURLConnection connection) throws Exception {
        OC4JSSLSocketFactory factory = this.getSSLClientFactory();
        try {
            connection.setHostnameVerifier(factory);
            connection.setSSLSocketFactory((SSLSocketFactory)factory.getSocketFactory());
        }
        catch (Exception ex) {
            s_traceLogger.throwing("establishSSLConfig", ex);
            throw ex;
        }
    }

    private OC4JSSLSocketFactory getSSLClientFactory() throws IOException {
        Hashtable<String, String> secProps = new Hashtable<String, String>();
        secProps.put("keyStoreLoc", this.m_keystore);
        secProps.put("keyStorePass", this.m_keystorePassword);
        if (!JMSUtils.isNull(this.m_truststore)) {
            secProps.put("trustStoreLoc", this.m_truststore);
            secProps.put("trustStorePass", this.m_truststorePassword);
        }
        if (!JMSUtils.isNull(this.m_provider)) {
            secProps.put("ssl.provider", this.m_provider);
        }
        SSLUtils.Values defaultValues = SSLUtils.getDefaultValues(this.m_connID, false);
        SSLUtils.Values values = SSLUtils.getValues(null, secProps, null, this.m_connID, (SSLUtilValues)defaultValues);
        return OC4JSSLSocketFactory.registerSSLUtilValues(this.m_connID, values);
    }

    private static class SequenceNumberTooLargeException
    extends Exception {
        public SequenceNumberTooLargeException() {
        }

        public SequenceNumberTooLargeException(String msg) {
            super(msg);
        }
    }
}

