/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.server.AdministrationPermission;
import com.evermind.server.ApplicationServer;
import com.evermind.server.RoleUser;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.jms.ConsumerInfo;
import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.EvermindTemporaryDestination;
import com.evermind.server.jms.EvermindTemporaryQueue;
import com.evermind.server.jms.EvermindTemporaryTopic;
import com.evermind.server.jms.JMSCommands;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSPermission;
import com.evermind.server.jms.JMSServer;
import com.evermind.server.jms.JMSStats;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.Knobs;
import com.evermind.server.jms.KnobsController;
import com.evermind.server.jms.MessageSelector;
import com.evermind.server.jms.ServerDestination;
import com.evermind.server.jms.SessionID;
import com.evermind.server.jms.TxDestinations;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;

public final class JMSProvider
implements JMSCommands {
    long messageCountTotal;
    long pendingMessageCountTotal;
    long storeSizeTotal;
    private final JMSServer m_server;
    private final Map m_dest = new HashMap();
    private final Map m_clntConn = new HashMap();
    private final Map m_connClnt = new HashMap();
    private final Map m_connUser = new HashMap();
    private final Map m_connPhase = new HashMap();
    private final Map m_connTemp = new HashMap();
    private final Map m_connSess = new HashMap();
    private final Map m_connCons = new HashMap();
    private final Map m_xaSess = new HashMap();
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(JMSProvider.class);
    private static final boolean m_msgSizeIsValid = (Boolean)KnobsController.getKnobsController().getConfigProperty("oc4j.jms.computeMsgsize");
    public static final String NAME = ApplicationServer.INFO + " (build \"" + ApplicationServer.getBuildNumber() + "\")";

    public JMSProvider(JMSServer server) {
        this.m_server = server;
        if (this.m_server == null) {
            final JMSProvider me = this;
            Thread thr = new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        JMSUtils.sleep(JMSServer.EXPIRATION_INTERVAL);
                        me.expireMessages();
                        Thread.yield();
                    }
                }
            });
            thr.setDaemon(true);
            thr.start();
        }
    }

    public String toString() {
        return this.m_server == null ? "JMSProvider[(standalone)]" : this.m_server.toString();
    }

    public String getJMSProviderName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerConnection(String clientID, String connID, String user) throws JMSException {
        long tok = this.startPhase("registerConnection");
        try {
            Set s;
            JMSUtils.checkNull("registerConnection", "connectionID", connID);
            clientID = JMSUtils.fold(clientID);
            if (!this.m_clntConn.containsKey(clientID)) {
                this.m_clntConn.put(clientID, new HashSet());
            }
            if ((s = (Set)this.m_clntConn.get(clientID)).contains(connID)) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02300", this, connID, clientID));
            }
            this.createConnection(clientID, connID);
            if (this.m_server != null) {
                this.m_connUser.put(connID, this.m_server.getUser(user));
                this.m_connPhase.put(connID, new Long(this.m_server.getStats().phase("activeConnections")));
                this.m_server.getStats().event("connections");
            }
        }
        finally {
            this.stopPhase("registerConnection", tok);
        }
    }

    public synchronized JMSException ping() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeConnection() {
        long tok = this.startPhase("closeConnection");
        try {
            Long acTok;
            String connID = JMSUtils.getConnectionID();
            if (this.m_server != null && (acTok = (Long)this.m_connPhase.remove(connID)) != null) {
                this.m_server.getStats().phase("activeConnections", acTok);
            }
            this.closeConnection(JMSUtils.getClientID(), connID);
            this.m_connClnt.remove(connID);
            this.m_connUser.remove(connID);
            JMSUtils.gc();
        }
        finally {
            this.stopPhase("closeConnection", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getKnobs() throws JMSException {
        this.checkAdmin("getKnobs");
        long tok = this.startPhase("getKnobs");
        try {
            String string = Knobs.makeString();
            return string;
        }
        finally {
            this.stopPhase("getKnobs", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getStats() throws JMSException {
        this.checkAdmin("getStats");
        long tok = this.startPhase("getStats");
        try {
            String string = JMSStats.stats();
            return string;
        }
        finally {
            this.stopPhase("getStats", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List getDestinations(boolean forAPI) throws JMSException {
        if (!forAPI) {
            this.checkAdmin("getDestinations");
        }
        long tok = this.startPhase("getDestinations");
        try {
            ArrayList<Destination> ret = new ArrayList<Destination>();
            Iterator iter = null;
            iter = this.m_dest.entrySet().iterator();
            while (iter.hasNext()) {
                ServerDestination sdest = (ServerDestination)iter.next().getValue();
                ret.add(sdest.getDestination());
            }
            String connID = JMSUtils.getConnectionID();
            iter = ((Map)this.m_connTemp.get(connID)).entrySet().iterator();
            while (iter.hasNext()) {
                ServerDestination sdest = (ServerDestination)iter.next().getValue();
                ret.add(sdest.getDestination());
            }
            ArrayList<Destination> arrayList = ret;
            return arrayList;
        }
        finally {
            this.stopPhase("getDestinations", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List getDurables() throws JMSException {
        this.checkAdmin("getDurables");
        long tok = this.startPhase("getDurables");
        try {
            List list = ConsumerInfo.listDurables();
            return list;
        }
        finally {
            this.stopPhase("getDurables", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createTemporary(String dName, boolean isQ, int domain) throws JMSException {
        long tok = this.startPhase("createTemporary");
        try {
            String connID = JMSUtils.getConnectionID();
            Map map = (Map)this.m_connTemp.get(connID);
            if (map.containsKey(dName)) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02301", this, dName, connID));
            }
            try {
                EvermindTemporaryDestination dest = isQ ? new EvermindTemporaryQueue(dName, connID, domain) : new EvermindTemporaryTopic(dName, connID, domain);
                map.put(dName, ServerDestination.createDestination(null, dest));
            }
            catch (Throwable ex) {
                JMSUtils.toJMSException("createTemporary(" + dName + "," + isQ + ")", ex);
            }
        }
        finally {
            this.stopPhase("createTemporary", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteTemporary(String dName) throws JMSException {
        long tok = this.startPhase("deleteTemporary");
        try {
            String connID = JMSUtils.getConnectionID();
            Map map = (Map)this.m_connTemp.get(connID);
            if (!map.containsKey(dName)) {
                JMSUtils.toInvalidDestinationException(JMSMessages.getMessage("J2EE JMS-02302", this, dName, connID));
            }
            ServerDestination sdest = (ServerDestination)map.get(dName);
            map.remove(dName);
            try {
                sdest.close();
            }
            catch (Throwable ex) {
                JMSUtils.toJMSException("deleteTemporary", ex);
            }
        }
        finally {
            this.stopPhase("deleteTemporary", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit(SessionID sessionID) throws JMSException {
        long tok = this.startPhase("commit");
        try {
            Map m = this.findSession(sessionID);
            if (m == null) {
                return;
            }
            TxDestinations td = (TxDestinations)m.get(sessionID);
            this.preTx(sessionID, true, td.isAnyDestinationPersistent());
            Iterator iter = td.getDestinations().iterator();
            while (iter.hasNext()) {
                ServerDestination sdest = (ServerDestination)iter.next();
                sdest.commit(sessionID);
            }
            this.postTx(m, sessionID, td.isAnyDestinationPersistent());
        }
        finally {
            this.stopPhase("commit", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(SessionID sessionID) throws JMSException {
        long tok = this.startPhase("rollback");
        try {
            Map m = this.findSession(sessionID);
            if (m == null) {
                return;
            }
            TxDestinations td = (TxDestinations)m.get(sessionID);
            this.preTx(sessionID, false, td.isAnyDestinationPersistent());
            Iterator iter = td.getDestinations().iterator();
            while (iter.hasNext()) {
                ServerDestination sdest = (ServerDestination)iter.next();
                sdest.rollback(sessionID);
            }
            this.postTx(m, sessionID, td.isAnyDestinationPersistent());
        }
        finally {
            this.stopPhase("rollback", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepareX(SessionID xid) throws JMSException {
        long tok = this.startPhase("prepareX");
        try {
            Map m = this.findSession(xid);
            if (m == null) {
                return;
            }
            TxDestinations td = (TxDestinations)m.get(xid);
            if (this.m_server != null) {
                this.m_server.prepare(xid, td.isAnyDestinationPersistent());
            }
        }
        finally {
            this.stopPhase("prepareX", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SessionID[] recoverX() throws JMSException {
        long tok = this.startPhase("recoverX");
        SessionID[] xids = null;
        try {
            if (this.m_server != null) {
                xids = this.m_server.recover();
            }
        }
        finally {
            this.stopPhase("recoverX", tok);
        }
        return xids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int createConsumer(String dName, String name, String selector, boolean noLocal) throws JMSException {
        long tok = this.startPhase("createConsumer");
        try {
            String clientID = JMSUtils.getClientID();
            String connID = JMSUtils.getConnectionID();
            ServerDestination sdest = this.findDestination(dName);
            ConsumerInfo cons = ConsumerInfo.find(clientID, name);
            if (!JMSUtils.isNull(name)) {
                this.checkSubscribe(sdest.getDestination());
            }
            this.checkDequeue(sdest.getDestination());
            if (cons == null) {
                cons = new ConsumerInfo(sdest, name, selector, noLocal, clientID, connID);
            } else if (!cons.isClosed()) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02303", this, cons));
            } else if (!cons.isSame(dName, selector, noLocal)) {
                cons.close();
                cons.remove(this.findDestination(cons.getDestination()));
                cons = new ConsumerInfo(sdest, name, selector, noLocal, clientID, connID);
            } else {
                cons.open();
            }
            ((Set)this.m_connCons.get(connID)).add(cons);
            int n = cons.getCount();
            return n;
        }
        finally {
            this.stopPhase("createConsumer", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeConsumer(int consID) throws JMSException {
        long tok = this.startPhase("closeConsumer");
        try {
            ConsumerInfo cons = ConsumerInfo.find(consID);
            if (cons == null) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02304", this, new Integer(consID)));
            }
            this.closeConsumer(cons);
            String connID = JMSUtils.getConnectionID();
            ((Set)this.m_connCons.get(connID)).remove(cons);
        }
        finally {
            this.stopPhase("closeConsumer", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unsubscribe(String name) throws JMSException {
        long tok = this.startPhase("unsubscribe");
        try {
            String clientID = JMSUtils.getClientID();
            ConsumerInfo cons = ConsumerInfo.find(clientID, name);
            if (cons == null) {
                JMSUtils.toInvalidDestinationException(JMSMessages.getMessage("J2EE JMS-02305", this, name, clientID));
            }
            ServerDestination sdest = this.findDestination(cons.getDestination());
            this.checkSubscribe(sdest.getDestination());
            if (!cons.isClosed()) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02303", this, cons));
            }
            cons.remove(sdest);
        }
        finally {
            this.stopPhase("unsubscribe", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List listMessages(String dName, String name, SessionID sessionID, String selector) throws JMSException {
        long tok = this.startPhase("listMessages");
        try {
            ServerDestination sdest = this.findDestination(dName);
            this.checkBrowse(sdest.getDestination());
            List list = sdest.listMessages(name, sessionID, MessageSelector.getSelector(selector));
            return list;
        }
        finally {
            this.stopPhase("listMessages", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EvermindMessage peekMessage(String dName, String name, String msgID) throws JMSException {
        long tok = this.startPhase("peekMessage");
        try {
            EvermindMessage evermindMessage = JMSUtils.checkClone(this.findDestination(dName).peekMessage(name, msgID));
            return evermindMessage;
        }
        finally {
            this.stopPhase("peekMessage", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void enqMessage(String dName, SessionID sessionID, boolean keepState, EvermindMessage msg, boolean isXA) throws JMSException {
        long tok = this.startPhase("enqMessage");
        try {
            String connID = JMSUtils.getConnectionID();
            ServerDestination sdest = this.findDestination(dName, true);
            this.checkEnqueue(sdest.getDestination());
            if (keepState) {
                this.addSession(sessionID, sdest, isXA);
            }
            sdest.enq(connID, sessionID, keepState, JMSUtils.checkClone(msg));
        }
        finally {
            this.stopPhase("enqMessage", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EvermindMessage deqMessage(int consID, SessionID sessionID, String txid, boolean keepState, boolean isXA) throws JMSException {
        long tok = this.startPhase("deqMessage");
        try {
            ConsumerInfo cons = ConsumerInfo.find(consID);
            ServerDestination sdest = this.findDestination(cons.getDestination());
            this.checkDequeue(sdest.getDestination());
            if (keepState) {
                this.addSession(sessionID, sdest, isXA);
            }
            EvermindMessage evermindMessage = sdest.deq(cons, sessionID, txid, keepState);
            return evermindMessage;
        }
        finally {
            this.stopPhase("deqMessage", tok);
        }
    }

    Map getDestinationMap() {
        return this.m_dest;
    }

    Map getXaState() {
        return this.m_xaSess;
    }

    synchronized void closeAllConnections() {
        Iterator iter = this.m_connClnt.keySet().iterator();
        while (iter.hasNext()) {
            String connID = (String)iter.next();
            String clientID = (String)this.m_connClnt.get(connID);
            this.closeConnection(clientID, connID);
        }
        this.m_connClnt.clear();
        this.m_connUser.clear();
        this.m_xaSess.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expireMessages() {
        JMSStats stats;
        ArrayList l = new ArrayList();
        JMSProvider jMSProvider = this;
        synchronized (jMSProvider) {
            this.getDestinations(this.m_dest, l);
            Iterator iter = this.m_connTemp.entrySet().iterator();
            while (iter.hasNext()) {
                this.getDestinations((Map)iter.next().getValue(), l);
            }
        }
        this.messageCountTotal = 0L;
        this.pendingMessageCountTotal = 0L;
        this.storeSizeTotal = 0L;
        this.expireList(l);
        if (this.m_server != null && (stats = this.m_server.getStats()) != null) {
            stats.state("messageCount", new Long(this.messageCountTotal));
            stats.state("pendingMessageCount", new Long(this.pendingMessageCountTotal));
            if (m_msgSizeIsValid) {
                stats.state("storeSize", new Long(this.storeSizeTotal));
            }
        }
    }

    private void getDestinations(Map map, List l) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            l.add(iter.next().getValue());
        }
    }

    private void expireList(List l) {
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            ((ServerDestination)iter.next()).expireMessages();
        }
    }

    void clearState() {
        this.m_dest.clear();
        ConsumerInfo.clear();
        this.m_clntConn.clear();
        this.m_connClnt.clear();
        this.m_connUser.clear();
        this.m_connTemp.clear();
        this.m_connSess.clear();
        this.m_connCons.clear();
    }

    private User getUser(String u) {
        try {
            return this.m_server == null ? null : this.m_server.getApplicationServer().getUserManager().getUser(u);
        }
        catch (Throwable ex) {
            s_traceLogger.fine("getUser({0})", new Object[]{u}, ex);
            return null;
        }
    }

    private Group getGroup(String g) {
        try {
            return this.m_server == null ? null : this.m_server.getApplicationServer().getUserManager().getGroup(g);
        }
        catch (Throwable ex) {
            s_traceLogger.fine("getGroup({0})", new Object[]{g}, ex);
            return null;
        }
    }

    private void checkAdmin(String op) throws JMSException {
        if (this.m_server != null) {
            this.m_server.checkAdmin(op, (User)this.m_connUser.get(JMSUtils.getConnectionID()));
        }
    }

    private void checkEnqueue(Destination d) throws JMSException {
        this.checkPermission(d, "enqueue");
    }

    private void checkDequeue(Destination d) throws JMSException {
        this.checkPermission(d, "dequeue");
    }

    private void checkBrowse(Destination d) throws JMSException {
        this.checkPermission(d, "browse");
    }

    private void checkSubscribe(Destination d) throws JMSException {
        this.checkPermission(d, "subscribe");
    }

    private void checkPermission(Destination d, String op) throws JMSException {
        JMSPermission p;
        if (!JMSServer.getCheckPermissions() || JMSUtils.isTemp(d)) {
            return;
        }
        User u = (User)this.m_connUser.get(JMSUtils.getConnectionID());
        if (!this.hasPermission(u, p = new JMSPermission(JMSUtils.getName(d), op), new HashSet())) {
            JMSUtils.toJMSSecurityException(JMSMessages.getMessage("J2EE JMS-02307", this, u, op, d));
        }
    }

    private boolean hasPermission(Principal ug, Permission p, Set seen) {
        boolean ret = false;
        if (ug != null && !seen.contains(ug)) {
            seen.add(ug);
            if (ug instanceof RoleUser) {
                RoleUser ru = (RoleUser)ug;
                SecurityRole sr = ru.getRole();
                if (sr != null) {
                    ret = this.hasPermission(sr.getUsers(), p, seen, true) || this.hasPermission(sr.getGroups(), p, seen, false);
                }
            } else {
                ret = JMSProvider.hasPermission(ug, AdministrationPermission.INSTANCE) || JMSProvider.hasPermission(ug, p);
            }
        }
        return ret;
    }

    private boolean hasPermission(List l, Permission p, Set seen, boolean isUser) {
        if (l == null || l.size() < 1) {
            return false;
        }
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            Principal ug;
            String name = (String)iter.next();
            if (JMSUtils.isNull(name) || !this.hasPermission(ug = isUser ? this.getUser(name) : this.getGroup(name), p, seen)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasPermission(Principal ug, Permission p) {
        return ug instanceof User ? ((User)ug).hasPermission(p) : (ug instanceof Group ? ((Group)ug).hasPermission(p) : false);
    }

    private void preTx(SessionID sessionID, boolean isCommit, boolean isPersist) throws JMSException {
        if (this.m_server != null) {
            this.m_server.preTx(sessionID, isCommit, isPersist);
        }
    }

    private void postTx(Map m, SessionID sessionID, boolean isPersist) {
        m.remove(sessionID);
        if (this.m_server != null) {
            this.m_server.postTx(sessionID, isPersist);
        }
    }

    private void addTx(SessionID sessionID, boolean isXA) {
        if (this.m_server != null) {
            this.m_server.addTx(sessionID, isXA);
        }
    }

    private Map findSession(SessionID sessionID) {
        if (this.m_xaSess.containsKey(sessionID)) {
            return this.m_xaSess;
        }
        String connID = JMSUtils.getConnectionID();
        Map m = (Map)this.m_connSess.get(connID);
        if (m != null && m.containsKey(sessionID)) {
            return m;
        }
        return null;
    }

    private ServerDestination findDestination(Destination d) throws JMSException {
        return this.findDestination(d, false);
    }

    private ServerDestination findDestination(String dName) throws JMSException {
        return this.findDestination(dName, false);
    }

    private ServerDestination findDestination(Destination d, boolean forEnq) throws JMSException {
        return this.findDestination(JMSUtils.getName(d));
    }

    private ServerDestination findDestination(String dName, boolean forEnq) throws JMSException {
        String connID = JMSUtils.getConnectionID();
        String key = null;
        Map map = null;
        if (this.m_dest.containsKey(dName)) {
            key = dName;
            map = this.m_dest;
        } else {
            Map tmpD = (Map)this.m_connTemp.get(connID);
            if (tmpD.containsKey(dName)) {
                key = dName;
                map = tmpD;
            }
            if (key == null && forEnq) {
                Iterator iter = this.m_connTemp.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    tmpD = (Map)entry.getValue();
                    if (!tmpD.containsKey(dName)) continue;
                    key = dName;
                    map = tmpD;
                    break;
                }
            }
        }
        if (key == null || map == null) {
            JMSUtils.toInvalidDestinationException(JMSMessages.getMessage("J2EE JMS-02306", this, dName, connID));
        }
        return (ServerDestination)map.get(key);
    }

    private void createConnection(String clientID, String connID) {
        this.m_connClnt.put(connID, clientID);
        this.m_connTemp.put(connID, new HashMap());
        this.m_connSess.put(connID, new HashMap());
        this.m_connCons.put(connID, new HashSet());
    }

    private void closeConnection(String clientID, String connID) {
        Set s = (Set)this.m_clntConn.get(clientID);
        if (s != null) {
            s.remove(connID);
            if (s.size() == 0) {
                this.m_clntConn.remove(clientID);
            }
        }
        if (!this.m_connClnt.containsKey(connID)) {
            return;
        }
        Iterator<Object> iter = null;
        iter = ((Set)this.m_connCons.get(connID)).iterator();
        while (iter.hasNext()) {
            this.closeConsumer((ConsumerInfo)iter.next());
        }
        this.m_connCons.remove(connID);
        iter = ((Map)this.m_connSess.get(connID)).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            SessionID sessionID = (SessionID)entry.getKey();
            Set dests = ((TxDestinations)entry.getValue()).getDestinations();
            this.closeSession(sessionID, dests);
        }
        this.m_connSess.remove(connID);
        iter = ((Map)this.m_connTemp.get(connID)).entrySet().iterator();
        while (iter.hasNext()) {
            ServerDestination sdest = (ServerDestination)((Map.Entry)iter.next()).getValue();
            try {
                sdest.close();
            }
            catch (Throwable ex) {
                s_traceLogger.fine("closeConnection({0})", new Object[]{connID}, ex);
            }
        }
        this.m_connTemp.remove(connID);
    }

    private void addSession(SessionID sessionID, ServerDestination sdest, boolean isXA) {
        Map m = isXA ? this.m_xaSess : (Map)this.m_connSess.get(JMSUtils.getConnectionID());
        TxDestinations td = (TxDestinations)m.get(sessionID);
        if (td == null) {
            td = new TxDestinations();
            m.put(sessionID, td);
        }
        td.add(sdest);
        this.addTx(sessionID, isXA);
    }

    private void closeSession(SessionID sessionID, Set sdests) {
        Iterator iter = sdests.iterator();
        while (iter.hasNext()) {
            ServerDestination sdest = (ServerDestination)iter.next();
            try {
                sdest.rollback(sessionID);
            }
            catch (Throwable ex) {
                s_traceLogger.fine("closeSession({0})", new Object[]{sessionID}, ex);
            }
        }
    }

    private void closeConsumer(ConsumerInfo cons) {
        try {
            cons.close();
            if (cons.isDurable()) {
                return;
            }
            ServerDestination sdest = this.findDestination(cons.getDestination());
            if (sdest != null) {
                cons.remove(sdest);
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("closeConsumer({0})", new Object[]{cons}, ex);
        }
    }

    private long startPhase(String func) {
        return this.m_server == null ? -1L : this.m_server.getStats().phase(func);
    }

    private void stopPhase(String func, long tok) {
        if (this.m_server != null) {
            this.m_server.getStats().phase(func, tok);
        }
    }
}

