/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.ConfigPropertyEvent;
import com.evermind.server.jms.ConfigPropertyListener;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.Knobs;
import com.evermind.server.jms.XMLConfigPropertiesController;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KnobsController
implements XMLConfigPropertiesController {
    private final Map m_listeners = new HashMap();
    private final Map m_persist = new HashMap();
    private static KnobsController s_kc = null;
    private static final Object LISTEN_TO_ALL = new Object();

    private KnobsController() {
    }

    static KnobsController getKnobsController() {
        if (s_kc == null) {
            s_kc = new KnobsController();
        }
        return s_kc;
    }

    public synchronized void setConfigProperties(Node parent) throws InstantiationException {
        if (parent != null) {
            ArrayList<Throwable> exList = new ArrayList<Throwable>();
            NodeList children = parent.getChildNodes();
            for (int index = 0; index < children.getLength(); ++index) {
                try {
                    Node child = children.item(index);
                    if (!child.getNodeName().equals("config-property")) continue;
                    String propName = JMSUtils.get(child, "name", null);
                    String propValue = JMSUtils.get(child, "value", null);
                    if (!this.isSystemPropertySet(propName)) {
                        this.setConfigProperty(propName, propValue);
                        continue;
                    }
                    this.savePersistentKnob(propName, propValue);
                    continue;
                }
                catch (Throwable ex) {
                    exList.add(ex);
                }
            }
            if (exList.size() > 0) {
                JMSUtils.toInstantiationException("setConfigProperties", exList);
            }
        }
    }

    public synchronized void writeXML(PrintWriter out, String indent) throws IOException {
        if (this.m_persist.size() == 0) {
            return;
        }
        out.println("");
        out.println(this.getIndent(indent, 1) + "<config-properties>");
        Iterator iter = this.m_persist.keySet().iterator();
        while (iter.hasNext()) {
            String propName = (String)iter.next();
            Object propValue = this.m_persist.get(propName);
            out.println(this.getIndent(indent, 2) + "<config-property name=\"" + propName + "\" value=\"" + propValue.toString() + "\"/>");
        }
        out.println(this.getIndent(indent, 1) + "</config-properties>");
    }

    public synchronized Map getConfigProperties() {
        return Knobs.getRuntimeConfigKnobs();
    }

    public synchronized Object getConfigProperty(String prop) {
        return Knobs.getKnob(prop);
    }

    public synchronized void setConfigProperty(String property, String newValue) {
        Object wrappedValue;
        Knobs knob = Knobs.findKnob(property);
        if (knob == null) {
            throw new IllegalArgumentException(JMSMessages.getMessage("J2EE JMS-02632", property));
        }
        if (newValue == null || newValue.equals("")) {
            newValue = String.valueOf(knob.getDefault());
        }
        if (!(wrappedValue = JMSUtils.makeWrappedPrimitive(knob.getType(), newValue)).equals(knob.getValue())) {
            this.knobChanged(property, wrappedValue);
        }
        this.savePersistentKnob(property, newValue);
    }

    public synchronized void addConfigPropertyListener(ConfigPropertyListener listener) {
        this.addListener(LISTEN_TO_ALL, listener);
    }

    public synchronized void addConfigPropertyListener(String prop, ConfigPropertyListener listener) {
        this.addListener(prop, listener);
    }

    public synchronized Object listenToConfigProperty(String prop, ConfigPropertyListener listener) {
        this.addListener(prop, listener);
        return this.getConfigProperty(prop);
    }

    private synchronized void savePersistentKnob(String propName, String propValue) {
        Knobs knob = Knobs.findKnob(propName);
        if (knob == null) {
            throw new IllegalArgumentException(JMSMessages.getMessage("J2EE JMS-02632", propName));
        }
        Object wrappedValue = JMSUtils.makeWrappedPrimitive(knob.getType(), propValue);
        if (!wrappedValue.equals(knob.getDefault())) {
            this.m_persist.put(propName, propValue);
        } else {
            this.m_persist.remove(propName);
        }
    }

    private boolean isSystemPropertySet(String propName) {
        boolean propIsSet = false;
        try {
            propIsSet = Knobs.getProperty(propName) != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return propIsSet;
    }

    private void addListener(Object key, ConfigPropertyListener listener) {
        Set<WeakReference<ConfigPropertyListener>> listenerSet = null;
        listenerSet = this.m_listeners.containsKey(key) ? (Set)this.m_listeners.get(key) : new HashSet<WeakReference<ConfigPropertyListener>>();
        listenerSet.add(new WeakReference<ConfigPropertyListener>(listener));
        this.m_listeners.put(key, listenerSet);
    }

    private void knobChanged(String knob, Object newValue) {
        Knobs.setKnob(knob, newValue);
        ConfigPropertyEvent event = new ConfigPropertyEvent(this, knob, newValue);
        if (this.m_listeners.containsKey(knob)) {
            this.sendEventToListeners(event, ((Set)this.m_listeners.get(knob)).iterator());
        }
        if (this.m_listeners.containsKey(LISTEN_TO_ALL)) {
            this.sendEventToListeners(event, ((Set)this.m_listeners.get(LISTEN_TO_ALL)).iterator());
        }
    }

    private void sendEventToListeners(ConfigPropertyEvent event, Iterator iter) {
        while (iter.hasNext()) {
            ConfigPropertyListener listener = (ConfigPropertyListener)((WeakReference)iter.next()).get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            listener.onConfigPropertyChange(event);
        }
    }

    private String getIndent(String baseIndent, int level) {
        StringBuffer indent = new StringBuffer();
        for (int index = 0; index < level; ++index) {
            indent.append(baseIndent);
        }
        return indent.toString();
    }
}

