/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.config;

import com.evermind.server.jms.config.JMSRouterJobConfig;
import com.evermind.server.jms.config.XMLJMSRouterJobConfig;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class JMSRouterConfig {
    public static final String MAX_LOCAL_CONC = "max-local-concurrency";
    private HashMap m_jobs = new HashMap();
    private Properties m_globalProps = new Properties();
    private static List s_globalAttrList = new ArrayList();

    public void addJob(JMSRouterJobConfig job) {
        this.m_jobs.put(job.getJobName(), job);
    }

    public Map getJobs() {
        return this.m_jobs;
    }

    public String getRootAttrsString() {
        String rootAttrsStr = "";
        Enumeration<?> attrs = this.m_globalProps.propertyNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            String attrVal = (String)this.m_globalProps.get(attrName);
            if (rootAttrsStr == null) {
                rootAttrsStr = attrName + "=\"" + attrVal + "\" ";
                continue;
            }
            rootAttrsStr = rootAttrsStr + attrName + "=\"" + attrVal + "\" ";
        }
        return rootAttrsStr;
    }

    public Properties getProperties() {
        Properties allProps = new Properties();
        allProps.putAll((Map<?, ?>)this.m_globalProps);
        Iterator iter = this.m_jobs.values().iterator();
        while (iter.hasNext()) {
            JMSRouterJobConfig jc = (JMSRouterJobConfig)iter.next();
            allProps.putAll((Map<?, ?>)jc.getProperties());
        }
        return allProps;
    }

    public void setProperties(Properties props) {
        List attrList = this.getAttrList();
        Iterator<Object> iter = attrList.iterator();
        if (props != null) {
            while (iter.hasNext()) {
                String attrName = (String)iter.next();
                this.setProperty(attrName, props.getProperty(attrName));
            }
            Map jobs = this.sortJobProps(props);
            iter = jobs.keySet().iterator();
            while (iter.hasNext()) {
                String jobName = (String)iter.next();
                this.addJob(new XMLJMSRouterJobConfig(jobName, (Properties)jobs.get(jobName)));
            }
        }
    }

    protected List getAttrList() {
        return s_globalAttrList;
    }

    protected Map sortJobProps(Properties props) {
        HashMap<String, Properties> jobs = new HashMap<String, Properties>();
        Enumeration<Object> keys = props.keys();
        if (keys == null) {
            return null;
        }
        while (keys.hasMoreElements()) {
            String propName = (String)keys.nextElement();
            if (!propName.startsWith("job.")) continue;
            String temp = propName.substring(propName.indexOf(46) + 1);
            String jobName = temp.substring(0, temp.indexOf(46));
            String value = props.getProperty(propName);
            if (jobs.containsKey(jobName)) {
                ((Properties)jobs.get(jobName)).setProperty(propName, value);
                continue;
            }
            Properties jprops = new Properties();
            jprops.setProperty(propName, value);
            jobs.put(jobName, jprops);
        }
        return jobs;
    }

    protected void setProperty(String name, String value) {
        if (value != null) {
            this.m_globalProps.setProperty(name, value);
        }
    }

    static {
        s_globalAttrList.add(MAX_LOCAL_CONC);
    }
}

