/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.BooleanExpression;
import com.evermind.server.jms.filter.FieldAccess;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.NoSuchFieldException;
import javax.jms.Message;

class BooleanFieldName
extends BooleanExpression {
    private String m_fieldName;
    private FieldAccess acc;

    BooleanFieldName(String name, FieldAccess acc) {
        super(name);
        this.m_fieldName = name;
        this.acc = acc;
    }

    public void eval(Message m) {
        this.m_null = false;
        this.m_val = false;
        Boolean b = null;
        try {
            Object o = this.acc.getValue(m);
            if (o instanceof Boolean) {
                b = (Boolean)o;
            }
        }
        catch (NoSuchFieldException nsfEx) {
            this.m_null = true;
        }
        if (b == null) {
            this.m_null = true;
        } else {
            this.m_val = b;
        }
    }

    public boolean equals(Object op) {
        if (op instanceof BooleanFieldName) {
            return this.m_fieldName.equals(((BooleanFieldName)op).m_fieldName);
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        return app.apply(this);
    }
}

