/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.DynamicExpression;
import com.evermind.server.jms.filter.FieldAccess;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.NoSuchFieldException;
import com.evermind.server.jms.filter.QueryTypeException;
import javax.jms.Message;

class DynamicFieldName
extends DynamicExpression {
    private String m_fieldName;
    private FieldAccess acc;

    DynamicFieldName(String name, FieldAccess acc) {
        super(name);
        this.acc = acc;
        this.m_fieldName = name;
    }

    public void eval(Message m) throws QueryTypeException {
        this.m_null = false;
        this.boolean_val = false;
        Object i = null;
        try {
            i = this.acc.getValue(m);
        }
        catch (NoSuchFieldException nsfEx) {
            this.m_null = true;
        }
        if (i == null) {
            this.m_null = true;
            return;
        }
        this.cur_type = -1;
        if (i instanceof Integer) {
            this.setIntVal((Integer)i);
        } else if (i instanceof Long) {
            this.setLongVal((Long)i);
        } else if (i instanceof Float) {
            this.setFloatVal(((Float)i).floatValue());
        } else if (i instanceof Double) {
            this.setDoubleVal((Double)i);
        } else if (i instanceof String) {
            this.setStringVal((String)i);
        } else if (i instanceof Boolean) {
            this.setBooleanVal((Boolean)i);
        } else {
            throw new QueryTypeException("acc.getValue returns " + i.getClass().getName());
        }
    }

    public boolean equals(Object op) {
        if (op instanceof DynamicFieldName) {
            return this.m_fieldName.equals(((DynamicFieldName)op).m_fieldName);
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        return app.apply(this);
    }
}

