/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.FieldAccess;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IntegerExpression;
import com.evermind.server.jms.filter.NoSuchFieldException;
import javax.jms.Message;

class IntegerFieldName
extends IntegerExpression {
    private String m_fieldName;
    private FieldAccess acc;

    IntegerFieldName(String name, FieldAccess acc) {
        super(name);
        this.acc = acc;
        this.m_fieldName = name;
    }

    public void eval(Message m) {
        this.m_null = false;
        Integer i = null;
        try {
            Object o = this.acc.getValue(m);
            i = o instanceof Integer ? (Integer)o : (o instanceof Byte ? new Integer(((Byte)o).byteValue()) : (o instanceof Short ? new Integer(((Short)o).shortValue()) : null));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (i == null) {
            this.m_null = true;
        } else {
            this.m_val = i;
        }
    }

    public boolean equals(Object op) {
        if (op instanceof IntegerFieldName) {
            return this.m_fieldName.equals(((IntegerFieldName)op).m_fieldName);
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        return app.apply(this);
    }
}

