/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.CMTQueueSession;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;

public class CMTQueueSender
implements QueueSender {
    private CMTQueueSession session;
    private QueueSender sender;

    public CMTQueueSender(CMTQueueSession session, QueueSender sender) {
        this.session = session;
        this.sender = sender;
    }

    public int getDeliverMode() throws JMSException {
        return this.sender.getDeliveryMode();
    }

    public void send(Message message) throws JMSException {
        this.session.intercept();
        this.sender.send(message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.intercept();
        this.sender.send(message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.intercept();
        this.sender.send(queue, message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.session.intercept();
        this.sender.send(queue, message);
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.sender.setPriority(defaultPriority);
    }

    public long getTimeToLive() throws JMSException {
        return this.sender.getTimeToLive();
    }

    public void close() throws JMSException {
        this.sender.close();
    }

    public Queue getQueue() throws JMSException {
        return this.sender.getQueue();
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.sender.getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.sender.setDisableMessageTimestamp(value);
    }

    public int getDeliveryMode() throws JMSException {
        return this.sender.getDeliveryMode();
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.sender.getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int mode) throws JMSException {
        this.sender.setDeliveryMode(mode);
    }

    public int getPriority() throws JMSException {
        return this.sender.getPriority();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.sender.setTimeToLive(timeToLive);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.sender.setDisableMessageID(value);
    }

    public Destination getDestination() throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public void send(Destination d, Message msg) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public void send(Destination d, Message msg, int delmode, int priority, long ttl) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }
}

