/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.multicastjms.CMTQueueReceiver;
import com.evermind.server.multicastjms.CMTQueueSender;
import com.evermind.server.multicastjms.FilterSession;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.XAQueueSession;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class CMTQueueSession
extends FilterSession
implements QueueSession {
    private ApplicationServerTransaction currentTransaction;
    private XAQueueSession session;

    public CMTQueueSession(XAQueueSession session) {
        super((Session)session);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return new CMTQueueReceiver(this, this.session.getQueueSession().createReceiver(queue));
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return new CMTQueueReceiver(this, this.session.getQueueSession().createReceiver(queue, messageSelector));
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        if (queue == null) {
            throw new NullPointerException("queue was null");
        }
        return new CMTQueueSender(this, this.session.getQueueSession().createSender(queue));
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.session.getQueueSession().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.session.getQueueSession().createBrowser(queue, messageSelector);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.session.getQueueSession().createTemporaryQueue();
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.session.getQueueSession().createQueue(queueName);
    }

    public void intercept() throws JMSException {
        Transaction tx = null;
        try {
            tx = ApplicationServer.getInstance().getTransactionManager().getTransaction();
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        if (tx != this.currentTransaction) {
            if (tx == null) {
                this.currentTransaction = null;
            } else {
                try {
                    JMSMessages.infoDirectEnlistment();
                    tx.enlistResource(this.session.getXAResource());
                }
                catch (RollbackException e) {
                    throw new JMSException("Transaction was rolled back while adding XAResource: " + e.getMessage());
                }
                catch (SystemException e) {
                    throw new JMSException("System error while adding XAResource: " + e.getMessage());
                }
            }
        }
    }
}

