/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.net.SocketNetworkConnection;
import com.evermind.server.multicastjms.EvermindConnection;
import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindQueue;
import com.evermind.server.multicastjms.EvermindQueueBrowser;
import com.evermind.server.multicastjms.EvermindQueueBrowserEnumeration;
import com.evermind.server.multicastjms.EvermindQueueConnectionConsumer;
import com.evermind.server.multicastjms.EvermindQueueSession;
import com.evermind.server.multicastjms.JMSServerConnection;
import com.evermind.server.multicastjms.MessageSelector;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import javax.jms.ConnectionConsumer;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;

public class EvermindQueueConnection
extends EvermindConnection
implements QueueConnection {
    protected InetAddress server;
    protected int port;
    protected String username;
    protected String password;
    static int currentMessageID = 1;
    private JMSServerConnection connection;
    Map temporaryQueues;

    public EvermindQueueConnection(InetAddress server, int port, String username, String password) throws JMSException {
        this.server = server;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public void start() throws JMSException {
        this.started = true;
    }

    public void stop() throws JMSException {
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        try {
            this.stop();
            this.disconnect();
        }
        finally {
            super.close();
        }
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) {
        return new EvermindQueueConnectionConsumer(this, queue, messageSelector, sessionPool, maxMessages);
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new EvermindQueueSession(this, transacted, acknowledgeMode);
    }

    public List getDefinedQueueNames() throws JMSException {
        if (this.connection == null) {
            this.connect();
        }
        return this.connection.getDefinedQueueNames();
    }

    public EvermindQueueBrowserEnumeration getQueueBrowserEnumeration(EvermindQueueBrowser browser) throws JMSException {
        if (this.connection == null) {
            this.connect();
        }
        return this.connection.getQueueBrowserEnumeration(browser);
    }

    public void getQueueBrowserEnumerationMessages(EvermindQueueBrowserEnumeration enumeration) throws JMSException {
        if (this.connection == null) {
            this.connect();
        }
        this.connection.getQueueBrowserEnumerationMessages(enumeration);
    }

    public void send(String destination, EvermindMessage message, boolean isQueue) throws JMSException {
        if (this.connection == null) {
            this.connect();
        }
        this.connection.send(destination, message, isQueue);
    }

    public EvermindMessage receive(String destination, String selector, long timeout, byte acknowledgeMode) throws JMSException {
        if (this.connection == null) {
            this.connect();
        }
        this.waitForStart(timeout);
        return this.connection.receive(destination, selector, timeout, acknowledgeMode);
    }

    public void createQueue(String name) throws JMSException {
        if (this.connection == null) {
            this.connect();
        }
        this.connection.createQueue(name);
    }

    public QueueBrowser createBrowser(EvermindQueueSession session, EvermindQueue queue, MessageSelector selector) throws InvalidDestinationException {
        return new EvermindQueueBrowser(session, queue, selector);
    }

    public void acknowledgeMessages(EvermindMessage[] messages, int start, int end, boolean commit) throws JMSException {
        if (this.connection == null) {
            this.connect();
        }
        this.connection.acknowledgeMessages(messages, start, end, commit);
    }

    public void connect() throws JMSException {
        if (this.closed) {
            throw new JMSException("QueueConnection was closed");
        }
        if (this.connection == null) {
            try {
                this.connection = new JMSServerConnection(new SocketNetworkConnection(new Socket(this.server, this.port)), this.username, this.password);
            }
            catch (IOException e) {
                throw new JMSException("Unable to connect to JMSServer (" + this.server + ":" + this.port + ")");
            }
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public String toString() {
        if (this.connection != null) {
            return "QueueConnection " + this.connection;
        }
        return "QueueConnection " + this.server + ":" + this.port;
    }
}

