/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindMessageProducer;
import com.evermind.server.multicastjms.EvermindQueue;
import com.evermind.server.multicastjms.EvermindQueueConnection;
import com.evermind.server.multicastjms.EvermindQueueSession;
import com.evermind.server.multicastjms.EvermindTemporaryQueue;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.Queue;
import javax.jms.QueueSender;

public class EvermindQueueSender
extends EvermindMessageProducer
implements QueueSender {
    protected EvermindQueueSession session;
    protected Queue queue;
    protected boolean disableMessageID;
    protected boolean disableMessageTimestamp;
    protected int priority;

    public EvermindQueueSender(EvermindQueueSession session, EvermindQueue queue) {
        this.session = session;
        this.queue = queue;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void send(Message message) throws InvalidDestinationException, MessageFormatException, JMSException {
        this.send(this.queue, message);
    }

    public void send(Queue queue, Message message) throws InvalidDestinationException, MessageFormatException, JMSException {
        this.send(queue, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws InvalidDestinationException, MessageFormatException, JMSException {
        this.send(this.queue, message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, Message genericMessage, int deliveryMode, int priority, long timeToLive) throws InvalidDestinationException, MessageFormatException, JMSException {
        EvermindMessage message;
        try {
            message = (EvermindMessage)genericMessage;
        }
        catch (ClassCastException e) {
            throw new MessageFormatException("Invalid message");
        }
        if (!this.disableMessageID) {
            EvermindQueueConnection cfr_ignored_0 = this.session.connection;
            message.id = EvermindQueueConnection.currentMessageID++;
        }
        if (!this.disableMessageTimestamp) {
            message.timestamp = System.currentTimeMillis();
        }
        if (queue instanceof EvermindTemporaryQueue) {
            ((EvermindTemporaryQueue)queue).send(message, deliveryMode, priority, timeToLive);
            return;
        }
        if (message.getJMSExpiration() != 0L) {
            message.setJMSExpiration(message.timestamp + message.getJMSExpiration());
        }
        if (!this.session.connection.isStarted()) {
            throw new JMSException("QueueConnection not started");
        }
        this.session.send(queue, message);
    }
}

