/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.io.SingleReadBufferInputStream;
import com.evermind.net.NetworkConnection;
import com.evermind.security.User;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.JMSConnection;
import com.evermind.server.multicastjms.JMSServer;
import com.evermind.server.multicastjms.MessageID;
import com.evermind.server.multicastjms.MessageSelector;
import com.evermind.server.multicastjms.QueueBrowserEnumerationServerStub;
import com.evermind.util.JMSProperties;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

public class JMSRequestHandler
extends JMSConnection
implements Runnable {
    protected JMSServer server;
    protected NetworkConnection networkConnection;
    protected JMSConnection connection;
    protected int currentBrowserEnumerationID;
    protected Map browserEnumerations = new HashMap();
    protected List topicInterests;
    protected Map unacknowledgedMessages;
    protected int id;
    protected int queueID;
    protected User user;
    protected long startedTime;
    protected int requestID = 0;

    public JMSRequestHandler(JMSServer server, NetworkConnection networkConnection) throws IOException {
        super(new SingleReadBufferInputStream(networkConnection.getInputStream()), new BufferedOutputStream(networkConnection.getOutputStream()));
        this.server = server;
        this.networkConnection = networkConnection;
        this.id = server.getNextID();
    }

    public synchronized boolean dispatchMessage(int id, EvermindMessage message, byte acknowledgeMode) {
        if (acknowledgeMode == 2 && message != null) {
            this.addUnacknowledgedMessage(message);
        }
        try {
            if (message == null) {
                this.out.write(7);
                this.out.write(1);
                this.dataOut.writeInt(id);
            } else {
                this.out.write(message.getTypeID());
                this.out.write(1);
                this.dataOut.writeInt(id);
                message.write(this.out, this.dataOut);
            }
            this.out.flush();
            return true;
        }
        catch (IOException e) {
            this.close();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block39: {
            block38: {
                this.startedTime = HttpDateFormat.currentTimeMillis();
                try {
                    try {
                        this.dataOut.write(163);
                        this.dataOut.writeShort(1);
                        this.dataOut.writeShort(1);
                        if (this.dataIn.read() != 163) {
                            this.dataOut.writeInt(-1);
                            this.dataOut.writeUTF("Protocol identifier mismatch");
                            this.out.flush();
                            this.close();
                        }
                        ** GOTO lbl-1000
                    }
                    catch (IOException e) {
                        this.close();
                        var12_4 = null;
                        this.server.removeListeners(this);
                        this.server.removeClient(this);
                        return;
                    }
                    var12_1 = null;
                    this.server.removeListeners(this);
                    this.server.removeClient(this);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        major = this.dataIn.readShort();
                        minor = this.dataIn.readShort();
                        if (major == 1) ** GOTO lbl-1000
                        this.dataOut.writeInt(-1);
                        this.dataOut.writeUTF("Protocol version mismatch");
                        this.out.flush();
                        this.close();
                    }
                    break block38;
lbl-1000:
                    // 1 sources

                    {
                        username = this.dataIn.readUTF();
                        password = this.dataIn.readUTF();
                        this.user = this.server.getApplicationServer().getDefaultApplication().getUserManager().getUser(username);
                        if (this.user != null && this.user.authenticate(password)) ** GOTO lbl-1000
                        this.dataOut.writeInt(-1);
                        this.dataOut.writeUTF("Login failed");
                        this.out.flush();
                        this.close();
                    }
                    break block39;
lbl-1000:
                    // 1 sources

                    {
                        this.dataOut.writeInt(this.id);
                        this.out.flush();
                    }
                    this.server.addClient(this);
lbl48:
                    // 9 sources

                    try {
                        block30: while (this.alive) {
                            command = this.in.read();
                            try {
                                if (command >= 1 && command <= 7) {
                                    queueMessage = this.in.read() == 1;
                                    try {
                                        queueName = (String)this.queueNames.get(this.dataIn.readInt());
                                        message = EvermindMessage.readMessage(command, this.in, this.dataIn);
                                        if (queueMessage) {
                                            this.addMessage(queueName, message);
                                            continue;
                                        }
                                        this.server.handleTopicMessage(this, queueName, message);
                                        continue;
                                    }
                                    catch (ArrayIndexOutOfBoundsException e) {
                                        throw new IOException("ArrayIndexOutOfBoundsException: " + e.getMessage());
                                    }
                                }
                                switch (command) {
                                    case 65: {
                                        queue = (String)this.queueNames.get(this.dataIn.readInt());
                                        selectorID = this.dataIn.readInt();
                                        waitTime = this.dataIn.readLong();
                                        acknowledgeMode = this.dataIn.readByte();
                                        selector = selectorID >= 0 ? (MessageSelector)this.selectors.get(selectorID) : null;
                                        try {
                                            this.server.getMessage(queue, selector, this, waitTime, this.requestID++, acknowledgeMode);
                                        }
                                        catch (Throwable t) {
                                            this.server.log("Error retrieving message", t);
                                        }
                                        continue block30;
                                    }
                                    case 24: {
                                        this.queueNames.add(this.dataIn.readUTF());
                                        ** GOTO lbl48
                                    }
                                    case 25: {
                                        this.selectors.add(this.dataIn.readUTF());
                                        ** GOTO lbl48
                                    }
                                    case 66: {
                                        this.server.createQueue((String)this.queueNames.get(this.dataIn.readInt()));
                                        ** GOTO lbl48
                                    }
                                    case 67: {
                                        if (JMSProperties.getJMSDebug()) {
                                            System.out.println("CreateQueueBrowserEnumeration request");
                                        }
                                        messageSelectorID = this.dataIn.readInt();
                                        if (JMSProperties.getJMSDebug()) {
                                            System.out.println("SelectorID: " + messageSelectorID);
                                        }
                                        selector = null;
                                        if (messageSelectorID >= 0) {
                                            selector = MessageSelector.getSelector((String)this.selectors.get(messageSelectorID));
                                        }
                                        queueName = (String)this.queueNames.get(this.dataIn.readInt());
                                        if (JMSProperties.getJMSDebug()) {
                                            System.out.println("QueueName: " + queueName);
                                        }
                                        stub = new QueueBrowserEnumerationServerStub(this.server.getQueue(queueName), selector);
                                        stub.writeInitialResponse(this.out, this.dataOut);
                                        this.out.flush();
                                        this.browserEnumerations.put(new Integer(this.currentBrowserEnumerationID++), stub);
                                        ** GOTO lbl48
                                    }
                                    case 68: {
                                        this.browserEnumerations.remove(new Integer(this.dataIn.readInt()));
                                        ** GOTO lbl48
                                    }
                                    case 70: {
                                        this.handleMessageAcknowledgement(this.dataIn.readLong(), this.dataIn.readInt(), this.dataIn.readBoolean());
                                        ** GOTO lbl48
                                    }
                                    case 96: {
                                        this.listDefinedQueues();
                                        ** GOTO lbl48
                                    }
                                    case 71: {
                                        this.registerTopicInterest(this.dataIn.readUTF());
                                        ** GOTO lbl48
                                    }
                                    default: {
                                        if (!JMSProperties.getJMSDebug()) break;
                                        System.out.println("Unknown command: " + command);
                                    }
                                    case 64: 
                                }
                                this.alive = false;
                            }
                            catch (InvalidDestinationException e) {
                                this.out.write(64);
                                this.out.flush();
                                break;
                            }
                            catch (JMSException e) {
                                this.out.write(64);
                                this.out.flush();
                                break;
                            }
                        }
                        this.close();
                    }
                    catch (IOException var1_9) {
                    }
                    var12_5 = null;
                    this.server.removeListeners(this);
                    this.server.removeClient(this);
                    return;
                }
                catch (Throwable var11_28) {
                    var12_6 = null;
                    this.server.removeListeners(this);
                    this.server.removeClient(this);
                    throw var11_28;
                }
            }
            var12_2 = null;
            this.server.removeListeners(this);
            this.server.removeClient(this);
            return;
        }
        var12_3 = null;
        this.server.removeListeners(this);
        this.server.removeClient(this);
    }

    public void addMessage(String queueName, EvermindMessage message) throws InvalidDestinationException {
        this.server.addMessage(queueName, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.alive = false;
        try {
            if (this.topicInterests != null) {
                this.server.removeTopicInterest(this);
            }
            this.in.close();
            this.out.close();
            this.networkConnection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JMSRequestHandler jMSRequestHandler = this;
        synchronized (jMSRequestHandler) {
            if (this.unacknowledgedMessages != null) {
                Iterator iterator = this.unacknowledgedMessages.values().iterator();
                while (iterator.hasNext()) {
                    EvermindMessage message = (EvermindMessage)iterator.next();
                    if (message.originQueue == null) continue;
                    message.originQueue.add(message);
                }
                this.unacknowledgedMessages.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listDefinedQueues() throws IOException {
        Set queues;
        Set set = queues = this.server.getQueueNames();
        synchronized (set) {
            this.dataOut.writeInt(queues.size());
            Iterator iterator = queues.iterator();
            while (iterator.hasNext()) {
                this.dataOut.writeUTF((String)iterator.next());
            }
        }
    }

    public void sendTopicMessage(String topicName, EvermindMessage message) throws IOException {
        try {
            this.out.write(message.getTypeID());
            this.out.write(0);
            this.dataOut.writeUTF(topicName);
            message.write(this.out, this.dataOut);
            this.out.flush();
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public synchronized void registerTopicInterest(String name) {
        if (this.topicInterests == null) {
            this.topicInterests = new ArrayList();
            this.server.registerTopicInterest(this);
        }
        this.topicInterests.add(name);
    }

    public String toString() {
        return "RequestHandler " + this.id;
    }

    public synchronized void handleMessageAcknowledgement(long sender, int id, boolean commit) {
        if (this.unacknowledgedMessages == null) {
            return;
        }
        EvermindMessage message = (EvermindMessage)this.unacknowledgedMessages.remove(new MessageID(sender, id));
        if (message != null && !commit && message.originQueue != null) {
            message.originQueue.add(message);
        }
    }

    public synchronized void addUnacknowledgedMessage(EvermindMessage message) {
        if (this.unacknowledgedMessages == null) {
            this.unacknowledgedMessages = new HashMap();
        }
        this.unacknowledgedMessages.put(new MessageID(message.sender, message.id), message);
    }

    public NetworkConnection getConnection() {
        return this.networkConnection;
    }

    public User getUser() {
        return this.user;
    }

    public long getStartedTime() {
        return this.startedTime;
    }
}

