/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindQueue;
import com.evermind.server.multicastjms.EvermindQueueConnection;
import com.evermind.server.multicastjms.EvermindQueueSession;
import com.evermind.server.multicastjms.JMSServer;
import com.evermind.server.multicastjms.LocalQueueBrowser;
import com.evermind.server.multicastjms.MessageFilter;
import com.evermind.server.multicastjms.MessageSelector;
import com.evermind.server.multicastjms.ServerQueue;
import java.util.List;
import java.util.Map;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class LocalQueueConnection
extends EvermindQueueConnection {
    private JMSServer server;
    private boolean started;
    private Map unacknowledgedMessages;

    public LocalQueueConnection(JMSServer server) throws JMSException, InstantiationException {
        super(server.getConfig().getAddress(), server.getConfig().getPort(), "<local>", "<local>");
        this.server = server;
    }

    public List getDefinedQueueNames() throws JMSException {
        return this.server.getDefinedQueueNames();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public void send(String destination, EvermindMessage message, boolean isQueue) throws JMSException {
        this.server.addMessage(destination, message);
    }

    public EvermindMessage receive(String destination, String selector, long timeout, byte acknowledgeMode) throws JMSException {
        ServerQueue queue = this.server.getQueue(destination);
        if (queue == null) {
            throw new InvalidDestinationException("No such queue: " + destination);
        }
        EvermindMessage message = queue.receive(selector == null ? null : MessageSelector.getSelector(selector), timeout, acknowledgeMode);
        if (message != null) {
            EvermindMessage clone = message.cloneMessage();
            if (acknowledgeMode == 2) {
                clone.original = message;
            }
            return clone;
        }
        return null;
    }

    public void createQueue(String name) throws JMSException {
        this.server.createQueue(name);
    }

    public QueueBrowser createBrowser(EvermindQueueSession session, EvermindQueue queue, MessageSelector selector) throws InvalidDestinationException {
        ServerQueue serverQueue = this.server.getQueue(queue.getQueueName());
        if (serverQueue == null) {
            throw new InvalidDestinationException("No such queue: " + queue.getQueueName());
        }
        return new LocalQueueBrowser(queue, selector, serverQueue);
    }

    public synchronized void acknowledgeMessages(EvermindMessage[] messages, int start, int end, boolean commit) throws JMSException {
        for (int i = start; i < end; ++i) {
            EvermindMessage message = messages[i];
            if (message.original == null) continue;
            if (!commit) {
                message.original.originQueue.add(message.original);
            }
            message.original = null;
        }
    }

    public void addMessageFilter(Queue queue, MessageFilter filter) throws JMSException {
        ServerQueue serverQueue = this.server.getQueue(queue.getQueueName());
        if (serverQueue != null) {
            serverQueue.add(filter);
        }
    }

    public void remove(Queue queue, MessageFilter filter) throws JMSException {
        ServerQueue serverQueue = this.server.getQueue(queue.getQueueName());
        if (serverQueue != null) {
            serverQueue.remove(filter);
        }
    }

    public String toString() {
        return "Local " + super.toString();
    }

    public JMSServer getServer() {
        return this.server;
    }
}

