/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.net.SocketNetworkConnection;
import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindTopicConnection;
import com.evermind.server.multicastjms.JMSServerConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;

public class PointcastTopicConnection
extends EvermindTopicConnection {
    protected String username;
    protected String password;
    static int currentMessageID = 1;
    protected List topicInterestQueue = new ArrayList();
    JMSServerConnection connection;

    public PointcastTopicConnection(InetAddress address, int port, String username, String password) throws IOException {
        super(address, port);
        this.username = username;
        this.password = password;
    }

    public void start() throws JMSException {
        this.connect();
        super.start();
        this.registerTopicInterests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.alive) {
                String topicName;
                EvermindMessage message;
                try {
                    JMSServerConnection jMSServerConnection = this.connection;
                    synchronized (jMSServerConnection) {
                        message = this.connection.receiveTopicMessage();
                        topicName = this.connection.incomingTopic;
                        this.connection.incomingTopic = null;
                    }
                }
                catch (NullPointerException e) {
                    if (this.connection == null) {
                        return;
                    }
                    throw e;
                }
                if (message == null || !this.started) continue;
                this.notifySessions(topicName, message);
            }
        }
        catch (JMSException e) {
            if (!this.alive) {
                return;
            }
            this.alive = false;
            this.disconnectedMessage = e.getMessage();
        }
    }

    protected void send(String topicName, EvermindMessage message) throws IOException, JMSException {
        if (this.connection == null) {
            this.connect();
        }
        this.connection.send(topicName, message, false);
        EvermindMessage clone = message.cloneMessage();
        clone.sender = this.clientID;
        this.notifySessions(topicName, clone);
    }

    public synchronized void distribute(String topicName, EvermindMessage message) throws IOException, JMSException {
        if (this.connection == null) {
            this.connect();
        }
        this.connection.send(topicName, message, false);
    }

    protected synchronized void registerTopicInterest(String topicName) throws JMSException {
        if (this.started) {
            if (this.connection == null) {
                this.connect();
            }
            this.connection.registerTopicInterest(topicName);
        } else {
            this.topicInterestQueue.add(topicName);
        }
    }

    protected void connect() throws JMSException {
        if (this.closed) {
            throw new JMSException("TopicConnection was closed");
        }
        if (this.connection == null) {
            try {
                this.connection = new JMSServerConnection(new SocketNetworkConnection(new Socket(this.address, this.port)), this.username, this.password);
                this.clientID = this.connection.getID();
                this.alive = true;
                Thread thread = new Thread(this);
                thread.setName("PointcastTopicConnection");
                thread.start();
            }
            catch (IOException e) {
                throw new JMSException("Unable to connect to JMSServer (" + this.address + ":" + this.port + ")" + (e.getMessage() != null ? ": " + e.getMessage() : ""));
            }
        }
    }

    protected void registerTopicInterests() throws JMSException {
        while (!this.topicInterestQueue.isEmpty()) {
            this.connection.registerTopicInterest((String)this.topicInterestQueue.remove(0));
        }
    }

    public void close() throws JMSException {
        super.close();
        this.disconnect();
    }

    protected void disconnect() {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }
}

