/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.ServerMessageListener;
import com.evermind.server.multicastjms.ServerQueue;
import java.util.List;

public class ServerMessageListenerNotifier
implements Runnable {
    protected ServerQueue queue;
    protected long waitingUntil;

    public ServerMessageListenerNotifier(ServerQueue queue) {
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            long currentTime = System.currentTimeMillis();
            long waitToTime = 0L;
            ServerMessageListenerNotifier serverMessageListenerNotifier = this;
            synchronized (serverMessageListenerNotifier) {
                List list = this.queue.messages;
                synchronized (list) {
                    if (this.queue.listeners.isEmpty()) {
                        this.queue.listenerNotifier = null;
                        return;
                    }
                    for (int i = 0; i < this.queue.listeners.size(); ++i) {
                        ServerMessageListener listener = (ServerMessageListener)this.queue.listeners.get(i);
                        if (listener.endTime > 0L && listener.endTime < currentTime) {
                            listener.handleMessage(null);
                            this.queue.listeners.remove(listener);
                            --i;
                            continue;
                        }
                        if (listener.endTime <= 0L || waitToTime >= currentTime && waitToTime <= listener.endTime) continue;
                        waitToTime = listener.endTime;
                    }
                }
                if (waitToTime == 0L) {
                    waitToTime = currentTime + 5000L;
                }
                this.waitingUntil = waitToTime;
                long waitLength = waitToTime - currentTime;
                if (waitLength > 0L) {
                    try {
                        this.wait(waitLength);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

