/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindQueue;
import com.evermind.server.multicastjms.JMSRequestHandler;
import com.evermind.server.multicastjms.JMSServer;
import com.evermind.server.multicastjms.MessageFilter;
import com.evermind.server.multicastjms.MessageSelector;
import com.evermind.server.multicastjms.ServerMessageListener;
import com.evermind.server.multicastjms.ServerMessageListenerNotifier;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.jms.JMSException;

public class ServerQueue {
    protected EvermindQueue queue;
    protected JMSServer server;
    protected List messages = new ArrayList();
    protected List listeners = new ArrayList();
    protected List messageFilters;
    protected ServerMessageListenerNotifier listenerNotifier;

    public ServerQueue(JMSServer server, EvermindQueue queue) {
        this.server = server;
        this.queue = queue;
    }

    public EvermindQueue getQueue() {
        return this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessages() {
        List list = this.messages;
        synchronized (list) {
            return new ArrayList(this.messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExpiredMessages() {
        long time = System.currentTimeMillis();
        List list = this.messages;
        synchronized (list) {
            for (int i = 0; i < this.messages.size(); ++i) {
                EvermindMessage message = (EvermindMessage)this.messages.get(i);
                if (message.getJMSExpiration() >= time || message.getJMSExpiration() == 0L) continue;
                this.messages.remove(i--);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EvermindMessage message) {
        message.originQueue = this;
        List list = this.messages;
        synchronized (list) {
            int i;
            for (i = 0; i < this.listeners.size(); ++i) {
                ServerMessageListener listener = (ServerMessageListener)this.listeners.get(i);
                if (listener.selector != null && !listener.selector.isSelected(message)) continue;
                this.listeners.remove(i);
                listener.handleMessage(message);
                return;
            }
            if (this.messageFilters != null) {
                for (i = 0; i < this.messageFilters.size(); ++i) {
                    MessageFilter filter = (MessageFilter)this.messageFilters.get(i);
                    if (!filter.process(message)) continue;
                    return;
                }
            }
            this.messages.add(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MessageFilter filter) {
        List list = this.messages;
        synchronized (list) {
            if (this.messageFilters == null) {
                this.messageFilters = new ArrayList();
            }
            this.messageFilters.add(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(MessageFilter filter) {
        List list = this.messages;
        synchronized (list) {
            if (this.messageFilters != null) {
                this.messageFilters.remove(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners(JMSRequestHandler handler) {
        List list = this.messages;
        synchronized (list) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ServerMessageListener listener = (ServerMessageListener)this.listeners.get(i);
                if (listener.handler != handler) continue;
                this.listeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receive(JMSRequestHandler handler, int id, MessageSelector selector, byte acknowledgeMode) throws JMSException {
        List list = this.messages;
        synchronized (list) {
            for (int i = 0; i < this.messages.size(); ++i) {
                EvermindMessage message = (EvermindMessage)this.messages.get(i);
                if (selector != null && !selector.isSelected(message)) continue;
                this.messages.remove(i);
                handler.dispatchMessage(id, message, acknowledgeMode);
                return;
            }
            this.addMessageListener(new ServerMessageListener(handler, id, selector, 0L, acknowledgeMode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveNoWait(JMSRequestHandler handler, int id, MessageSelector selector, byte acknowledgeMode) {
        List list = this.messages;
        synchronized (list) {
            for (int i = 0; i < this.messages.size(); ++i) {
                EvermindMessage message = (EvermindMessage)this.messages.get(i);
                if (selector != null && !selector.isSelected(message)) continue;
                this.messages.remove(i);
                handler.dispatchMessage(id, message, acknowledgeMode);
                return;
            }
            handler.dispatchMessage(id, null, acknowledgeMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receive(JMSRequestHandler handler, int id, MessageSelector selector, long timeout, byte acknowledgeMode) throws JMSException {
        List list = this.messages;
        synchronized (list) {
            for (int i = 0; i < this.messages.size(); ++i) {
                EvermindMessage message = (EvermindMessage)this.messages.get(i);
                if (selector != null && !selector.isSelected(message)) continue;
                this.messages.remove(i);
                handler.dispatchMessage(id, message, acknowledgeMode);
                return;
            }
            this.addMessageListener(new ServerMessageListener(handler, id, selector, timeout, acknowledgeMode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessageListener(ServerMessageListener listener) {
        this.listeners.add(listener);
        if (listener.timeout > 0L) {
            listener.endTime = System.currentTimeMillis() + listener.timeout;
            if (this.listenerNotifier == null) {
                this.listenerNotifier = new ServerMessageListenerNotifier(this);
                this.server.getApplicationServer().getConnectionThreadPool().launch(this.listenerNotifier);
            }
            ServerMessageListenerNotifier serverMessageListenerNotifier = this.listenerNotifier;
            synchronized (serverMessageListenerNotifier) {
                if (this.listenerNotifier.waitingUntil > listener.endTime) {
                    this.listenerNotifier.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EvermindMessage receive(MessageSelector selector, long timeout, byte acknowledgeMode) throws JMSException {
        ServerMessageListener listener;
        Object object = this.messages;
        synchronized (object) {
            for (int i = 0; i < this.messages.size(); ++i) {
                EvermindMessage message = (EvermindMessage)this.messages.get(i);
                if (selector != null && !selector.isSelected(message)) continue;
                this.messages.remove(i);
                return message;
            }
            if (timeout == -1L) {
                return null;
            }
            listener = new ServerMessageListener(selector, acknowledgeMode);
            this.listeners.add(listener);
        }
        object = listener;
        synchronized (object) {
            try {
                if (timeout == 0L) {
                    listener.wait();
                } else {
                    listener.wait(timeout);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            List list = this.messages;
            synchronized (list) {
                this.listeners.remove(listener);
            }
            return listener.response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(InputStream in) throws IOException {
        List list = this.messages;
        synchronized (list) {
            int type;
            DataInputStream dataIn = new DataInputStream(in);
            while ((type = in.read()) > 0) {
                this.messages.add(EvermindMessage.readMessage(type, in, dataIn));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(OutputStream out) throws IOException {
        List list = this.messages;
        synchronized (list) {
            DataOutputStream dataOut = new DataOutputStream(out);
            for (int i = 0; i < this.messages.size(); ++i) {
                EvermindMessage message = (EvermindMessage)this.messages.get(i);
                out.write(message.getTypeID());
                message.write(out, dataOut);
            }
            out.write(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Enumeration getEnumeration(MessageSelector selector) {
        List list = this.messages;
        synchronized (list) {
            if (selector == null) {
                return Collections.enumeration(new ArrayList(this.messages));
            }
            ArrayList<EvermindMessage> response = new ArrayList<EvermindMessage>();
            for (int i = 0; i < this.messages.size(); ++i) {
                EvermindMessage message = (EvermindMessage)this.messages.get(i);
                if (!selector.isSelected(message)) continue;
                response.add(message);
            }
            return Collections.enumeration(response);
        }
    }
}

