/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms.deployment;

import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public abstract class ConnectionFactoryConfig
implements XMLizable {
    protected String location;
    protected String cmtLocation;
    protected String host;
    protected int port = -1;
    protected String username;
    protected String password;
    protected int protocol;
    protected boolean transactional;

    public ConnectionFactoryConfig(Node parent, boolean transactional) {
        this.transactional = transactional;
        this.host = XMLUtils.getNodeAttribute(parent, "host");
        String portString = XMLUtils.getNodeAttribute(parent, "port");
        if (portString != null) {
            try {
                this.port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.username = XMLUtils.getNodeAttribute(parent, "username");
        this.password = XMLUtils.getNodeAttribute(parent, "password");
        this.location = XMLUtils.getNodeAttribute(parent, "location");
        this.cmtLocation = XMLUtils.getNodeAttribute(parent, "cmt-location");
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        if (this.host != null) {
            return this.port < 1 ? 9127 : this.port;
        }
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCMTLocation() {
        return this.cmtLocation;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public abstract void writeXML(PrintWriter var1, String var2) throws IOException;
}

