/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.naming.DelayedBinding;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.rmi.Remote;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import oracle.oc4j.naming.ContextBinding;

public class RMIBinding
extends ContextBinding {
    private static final int DISTRIBUTION_CLUSTER = 1;
    public static final int DISTRIBUTION_REMOTE = 2;
    public static final int DISTRIBUTION_LOCAL_ONLY = 0;
    public static final int DISTRIBUTION_ALL = 3;
    private int m_distributionMode;

    RMIBinding(Object value, int distributionMode) {
        super(value);
        this.m_distributionMode = distributionMode;
    }

    static RMIBinding newBinding(DataInput input) throws IOException {
        int distributionMode = input.readInt();
        return new RMIBinding(input, distributionMode);
    }

    static RMIBinding newBinding(int distributionMode, Object bindingValue) {
        return new RMIBinding(bindingValue, distributionMode);
    }

    private RMIBinding(DataInput input, int distributionMode) throws IOException {
        super(input);
        this.m_distributionMode = distributionMode;
    }

    public Object getValue(Name name, Context context, Hashtable environment) throws NamingException {
        Object rawObject = super.getValue(name, context, environment);
        return rawObject instanceof DelayedBinding ? ((DelayedBinding)rawObject).getInstance() : rawObject;
    }

    int getDistributionMode() {
        return this.m_distributionMode;
    }

    boolean isDistributeToCluster() {
        return RMIBinding.isDistributeToCluster(this.m_distributionMode) && this.isSerializableValue();
    }

    static boolean isDistributeToCluster(int distributionMode) {
        return (distributionMode & 1) != 0;
    }

    boolean isDistributeToRemoteContexts() {
        return RMIBinding.isDistributeToRemoteContexts(this.m_distributionMode) && this.isRemoteableValue();
    }

    boolean isRemoteableValue() {
        if (this.isSerializableValue()) {
            return true;
        }
        Object value = null;
        try {
            value = this.getValue();
            if (value == null) {
                return true;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return value instanceof Remote || value instanceof DelayedBinding;
    }

    static boolean isDistributeToRemoteContexts(int distributionMode) {
        return (distributionMode & 2) != 0;
    }

    public void write(DataOutputStream out) throws IOException, NamingException {
        out.writeInt(this.m_distributionMode);
        super.write(out);
    }

    Object getRemoteableValue() throws NamingException {
        if (this.isSerializableValue()) {
            return this.getSerializable();
        }
        if (!this.isRemoteableValue()) {
            return null;
        }
        Object value = this.getValue();
        if (value instanceof DelayedBinding) {
            value = ((DelayedBinding)value).getInstance();
        }
        return value;
    }
}

