/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.server.rmi.RMIConnectionException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.naming.NamingException;
import oracle.j2ee.rmi.RMIMessages;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.rmi.OracleRemoteException;

class RMICall {
    private static Logger m_logger = TraceLogger.getLogger(RMICall.class);
    int id = -1;
    int queuePos;
    Object response;
    private Throwable exception;
    boolean systemExceptionOccurred;
    boolean responded;
    Class type;
    Long objectId = new Long(-1L);
    private ClassLoader m_classloader;

    RMICall(boolean responded, int id, int queuePos) {
        this.responded = responded;
        this.id = id;
        this.queuePos = queuePos;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        this.m_classloader = contextClassLoader != null ? contextClassLoader : this.getClass().getClassLoader();
    }

    public String toString() {
        return "[RMICall: " + this.id + ", " + this.queuePos + ", " + (this.response == null ? "null" : this.response.getClass().getName()) + ", " + (this.exception == null ? "null" : this.exception.toString()) + "]";
    }

    ClassLoader getClassLoader() {
        return this.m_classloader;
    }

    void recordClientException(Throwable throwable) {
        this.exception = throwable;
        this.systemExceptionOccurred = true;
    }

    void recordServerException(Throwable throwable) {
        this.exception = throwable;
        this.systemExceptionOccurred = true;
    }

    void recordApplicationException(Throwable throwable) {
        this.exception = throwable;
    }

    void throwRecordedException() throws IOException, NamingException {
        if (this.exception == null) {
            return;
        }
        RMIMessages.finerThrowable(this.exception);
        this.warningExceptionOriginatesFromTheRemoteServer();
        if (this.exception instanceof IOException) {
            throw (IOException)this.exception;
        }
        if (this.exception instanceof NamingException) {
            throw (NamingException)this.exception;
        }
        if (this.exception instanceof RuntimeException) {
            throw (RuntimeException)this.exception;
        }
        NamingException e = new NamingException(this.exception.getMessage());
        e.setRootCause(this.exception);
        throw e;
    }

    private void warningExceptionOriginatesFromTheRemoteServer() {
        RMIMessages.EXCEPTION_ORIGINATES_FROM_THE_REMOTE_SERVER(this.exception);
        StackTraceElement[] remoteStackTrace = this.exception.getStackTrace();
        StackTraceElement[] localStackTrace = new RuntimeException().getStackTrace();
        StackTraceElement[] combinedStackTrace = new StackTraceElement[remoteStackTrace.length + localStackTrace.length];
        System.arraycopy(remoteStackTrace, 0, combinedStackTrace, 0, remoteStackTrace.length);
        System.arraycopy(localStackTrace, 0, combinedStackTrace, remoteStackTrace.length, localStackTrace.length);
        this.exception.setStackTrace(combinedStackTrace);
    }

    void throwRecordedException(Method method) throws Throwable {
        if (this.exception == null) {
            return;
        }
        RMIMessages.finerThrowable(this.exception);
        this.warningExceptionOriginatesFromTheRemoteServer();
        if (this.exception instanceof RuntimeException || this.exception instanceof Error || this.exception instanceof RMIConnectionException) {
            throw this.exception;
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes != null) {
            for (int i = 0; i < exceptionTypes.length; ++i) {
                if (!exceptionTypes[i].isAssignableFrom(this.exception.getClass())) continue;
                throw this.exception;
            }
        }
        throw new OracleRemoteException("Invocation error: " + this.exception, this.exception);
    }

    Throwable getException() {
        return this.exception;
    }
}

