/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.server.Server;
import com.evermind.server.SubjectPropagationInterceptor;
import com.evermind.server.cluster.ServerIdentification;
import com.evermind.server.rmi.RMIBinding;
import com.evermind.server.rmi.RMIClientConnection;
import com.evermind.server.rmi.RMIClientContext;
import com.evermind.server.rmi.RMIConnection;
import com.evermind.server.rmi.RMIContext;
import com.evermind.server.rmi.RMIInterceptor;
import com.evermind.server.rmi.RMIInterceptorManagerImpl;
import com.evermind.server.rmi.RMILocation;
import com.evermind.util.RMIProperties;
import com.evermind.util.ThreadPool;
import java.io.IOException;
import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import oracle.j2ee.naming.SecurityContextHelper;
import oracle.j2ee.rmi.RMIMessages;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.rmi.ClientRmiTransport;
import oracle.oc4j.rmi.OracleRemoteException;
import oracle.oc4j.rmi.interceptors.IdentityPropagationInterceptor;
import oracle.oc4j.security.OC4JSecurity;

public class RMIClient
extends Server {
    public static final int DEFAULT_PORT = 23791;
    public static final int DEFAULT_SSL_PORT = 23943;
    static RMIClient instance;
    private static final Object localThreadPoolLockObject;
    private static ThreadPool localThreadPool;
    private List remoteServerConnections = new ArrayList();
    RMIInterceptorManagerImpl interceptorManager = new RMIInterceptorManagerImpl();
    private static Logger m_logger;
    private Map contexts = new RMIClientContextMap(RMIProperties.getRmiClientcontextCache());
    private final SecurityContextHelper m_securityContextHelper;
    private GetMatchingConnectionsStrategy matchingConnectionsStrategyImpl = null;
    protected static final RMIInterceptor[] NO_INTERCEPTORS;
    protected static final String RMI_CLIENT_THREADGROUP_NAME = "RMIClientConnectionThreadGroup";

    public RMIClient() {
        this(RMIClient.getClientInterceptors(), SecurityContextHelper.getInstance());
    }

    protected RMIClient(RMIInterceptor[] interceptors) {
        this(interceptors, SecurityContextHelper.getInstance());
    }

    RMIClient(SecurityContextHelper securityContextHelper) {
        this(RMIClient.getClientInterceptors(), securityContextHelper);
    }

    private RMIClient(RMIInterceptor[] interceptors, SecurityContextHelper securityContextHelper) {
        for (int i = 0; i < interceptors.length; ++i) {
            this.interceptorManager.registerInterceptor(interceptors[i]);
        }
        this.m_securityContextHelper = securityContextHelper;
    }

    protected static RMIInterceptor[] getClientInterceptors() {
        return new RMIInterceptor[]{new IdentityPropagationInterceptor(), new SubjectPropagationInterceptor()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeContext(RMIContext context, String reason) {
        List list = this.remoteServerConnections;
        synchronized (list) {
            ArrayList<RMIClientConnection> connections = new ArrayList<RMIClientConnection>();
            Iterator iterator = this.remoteServerConnections.iterator();
            while (iterator.hasNext()) {
                RMIClientConnection connection = (RMIClientConnection)iterator.next();
                if (!connection.handlesContext(context)) continue;
                connections.add(connection);
                iterator.remove();
            }
            Iterator it = connections.iterator();
            while (it.hasNext()) {
                ((RMIClientConnection)it.next()).disconnect(reason, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(RMIClientContext clientContext) {
        try {
            Hashtable environment = clientContext.getEnvironment();
            ContextKey key = new ContextKey(environment);
            Map map = this.contexts;
            synchronized (map) {
                Object currentContext = this.contexts.remove(key);
                if (currentContext != null && currentContext != clientContext) {
                    this.contexts.put(key, currentContext);
                }
            }
            this.removeContextAssociation(clientContext);
        }
        catch (NamingException namingException) {
            m_logger.log(Level.FINE, "removeContext: Error while trying to get context environment", namingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContextAssociation(RMIClientContext clientContext) {
        List list = this.remoteServerConnections;
        synchronized (list) {
            Iterator it = new ArrayList(this.remoteServerConnections).iterator();
            while (it.hasNext()) {
                ((RMIClientConnection)it.next()).removeAssociatedContext(clientContext);
            }
        }
    }

    final void initializeInterceptors() {
        if (instance == null) {
            this.registerClientInterceptors();
        } else {
            this.interceptorManager.registerInterceptors(this.getInstanceInterceptors());
        }
    }

    private List getInstanceInterceptors() {
        return instance.getInterceptorManager().getRegisteredInterceptors();
    }

    private void registerClientInterceptors() {
        this.interceptorManager.registerInterceptor(new SubjectPropagationInterceptor());
    }

    public RMIInterceptorManagerImpl getInterceptorManager() {
        return this.interceptorManager;
    }

    public void destroy(String reason) {
        this.disconnectRMIConnections(this.remoteServerConnections, reason);
        super.destroy(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void disconnectRMIConnections(List connectionsList, String reason) {
        List list = connectionsList;
        synchronized (list) {
            Iterator connections = new ArrayList(connectionsList).iterator();
            while (connections.hasNext()) {
                ((RMIConnection)connections.next()).disconnect(reason, false);
            }
            connectionsList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(RMIClientConnection clientConnection) {
        List list = this.remoteServerConnections;
        synchronized (list) {
            this.remoteServerConnections.remove(clientConnection);
        }
    }

    protected void bindInRemoteContexts(RMIContext context, String name, Object value) throws NamingException {
        Iterator iterator = this.getMatchingConnections(context).iterator();
        while (iterator.hasNext()) {
            RMIClientConnection connection = (RMIClientConnection)iterator.next();
            try {
                connection.bind(context, name, value);
            }
            catch (NamingException e) {
                RMIMessages.infoRemoteBindFailed(name, value, e);
                throw e;
            }
            catch (Throwable e) {
                RMIMessages.infoRemoteBindFailed(name, value, e);
                NamingException namingException = new NamingException("Unable to bind");
                namingException.setRootCause(e);
                throw namingException;
            }
        }
    }

    List getMatchingConnections(RMIContext context) {
        return this.getMatchingConnectionsStrategy().getMatchingConnections(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List buildListOfMatchingConnections(RMIContext context, String userName, String passWord) {
        LinkedList matches;
        List list = this.remoteServerConnections;
        synchronized (list) {
            matches = new LinkedList(this.remoteServerConnections);
        }
        Iterator each = matches.iterator();
        while (each.hasNext()) {
            RMIClientConnection connection = (RMIClientConnection)each.next();
            if (connection.handlesContext(context) && connection.hasCredentials(userName, passWord)) continue;
            each.remove();
        }
        return matches;
    }

    protected void unbindFromRemoteContexts(RMIContext context, String name) throws IOException, NamingException {
        Iterator iterator = this.getMatchingConnections(context).iterator();
        while (iterator.hasNext()) {
            RMIClientConnection connection = (RMIClientConnection)iterator.next();
            connection.unbind(context, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shuffleConnections() {
        if (this.remoteServerConnections != null) {
            List list = this.remoteServerConnections;
            synchronized (list) {
                if (this.remoteServerConnections.size() > 1) {
                    Collections.shuffle(this.remoteServerConnections);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RMIClientConnection addNewConnection(ClientRmiTransport transport, String username, String password, RMIClientContext context) {
        if (context == null) {
            throw new IllegalArgumentException("domain was null");
        }
        RMIClientConnection connection = new RMIClientConnection(this, transport, username, password, context);
        List list = this.remoteServerConnections;
        synchronized (list) {
            this.remoteServerConnections.add(connection);
            Collections.shuffle(this.remoteServerConnections);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RMIClientConnection getConnection(ClientRmiTransport rmiTransport, String username, String password, RMIClientContext context) {
        List list = this.remoteServerConnections;
        synchronized (list) {
            Iterator iterator = this.remoteServerConnections.iterator();
            while (iterator.hasNext()) {
                RMIClientConnection connection = (RMIClientConnection)iterator.next();
                if (!connection.isMatchingConnection(rmiTransport, username, password, context) || !connection.addAssociatedContext(context)) continue;
                return connection;
            }
            return this.addNewConnection(rmiTransport, username, password, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lookup(RMIContext context, String name) throws RemoteException, NamingException {
        if (context.needToShuffle()) {
            m_logger.log(Level.FINE, "Lookup: Shuffling connections: ", name);
            this.shuffleConnections();
        }
        m_logger.log(Level.FINER, "Looking up ''{0}''", name);
        Iterator iterator = this.getMatchingConnections(context).iterator();
        Exception error = null;
        while (iterator.hasNext()) {
            RMIClientConnection connection = (RMIClientConnection)iterator.next();
            try {
                Object object = connection.lookup(context, name);
                if (object == null) continue;
                return object;
            }
            catch (Throwable t) {
                m_logger.log(Level.FINE, "Failed during lookup", t);
                if (t instanceof RemoteException) {
                    error = (RemoteException)t;
                    continue;
                }
                if (t instanceof SecurityException) {
                    error = (SecurityException)t;
                    continue;
                }
                if (t instanceof IOException) {
                    CommunicationException e = new CommunicationException(RMIClient.nonNullMessage(null, t));
                    ((Throwable)e).initCause(t);
                    error = e;
                    continue;
                }
                if (t instanceof AuthenticationException) {
                    List list = this.remoteServerConnections;
                    synchronized (list) {
                        this.remoteServerConnections.remove(connection);
                    }
                    this.removeBadConnection(iterator);
                    error = (AuthenticationException)t;
                    continue;
                }
                error = new OracleRemoteException("Lookup error: " + t, t);
            }
        }
        if (error != null) {
            if (error instanceof RemoteException) {
                throw (RemoteException)error;
            }
            if (error instanceof SecurityException) {
                throw (SecurityException)error;
            }
            if (error instanceof CommunicationException) {
                throw (CommunicationException)error;
            }
            if (error instanceof NamingException) {
                throw new OracleRemoteException("Lookup error: " + error, error);
            }
            RMIMessages.finerThrowable(error);
        }
        return null;
    }

    static String nonNullMessage(StringBuffer buf, Throwable t) {
        if (null != t.getMessage()) {
            if (null != buf) {
                buf.append(t.getMessage());
            }
            return t.getMessage();
        }
        if (null == buf) {
            buf = new StringBuffer("<no message>");
        }
        StackTraceElement[] ste = t.getStackTrace();
        for (int i = 0; i < ste.length; ++i) {
            buf.append(ste[i].toString()).append("\n");
        }
        Throwable cause = t.getCause();
        if (null != cause && cause != t) {
            buf.append("caused by: ");
            RMIClient.nonNullMessage(buf, cause);
        }
        return buf.toString();
    }

    protected void removeBadConnection(Iterator iterator) {
        iterator.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticate(RMIClientContext context, RMILocation location) throws NamingException, IOException {
        List connections = this.getMatchingConnections(context);
        Iterator iterator = connections.iterator();
        try {
            boolean newConnection = false;
            while (iterator.hasNext()) {
                RMIClientConnection connection = (RMIClientConnection)iterator.next();
                try {
                    if (!(newConnection |= connection.connect())) continue;
                    break;
                }
                catch (Exception e2) {
                    this.handleAuthenticateException(e2, connection, iterator.hasNext());
                }
            }
            if (!newConnection) {
                this.authenticateOnNewConnection(context, location);
            }
        }
        catch (AuthenticationException e) {
            m_logger.log(Level.FINE, "Authentication failed. context {0} location {1} ", new Object[]{context, location});
            List e2 = this.remoteServerConnections;
            synchronized (e2) {
                iterator = connections.iterator();
                while (iterator.hasNext()) {
                    RMIClientConnection conn = (RMIClientConnection)iterator.next();
                    m_logger.log(Level.FINE, "Remove failed connection ", conn);
                    this.remoteServerConnections.remove(conn);
                }
            }
            iterator = connections.iterator();
            while (iterator.hasNext()) {
                RMIClientConnection conn = (RMIClientConnection)iterator.next();
                m_logger.log(Level.FINE, "Disconnect failed connection ", conn);
                conn.disconnect(e.getMessage(), false);
            }
            throw e;
        }
    }

    void authenticateOnNewConnection(RMIClientContext context, RMILocation location) throws NamingException, IOException {
        RMIClientConnection connection = new RMIClientConnection(this, location.getTransport(), context.getUserName(), context.getPassword(), context, false);
        if (!connection.connect()) {
            throw new IOException("unable to connect to location " + location);
        }
        connection.disconnect("finished authentication", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAuthenticateException(Exception e, RMIClientConnection connection, boolean hasMoreToTry) throws NamingException, IOException {
        m_logger.log(Level.FINER, "authenticating failed on connection: ", connection);
        List list = this.remoteServerConnections;
        synchronized (list) {
            this.remoteServerConnections.remove(connection);
        }
        if (!hasMoreToTry) {
            this.remoteServerConnections.remove(connection);
            m_logger.log(Level.FINER, "no more connections to try!");
            if (e instanceof NamingException) {
                throw (NamingException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    Map list(RMIContext context, String name, boolean bindings) throws IOException, NamingException {
        m_logger.log(Level.FINER, "Listing ''{0}''", name);
        if (!this.remoteServerConnections.isEmpty()) {
            RMIClientConnection connection = (RMIClientConnection)this.getMatchingConnections(context).iterator().next();
            return connection.list(context, name, bindings);
        }
        throw new NotContextException("No such context");
    }

    boolean isClientInstance() {
        return true;
    }

    ThreadPool getThreadPool() {
        return RMIClient.getLocalThreadPool();
    }

    ThreadPool getConnectionThreadPool() {
        return RMIClient.getLocalThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumRemoteServerConnections() {
        List list = this.remoteServerConnections;
        synchronized (list) {
            return this.remoteServerConnections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ThreadPool getLocalThreadPool() {
        OC4JSecurity.assertIsSafe();
        Object object = localThreadPoolLockObject;
        synchronized (object) {
            if (localThreadPool == null) {
                localThreadPool = new ThreadPool(new ThreadGroup(RMIClient.getRootThreadGroup(), RMI_CLIENT_THREADGROUP_NAME), true);
                localThreadPool.init();
            }
            return localThreadPool;
        }
    }

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup current = Thread.currentThread().getThreadGroup();
        ThreadGroup parent = current.getParent();
        while (parent != null) {
            current = parent;
            parent = current.getParent();
        }
        return current;
    }

    private GetMatchingConnectionsStrategy getMatchingConnectionsStrategy() {
        if (this.matchingConnectionsStrategyImpl == null) {
            this.matchingConnectionsStrategyImpl = this.m_securityContextHelper.isAssociateUserToThreadEnabled() ? new AssociateUserToThreadMatchingConnectionsStrategy() : new DefaultGetMatchingConnectionsStrategy();
        }
        return this.matchingConnectionsStrategyImpl;
    }

    ServerIdentification[] getServers(String host, int port, boolean isPortSsl, String application) throws IOException {
        return RMIClientConnection.getServers(host, port, isPortSsl, application);
    }

    boolean isListeningToPort(int port) {
        return false;
    }

    boolean isMatchingApplication(String targetApplicationName) {
        return false;
    }

    static synchronized RMIClient getInstance() {
        OC4JSecurity.assertIsSafe();
        if (instance == null) {
            instance = new RMIClient();
        }
        return instance;
    }

    protected boolean isUndefinedDomain(String domain) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized RMIClientContext getContext(Map environment) throws NamingException {
        String domain = RMIClient.getDomain(environment);
        ContextKey key = new ContextKey(environment);
        Map map = this.contexts;
        synchronized (map) {
            RMIClientContext context = (RMIClientContext)this.contexts.get(key);
            if (context != null) {
                try {
                    if (((Object)environment).equals(context.environment) && context.useIfActiveContext()) {
                        context.checkServer();
                    } else {
                        context = null;
                    }
                }
                catch (NamingException e) {
                    context = null;
                    m_logger.log(Level.FINER, "server connections previously closed; creating new context");
                }
            }
            if (null == context) {
                context = this.createContext(domain, environment);
                this.contexts.put(key, context);
            }
            return context;
        }
    }

    protected synchronized boolean isContextSupported(RMIClientContext context) {
        return this.contexts.containsValue(context);
    }

    RMIClientContext createRandomizeOnLookupContext(Map environment) throws NamingException {
        return new RandomizeOnLookupClientContext(this, RMIClient.getDomain(environment), environment);
    }

    RMIClientContext createLocalClientContext(Map environment) throws NamingException {
        throw new NamingException("Local provider URLs are not supported from a remote client");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RMIClientContext createDedicatedContext(Map environment) throws NamingException {
        List list = this.remoteServerConnections;
        synchronized (list) {
            Collections.shuffle(this.remoteServerConnections);
        }
        return this.createContext(RMIClient.getDomain(environment), environment);
    }

    protected RMIClientContext createContext(String domain, Map environment) {
        return new RMIClientContext(this, domain, environment);
    }

    void bind(RMIContext context, String name, RMIBinding binding) throws RemoteException, AlreadyBoundException, NamingException {
        if (this.lookup(context, name) != null) {
            throw new AlreadyBoundException("Error binding object at '" + name + "', object already present, use rebind() instead");
        }
        this.rebind(context, name, binding);
    }

    void rebind(RMIContext context, String name, RMIBinding binding) throws RemoteException, NamingException {
        if (binding.isDistributeToRemoteContexts()) {
            this.bindInRemoteContexts(context, name, binding.getRemoteableValue());
        } else if (this.isClientInstance()) {
            throw new NamingException("Clients may only bind values that can be sent to the server.");
        }
    }

    void unbind(RMIContext context, String name, int distribution) throws IOException, NamingException {
        if (RMIBinding.isDistributeToRemoteContexts(distribution)) {
            this.unbindFromRemoteContexts(context, name);
        }
    }

    void rename(RMIContext rmiContext, String oldname, String newname, RMIBinding binding, boolean remoteOnly) throws IOException, NamingException {
        if (binding.isDistributeToRemoteContexts()) {
            this.bindInRemoteContexts(rmiContext, newname, binding.getRemoteableValue());
            this.unbindFromRemoteContexts(rmiContext, oldname);
        }
    }

    static String getDomain(Map map) throws NamingException {
        RMILocation[] locations = RMIClient.getLocations((String)map.get("java.naming.provider.url"));
        String domain = locations[0].getApplication();
        for (int i = 0; i < locations.length; ++i) {
            RMILocation location = locations[i];
            if (RMIClient.equals(domain, location.getApplication())) continue;
            throw new NamingException("Multiple conflicting domains specified");
        }
        return domain == null ? "" : domain;
    }

    private static boolean equals(Object object1, Object object2) {
        return object1 == null ? object2 == null : object1.equals(object2);
    }

    static RMILocation[] getLocations(String comboURLString) throws NamingException {
        OC4JSecurity.assertIsSafe();
        StringTokenizer tokenizer = new StringTokenizer(comboURLString, ",");
        ArrayList<RMILocation> locations = new ArrayList<RMILocation>();
        while (tokenizer.hasMoreTokens()) {
            locations.add(RMILocation.createRMILocation(tokenizer.nextToken()));
        }
        return locations.toArray(new RMILocation[locations.size()]);
    }

    static {
        localThreadPoolLockObject = new Object();
        localThreadPool = null;
        m_logger = TraceLogger.getLogger(RMIClient.class);
        NO_INTERCEPTORS = new RMIInterceptor[0];
    }

    private class RMIClientContextMap
    extends LinkedHashMap {
        private int m_maxSize;

        RMIClientContextMap(int maxSize) {
            this.m_maxSize = maxSize;
        }

        public boolean removeEldestEntry(Map.Entry entry) {
            return this.m_maxSize > 0 && this.size() > this.m_maxSize;
        }
    }

    private class AssociateUserToThreadMatchingConnectionsStrategy
    extends DefaultGetMatchingConnectionsStrategy {
        private AssociateUserToThreadMatchingConnectionsStrategy() {
        }

        public List getMatchingConnections(RMIContext context) {
            String userName = RMIClient.this.m_securityContextHelper.getCurrentPrincipal(context);
            String passWord = RMIClient.this.m_securityContextHelper.getCurrentCredential(context);
            List listOfConnections = super.getMatchingConnections(context);
            if (listOfConnections.size() > 0) {
                return listOfConnections;
            }
            try {
                if (context instanceof RMIClientContext) {
                    RMIClientContext clientContext = (RMIClientContext)context;
                    clientContext.establishRemoteConnections();
                    return RMIClient.this.buildListOfMatchingConnections(context, userName, passWord);
                }
            }
            catch (NamingException namingException) {
                return Collections.EMPTY_LIST;
            }
            return Collections.EMPTY_LIST;
        }
    }

    private class DefaultGetMatchingConnectionsStrategy
    implements GetMatchingConnectionsStrategy {
        private DefaultGetMatchingConnectionsStrategy() {
        }

        public List getMatchingConnections(RMIContext clientContext) {
            String userName = RMIClient.this.m_securityContextHelper.getCurrentPrincipal(clientContext);
            String passWord = RMIClient.this.m_securityContextHelper.getCurrentCredential(clientContext);
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Requiring username: {0} domain: {1}", new String[]{userName, clientContext.getName()});
            }
            return RMIClient.this.buildListOfMatchingConnections(clientContext, userName, passWord);
        }
    }

    static interface GetMatchingConnectionsStrategy {
        public List getMatchingConnections(RMIContext var1);
    }

    private static class ContextKey {
        private String m_url;
        private String m_user;

        ContextKey(Map environment) {
            this.m_url = (String)environment.get("java.naming.provider.url");
            this.m_user = (String)environment.get("java.naming.security.principal");
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass()) && this.equals((ContextKey)obj);
        }

        private boolean equals(ContextKey other) {
            return this.equals(this.m_url, other.m_url) && this.equals(this.m_user, other.m_user);
        }

        private boolean equals(Object obj1, Object obj2) {
            return obj1 == null ? obj2 == null : obj1.equals(obj2);
        }

        public int hashCode() {
            return this.hashCode(this.m_url) + this.hashCode(this.m_user);
        }

        private int hashCode(Object obj) {
            return obj == null ? 0 : obj.hashCode();
        }
    }

    class RandomizeOnLookupClientContext
    extends RMIClientContext {
        public RandomizeOnLookupClientContext(RMIClient client, String domain, Map environment) {
            super(client, domain, environment);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lookup(String name) throws NamingException {
            List list = RMIClient.this.remoteServerConnections;
            synchronized (list) {
                Collections.shuffle(RMIClient.this.remoteServerConnections);
            }
            return super.lookup(name);
        }
    }
}

