/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.server.rmi.RMIClient;
import com.evermind.server.rmi.RMIClientContext;
import com.evermind.server.rmi.RMILocation;
import com.evermind.util.RMIProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.j2ee.naming.SecurityContextHelper;
import oracle.oc4j.security.OC4JSSLSocketFactory;
import oracle.oc4j.security.SSLUtilValues;
import oracle.oc4j.security.SSLUtils;

public class RMIInitialContext {
    public static final String LOAD_BALANCE = "oracle.j2ee.rmi.loadBalance";
    public static final String IMMEDIATE_AUTH = "oracle.j2ee.rmi.immediateAuth";
    public static final String CACHING = "oracle.j2ee.naming.caching";
    static final String SSL_RMI_TAG = "rmi";
    private Hashtable environment;
    private final SecurityContextHelper m_securityContextHelper;

    public RMIInitialContext(Hashtable environment) {
        this(environment, SecurityContextHelper.getInstance());
    }

    RMIInitialContext(Hashtable environment, SecurityContextHelper securityContextHelper) {
        this.environment = environment;
        this.m_securityContextHelper = securityContextHelper;
    }

    public Context get() throws NamingException {
        RMIClient rmiClient = RMIClient.getInstance();
        RMIClientContext context = RMIInitialContext.isRandomizePerContext(this.environment) ? rmiClient.createDedicatedContext(this.environment) : (RMIInitialContext.isRandomizeOnLookup(this.environment) ? rmiClient.createRandomizeOnLookupContext(this.environment) : (RMIInitialContext.isLocalClientRequest(this.environment) ? rmiClient.createLocalClientContext(this.environment) : rmiClient.getContext(this.environment)));
        context.environment = new HashMap(this.environment);
        if (context.getUserName() != null && context.getPassword() != null) {
            this.m_securityContextHelper.associateUserToThread(this.getUserName(), this.getPassword());
        }
        if (this.isSecureProtocol()) {
            this.establishSSLConfig();
        }
        context.establishRemoteConnections();
        return context;
    }

    boolean isSecureProtocol() {
        String providerUrl = this.getProviderURL();
        if (null == providerUrl) {
            return false;
        }
        try {
            return RMILocation.createRMILocation(providerUrl).isSecureProtocol();
        }
        catch (NamingException e) {
            return true;
        }
    }

    void establishSSLConfig() throws NamingException {
        SSLUtils.Values defaultValues = null;
        try {
            defaultValues = SSLUtils.getDefaultValues(SSL_RMI_TAG, false);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            SSLUtils.Values values = SSLUtils.getValues(null, this.environment, null, SSL_RMI_TAG, (SSLUtilValues)defaultValues);
            if (values.isSpecified()) {
                OC4JSSLSocketFactory.registerSSLUtilValues(SSL_RMI_TAG, values);
                return;
            }
            defaultValues = SSLUtils.getDefaultValues(SSL_RMI_TAG, true);
            values = SSLUtils.getValues(null, this.environment, null, SSL_RMI_TAG, (SSLUtilValues)defaultValues);
            if (values.isSpecified()) {
                OC4JSSLSocketFactory.registerSSLUtilValues(SSL_RMI_TAG, values);
            }
        }
        catch (IOException e) {
            throw new NamingException(e.getMessage());
        }
    }

    private String getPassword() {
        return (String)this.environment.get("java.naming.security.credentials");
    }

    private String getUserName() {
        return (String)this.environment.get("java.naming.security.principal");
    }

    private String getProviderURL() {
        return (String)this.environment.get("java.naming.provider.url");
    }

    public static boolean isJ2EEContextCachingEnabled(Hashtable environment) {
        if (environment == null) {
            return true;
        }
        return RMIInitialContext.isEnabled(RMIInitialContext.getEnvironmentProperty(environment, CACHING), !RMIInitialContext.isRandomizeOnLookup(environment));
    }

    private static boolean isEnabled(String propertyString, boolean defaultValue) {
        if (propertyString == null) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(propertyString) || "on".equalsIgnoreCase(propertyString) || "enabled".equalsIgnoreCase(propertyString);
    }

    private static boolean isRandomizePerContext(Hashtable environment) {
        if (environment == null) {
            return false;
        }
        return "context".equalsIgnoreCase(RMIInitialContext.getEnvironmentProperty(environment, LOAD_BALANCE));
    }

    private static boolean isRandomizeOnLookup(Hashtable environment) {
        if (environment == null) {
            return false;
        }
        String setting = RMIInitialContext.getEnvironmentProperty(environment, LOAD_BALANCE);
        return setting == null ? RMIProperties.getLoadBalanceOnLookup() : "lookup".equalsIgnoreCase(setting);
    }

    private static boolean isLocalClientRequest(Hashtable environment) {
        if (environment == null) {
            return false;
        }
        String providerUrl = (String)environment.get("java.naming.provider.url");
        return providerUrl == null ? false : providerUrl.startsWith("local://");
    }

    static boolean isImmediateAuth(Hashtable environment) {
        if (environment == null) {
            return false;
        }
        return RMIInitialContext.isEnabled(RMIInitialContext.getEnvironmentProperty(environment, IMMEDIATE_AUTH), false);
    }

    private static String getEnvironmentProperty(Hashtable environment, String propertyName) {
        Object propertyObject = environment.get(propertyName);
        return propertyObject == null ? null : propertyObject.toString().trim();
    }
}

