/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.server.rmi.RMIInterceptor;
import com.evermind.server.rmi.RMIInterceptorContext;
import com.evermind.server.rmi.RMIInterceptorException;
import com.evermind.server.rmi.RMIInterceptorManager;
import com.evermind.server.rmi.RMIOutputStream;
import com.evermind.util.LongHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;

class RMIInterceptorManagerImpl
implements RMIInterceptorManager {
    static final int MAX_INTERCEPTOR_DATA_BYTES = 0x500000;
    private ArrayList m_registrations = new ArrayList();
    static Logger m_logger = TraceLogger.getLogger(RMIInterceptorManagerImpl.class);

    RMIInterceptorManagerImpl() {
    }

    void reset() {
        this.m_registrations.clear();
    }

    void registerInterceptor(RMIInterceptor interceptor) {
        this.m_registrations.add(interceptor);
    }

    void registerInterceptors(Collection interceptors) {
        Iterator iter = interceptors.iterator();
        while (iter.hasNext()) {
            this.registerInterceptor((RMIInterceptor)iter.next());
        }
    }

    public void fireSendRequestInterceptor(LongHashMap clientInterceptors, ObjectOutputStream out, int command, int callId) throws RMIInterceptorException {
        try {
            ArrayList interestedInterceptors = new ArrayList();
            for (int i = 0; i < this.m_registrations.size(); ++i) {
                RMIInterceptor interceptor = (RMIInterceptor)this.m_registrations.get(i);
                if (!interceptor.isInterested(command)) continue;
                this.doSendRequest(new InterceptorInfo(interceptor), interestedInterceptors, out);
            }
            clientInterceptors.put(callId, (Object)interestedInterceptors);
            this.writeNoMoreContextsMarker(out);
        }
        catch (RMIInterceptorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RMIInterceptorException("Exception occurred invoking send interceptor", e);
        }
    }

    private void doSendRequest(InterceptorInfo interceptor, List interceptors, ObjectOutputStream out) throws Exception {
        try {
            Object context = interceptor.getInterceptor().processSendRequest();
            interceptors.add(interceptor);
            if (context != null) {
                out.writeBoolean(true);
                out.writeInt(interceptor.getIdentifier());
                out.writeObject(context);
            }
        }
        catch (Exception e) {
            this.callReceiveException(e, interceptors);
        }
    }

    public void fireReceiveReplyInterceptor(LongHashMap clientInterceptors, int callId) throws RMIInterceptorException {
        try {
            ArrayList interceptors = (ArrayList)clientInterceptors.remove(callId);
            if (interceptors == null) {
                return;
            }
            for (int i = interceptors.size() - 1; i >= 0; --i) {
                InterceptorInfo interceptor = (InterceptorInfo)interceptors.remove(i);
                this.doReceiveReply(interceptor, interceptors);
            }
        }
        catch (Exception e) {
            throw new RMIInterceptorException("Exception occurred making receiveReply notifications", e);
        }
    }

    public void fireReceiveRequestInterceptor(LongHashMap serverInterceptors, int callId, RMIInterceptorContext metaContext) throws RMIInterceptorException {
        try {
            ArrayList interceptors = (ArrayList)serverInterceptors.get(callId);
            if (interceptors == null) {
                return;
            }
            for (int i = 0; i < interceptors.size(); ++i) {
                InterceptorInfo interceptor = (InterceptorInfo)interceptors.get(i);
                this.doReceiveRequest(interceptor, i, interceptors, metaContext);
            }
        }
        catch (Exception e) {
            throw new RMIInterceptorException("Exception occurred making interceptor receive notifications", e);
        }
    }

    public void fireSendReplyInterceptor(LongHashMap serverInterceptors, RMIOutputStream out, int callId) throws IOException {
        try {
            this.writeNormalResponseMarker(out);
            List interestedInterceptors = (List)serverInterceptors.remove(callId);
            if (interestedInterceptors != null) {
                int i = interestedInterceptors.size() - 1;
                while (i >= 0) {
                    InterceptorInfo interceptor;
                    if (!(interceptor = (InterceptorInfo)interestedInterceptors.get(i--)).didReceiveNotificationComplete()) continue;
                    try {
                        Object context = interceptor.getInterceptor().processSendReply();
                        interceptor.setContext(context);
                    }
                    catch (Exception e) {
                        this.callSendException(e, i, interestedInterceptors);
                    }
                }
                this.writeInterceptorContexts(out, interestedInterceptors);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ioe = new IOException("Exception occurred invoking send reply interceptor");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            this.writeNoMoreContextsMarker(out);
        }
    }

    private void writeInterceptorContexts(RMIOutputStream out, List interestedInterceptors) throws IOException {
        Iterator each = interestedInterceptors.iterator();
        while (each.hasNext()) {
            InterceptorInfo info = (InterceptorInfo)each.next();
            if (info.getContext() == null) continue;
            out.writeBoolean(true);
            out.writeInt(info.getIdentifier());
            out.writeObject(info.getContext());
        }
    }

    public void fireReadRequestContextInterceptor(LongHashMap serverInterceptors, ObjectInputStream in, int command, int callId) throws IOException {
        List interceptors = this.getInterestedInterceptors(command);
        this.readInterceptorContexts(in, interceptors);
        serverInterceptors.put(callId, (Object)interceptors);
    }

    private void readInterceptorContexts(ObjectInputStream in, List interceptors) throws IOException {
        int identifier;
        while ((identifier = this.getNextContextId(in)) != -1) {
            InterceptorInfo info;
            Object context = null;
            try {
                context = in.readObject();
            }
            catch (ClassNotFoundException e) {
                m_logger.log(Level.SEVERE, "unable to recover remote context: {0}", e.getMessage());
            }
            if ((info = this.getInterceptorInfo(interceptors, identifier)) == null) continue;
            info.setContext(context);
        }
    }

    private List getInterestedInterceptors(int command) {
        ArrayList<InterceptorInfo> interceptors = new ArrayList<InterceptorInfo>();
        Iterator each = this.m_registrations.iterator();
        while (each.hasNext()) {
            RMIInterceptor interceptor = (RMIInterceptor)each.next();
            if (!interceptor.isInterested(command)) continue;
            interceptors.add(new InterceptorInfo(interceptor));
        }
        return interceptors;
    }

    private InterceptorInfo getInterceptorInfo(List interceptors, int identifier) {
        if (interceptors == null) {
            return null;
        }
        Iterator each = interceptors.iterator();
        while (each.hasNext()) {
            InterceptorInfo info = (InterceptorInfo)each.next();
            if (identifier != info.getIdentifier()) continue;
            return info;
        }
        return null;
    }

    public boolean fireReadReplyInterceptor(LongHashMap clientInterceptors, ObjectInputStream in, int callId) throws IOException {
        if (!in.readBoolean()) {
            return true;
        }
        try {
            ArrayList interceptors = (ArrayList)clientInterceptors.get(callId);
            this.readInterceptorContexts(in, interceptors);
            return false;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ioe = new IOException("Exception occurred reading returned contexts");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void fireSendExceptionInterceptor(LongHashMap serverInterceptors, ObjectOutputStream out, int callId, Throwable exception) throws IOException {
        try {
            this.writeExceptionResponseMarker(out);
            List interceptors = (List)serverInterceptors.get(callId);
            if (interceptors == null) {
                return;
            }
            for (int i = interceptors.size() - 1; i >= 0; --i) {
                InterceptorInfo interceptor = (InterceptorInfo)interceptors.remove(i);
                if (!interceptor.didReceiveNotificationComplete()) continue;
                try {
                    interceptor.getInterceptor().sendException(exception);
                    continue;
                }
                catch (Exception e) {
                    this.callSendException(e, interceptors.size(), interceptors);
                }
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("Exception occurred invoking sendException on  interceptor");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void fireReceiveExceptionInterceptor(LongHashMap clientInterceptors, int id, Throwable exception) throws IOException {
        try {
            ArrayList interceptors = (ArrayList)clientInterceptors.get(id);
            if (interceptors == null) {
                return;
            }
            for (int i = interceptors.size() - 1; i >= 0; --i) {
                InterceptorInfo interceptor = (InterceptorInfo)interceptors.remove(i);
                try {
                    interceptor.getInterceptor().receiveException(exception);
                    continue;
                }
                catch (Exception e) {
                    this.callReceiveException(e, interceptors);
                }
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("Exception occurred making receiveException notifications");
            ioe.initCause(e);
            throw ioe;
        }
    }

    void receiveException(int callId, Throwable exception) throws Exception {
    }

    List getRegisteredInterceptors() {
        return this.m_registrations;
    }

    private void doReceiveRequest(InterceptorInfo interceptor, int i, ArrayList interceptors, RMIInterceptorContext metaContext) throws Exception {
        try {
            interceptor.getInterceptor().processReceiveRequest(interceptor.getContext(), metaContext);
            interceptor.markReceiveNotificationComplete();
        }
        catch (Exception e) {
            this.callSendException(e, i - 1, interceptors);
        }
    }

    private void doReceiveReply(InterceptorInfo interceptor, ArrayList interceptors) throws Exception {
        try {
            interceptor.getInterceptor().processReceiveReply(interceptor.getContext());
        }
        catch (Exception e) {
            this.callReceiveException(e, interceptors);
        }
    }

    private int getNextContextId(ObjectInputStream in) throws IOException {
        return in.readBoolean() ? in.readInt() : -1;
    }

    private void writeNormalResponseMarker(ObjectOutputStream out) throws IOException {
        out.writeBoolean(true);
    }

    private void writeExceptionResponseMarker(ObjectOutputStream out) throws IOException {
        out.writeBoolean(false);
    }

    private void writeNoMoreContextsMarker(ObjectOutputStream out) throws IOException {
        out.writeBoolean(false);
    }

    private void callReceiveException(Exception e, List interceptors) throws Exception {
        for (int i = interceptors.size() - 1; i >= 0; --i) {
            try {
                ((InterceptorInfo)interceptors.get(i)).getInterceptor().receiveException(e);
                continue;
            }
            catch (Exception e2) {
                e = e2;
            }
        }
        throw e;
    }

    private void callSendException(Exception e, int listIndex, List interceptors) throws Exception {
        for (int i = listIndex; i >= 0; --i) {
            try {
                ((InterceptorInfo)interceptors.get(i)).getInterceptor().sendException(e);
                continue;
            }
            catch (Exception e2) {
                e = e2;
            }
        }
        throw e;
    }

    private class InterceptorInfo {
        private int m_index;
        private RMIInterceptor m_interceptor = null;
        private Object m_context;
        private boolean m_beginNotificationCompleted;

        private InterceptorInfo(RMIInterceptor interceptor) {
            this.m_index = interceptor.getIdentifier();
            this.m_interceptor = interceptor;
        }

        private boolean didReceiveNotificationComplete() {
            return this.m_beginNotificationCompleted;
        }

        private void markReceiveNotificationComplete() {
            this.m_beginNotificationCompleted = true;
        }

        private void setContext(Object context) {
            this.m_context = context;
        }

        private Object getContext() {
            return this.m_context;
        }

        private int getIdentifier() {
            return this.m_index;
        }

        private RMIInterceptor getInterceptor() {
            return this.m_interceptor;
        }
    }
}

