/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.io.ClassLoaderObjectInputStream;
import com.evermind.io.IOUtils;
import com.evermind.net.AccessRegionSet;
import com.evermind.net.AddressContainer;
import com.evermind.security.User;
import com.evermind.server.ExecutionContext;
import com.evermind.server.ThreadState;
import com.evermind.server.administration.ApplicationClientConnector;
import com.evermind.server.administration.RemoteData;
import com.evermind.server.rmi.BoundObject;
import com.evermind.server.rmi.Credentials;
import com.evermind.server.rmi.LocalServerRmiMessageHandler;
import com.evermind.server.rmi.RMIInterceptorContext;
import com.evermind.server.rmi.RMIInterceptorException;
import com.evermind.server.rmi.RMILoginFailedException;
import com.evermind.server.rmi.RMIOutputStream;
import com.evermind.server.rmi.RMIPermission;
import com.evermind.server.rmi.RMIProtocol;
import com.evermind.server.rmi.RMIServer;
import com.evermind.server.rmi.RMIServerConnection;
import com.evermind.server.rmi.RMIServerContext;
import com.evermind.server.rmi.RMIServerInterceptorContext;
import com.evermind.server.rmi.RMIServerOutputStream;
import com.evermind.server.rmi.RMIServerThreadMediator;
import com.evermind.server.rmi.RmiMethodCall;
import com.evermind.server.rmi.SpecialRMIInputStream;
import com.evermind.server.rmi.SpecialRMIOutputStream;
import com.evermind.server.rmi.administration.RMIConnectionInfo;
import com.evermind.util.LongHashMap;
import com.evermind.util.ReleasableResource;
import com.evermind.util.ServerProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import oracle.j2ee.rmi.RMIMessages;
import oracle.j2ee.util.LoggingUtils;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.rmi.OracleRemoteException;
import oracle.oc4j.rmi.ServerRmiMethodCache;
import oracle.oc4j.rmi.ServerRmiTransport;
import oracle.oc4j.security.SecurityUtil;
import oracle.oc4j.util.TaskLauncher;

public class ServerRmiMessageHandler {
    private RMIProtocol m_protocol;
    private RMIServerThreadMediator m_threadMediator;
    private RMIServerContext m_context;
    private User m_authenticatingUser;
    private AccessRegionSet m_subjectPropagationAccessRegionSet;
    private LongHashMap usedObjects = new LongHashMap();
    private ExecutionContext m_executionContext;
    private TaskLauncher m_launcher;
    private ClassLoader m_overridingClassLoader;
    private int currentCallingCommandID;
    private ServerRmiMethodCache m_methodCache = new ServerRmiMethodCache();
    private static Logger m_logger = TraceLogger.getLogger(ServerRmiMessageHandler.class);
    private static Object idLock = new Object();
    private static long currentID = 300L;
    LongHashMap m_serverInterceptors = new LongHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getNextID() {
        Object object = idLock;
        synchronized (object) {
            return currentID++;
        }
    }

    public static ServerRmiMessageHandler createMessageHandler(RMIServer server, String domainName, RMIProtocol protocol, TaskLauncher launcher, Credentials credentials) throws RMILoginFailedException {
        ServerRmiMessageHandler handler = ServerRmiMessageHandler.createMessageHandler(server, domainName, protocol, launcher, false, null);
        if (null != credentials) {
            handler.login(credentials);
        }
        return handler;
    }

    public static ServerRmiMessageHandler createMessageHandler(RMIServer server, String domainName, RMIProtocol protocol, TaskLauncher launcher, boolean local, User user) throws RMILoginFailedException {
        try {
            ServerRmiMessageHandler handler;
            RMIServerContext context = server.getServerContext(domainName, false);
            if (context == null) {
                throw new RMILoginFailedException("No such domain/application: \"" + domainName + '\"');
            }
            ExecutionContext executionContext = server.getExecutionContext(context);
            if (executionContext == null) {
                throw new RMILoginFailedException("No such domain/application: \"" + domainName + '\"');
            }
            AccessRegionSet subjPropARS = null == server.getConfig() ? null : server.getConfig().getSubjectPropagationAccessRegionSet();
            ServerRmiMessageHandler serverRmiMessageHandler = handler = local ? new LocalServerRmiMessageHandler(protocol, server.getThreadMediator(), context, executionContext, launcher, subjPropARS) : new ServerRmiMessageHandler(protocol, server.getThreadMediator(), context, executionContext, launcher, subjPropARS);
            if (null != user) {
                handler.setAuthenticatingUser(user, null);
            }
            return handler;
        }
        catch (InstantiationException e) {
            throw new RMILoginFailedException("Error instantiating application " + domainName + ": \"" + e.getMessage() + '\"');
        }
    }

    ServerRmiMessageHandler(RMIProtocol protocol, RMIServerThreadMediator threadMediator, RMIServerContext context, ExecutionContext executionContext, TaskLauncher launcher, AccessRegionSet subjectPropagationAccessRegionSet) {
        this.m_protocol = protocol;
        this.m_threadMediator = threadMediator;
        this.m_context = context;
        this.m_executionContext = executionContext;
        this.m_launcher = launcher;
        this.m_subjectPropagationAccessRegionSet = subjectPropagationAccessRegionSet;
    }

    public User login(Credentials credentials) throws RMILoginFailedException {
        ThreadState threadState = ThreadState.getCurrentState();
        threadState.reset();
        threadState.contextContainer = this.m_executionContext;
        this.setAuthenticatingUser(this.m_executionContext.getUserManager().getUser(credentials.getUsername()), credentials);
        User authenticatingUser = this.getAuthenticatingUser();
        if (authenticatingUser == null) {
            RMIMessages.infoLoginFailedWithUnknownUser(this.m_executionContext.getName(), credentials);
            throw new RMILoginFailedException("Not authorized");
        }
        if (!authenticatingUser.authenticate(credentials.getPassword())) {
            RMIMessages.infoLoginFailedWithBadPassword(this.m_executionContext.getName(), credentials);
            throw new RMILoginFailedException("Not authorized");
        }
        if (!authenticatingUser.hasPermission(new RMIPermission("login"))) {
            RMIMessages.infoLoginNotPermitted(this.m_executionContext.getName(), credentials);
            throw new RMILoginFailedException("Not authorized");
        }
        threadState.setAuthenticatingUser(authenticatingUser);
        return authenticatingUser;
    }

    public User getActiveUser() {
        User authenticatingUser;
        ThreadState state = ThreadState.getCurrentState();
        User stateUser = state.getActiveUser();
        if (stateUser == (authenticatingUser = this.getAuthenticatingUser()) || null != stateUser && !this.isUserAnonymous(stateUser)) {
            return stateUser;
        }
        return authenticatingUser;
    }

    public User getUser() {
        return this.m_authenticatingUser;
    }

    public void setUser(User user) {
        this.m_authenticatingUser = user;
    }

    boolean isUserAnonymous(User stateUser) {
        return SecurityUtil.isUserAnonymous(stateUser);
    }

    public User getAuthenticatingUser() {
        return this.m_authenticatingUser;
    }

    void setAuthenticatingUser(User user, Credentials credentials) {
        this.m_authenticatingUser = user;
        if (this.m_authenticatingUser == null && null != credentials && "".equals(credentials.getUsername())) {
            this.m_authenticatingUser = this.m_executionContext.getUserManager().getAnonymousUser();
        }
    }

    public RMIProtocol getProtocol() {
        return this.m_protocol;
    }

    void reset() {
        this.currentCallingCommandID = 0;
        this.m_methodCache.reset();
        this.releaseReleasableObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReleasableObjects() {
        LongHashMap longHashMap = this.usedObjects;
        synchronized (longHashMap) {
            try {
                Iterator iter = this.usedObjects.values().iterator();
                while (iter.hasNext()) {
                    BoundObject obj = (BoundObject)iter.next();
                    if (obj.getObject() == null || !(obj.getObject() instanceof ReleasableResource)) continue;
                    ((ReleasableResource)obj.getObject()).releaseResource();
                }
            }
            catch (Throwable t) {
                RMIMessages.warningReleaseErrorDuringShutdown(t);
            }
            finally {
                this.usedObjects = new LongHashMap();
            }
        }
    }

    void setOverridingClassLoader(ClassLoader classLoader) {
        this.m_overridingClassLoader = classLoader;
    }

    void setContext(RMIServerContext context) {
        this.m_context = context;
    }

    ClassLoader getClassLoader() {
        return this.m_overridingClassLoader != null ? this.m_overridingClassLoader : this.m_context.getClassLoader();
    }

    public RMIServerContext getContext() {
        return this.m_context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BoundObject bindObject(Object object) {
        BoundObject bound = new BoundObject(object);
        LongHashMap longHashMap = this.usedObjects;
        synchronized (longHashMap) {
            this.usedObjects.put(bound.getId(), (Object)bound);
        }
        return bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BoundObject getBoundObject(long id) {
        LongHashMap longHashMap = this.usedObjects;
        synchronized (longHashMap) {
            return (BoundObject)this.usedObjects.get(id);
        }
    }

    RMIConnectionInfo getConnectionInfo(ServerRmiTransport transport) {
        return new RMIConnectionInfo(transport.getAddress() == null ? "Unknown" : transport.getAddress().getHostName(), this.m_authenticatingUser == null ? null : this.m_authenticatingUser.getName(), transport.getConnectionType(), 0L, 0L, this.getContext() == null ? null : this.getContext().getName(), false, this.currentCallingCommandID);
    }

    public String toString() {
        return "ServerRmiMessageHandler[ user=" + this.m_authenticatingUser + " protocol =" + this.m_protocol.getEffectiveProtocol() + " context=" + this.m_context + "]";
    }

    public void handleSingleRequest(InputStream inputStream, OutputStream outputStream) throws IOException {
        SpecialRMIInputStream in = new SpecialRMIInputStream(inputStream, this);
        SpecialRMIOutputStream out = new SpecialRMIOutputStream(outputStream, this);
        int command = in.read();
        this.dispatchRequest(in, out, null, command, ThreadState.getCurrentState().getAddressContainer());
        outputStream.flush();
        outputStream.close();
    }

    void dispatchRequest(ClassLoaderObjectInputStream in, RMIServerOutputStream out, RMIServerConnection connection, int command, AddressContainer addressContainer) throws IOException {
        int n;
        if (this.getProtocol().isCallIdRequired(command)) {
            int n2 = this.currentCallingCommandID;
            n = n2;
            this.currentCallingCommandID = n2 + 1;
        } else {
            n = -1;
        }
        int callId = n;
        ThreadState.getCurrentState().setAuthenticatingUser(this.getAuthenticatingUser());
        this.fireReadRequestContextInterceptor(in, command, callId);
        this.handleOrmiRequest(in, out, connection, command, callId, addressContainer);
    }

    void fireReadRequestContextInterceptor(ClassLoaderObjectInputStream in, int command, int callId) throws IOException {
        this.getProtocol().getInterceptorManager().fireReadRequestContextInterceptor(this.m_serverInterceptors, in, command, callId);
    }

    void handleOrmiRequest(ObjectInputStream in, RMIServerOutputStream out, RMIServerConnection connection, int command, int callId, AddressContainer addressContainer) throws IOException {
        switch (command) {
            case 3: {
                this.handleLookupObject(in, out, callId, addressContainer);
                break;
            }
            case 14: {
                this.handleBindObject(in, out, callId, addressContainer);
                break;
            }
            case 17: {
                this.handleUnbindObject(in, out, callId, addressContainer);
                break;
            }
            case 30: {
                this.handleListContext(in, out, callId, addressContainer);
                break;
            }
            case 40: {
                this.handleGetClassData(in, out, callId, addressContainer);
                break;
            }
            case 8: {
                this.handleObjectRelease(in, out, callId, addressContainer);
                break;
            }
            case 4: {
                this.handleMethodInvocation(in, out, connection, callId, addressContainer, this.getClassLoader());
                break;
            }
            default: {
                throw new IOException("Unknown request command: " + command);
            }
        }
    }

    RMIInterceptorContext createInterceptorContext(AddressContainer addressContainer) {
        return new RMIServerInterceptorContext(addressContainer, this.m_subjectPropagationAccessRegionSet, this.getAuthenticatingUser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLookupObject(ObjectInputStream in, RMIServerOutputStream out, int callId, AddressContainer addressContainer) throws IOException {
        Object object;
        String name = in.readUTF();
        boolean clientUsesOpmn = in.readBoolean();
        if (ServerProperties.getRunningInIAS() && !clientUsesOpmn && "java:comp/ServerAdministrator".equals(name)) {
            this.rejectLookup(out, callId, 35, "This operation was denied. The admin.jar utility can not be used to perform operations against OPMN managed OC4J instnaces. Please use Enterprise Manager instead. Refer to the Oracle10iAS Admin Guide or the OC4J User's Guide for more details.");
            return;
        }
        try {
            this.getProtocol().getInterceptorManager().fireReceiveRequestInterceptor(this.m_serverInterceptors, callId, this.createInterceptorContext(addressContainer));
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "looking up {0} in context {1}", new Object[]{name, this.m_context.getName()});
            }
            object = this.m_context.lookupRemoteableObject(name);
            m_logger.log(Level.FINER, "Found object {0}", object);
        }
        catch (NamingException e) {
            String explanation = e.getMessage() == null ? "Object lookup problem, check server configuration" : e.getMessage();
            this.rejectLookup(out, callId, 7, explanation);
            return;
        }
        catch (RMIInterceptorException e) {
            this.rejectLookup(out, callId, 7, e.toString());
            return;
        }
        RMIServerOutputStream rMIServerOutputStream = out;
        synchronized (rMIServerOutputStream) {
            if (!this.m_context.hasReadAccess(name, this.getAuthenticatingUser(), addressContainer)) {
                this.writeErrorResponse(out, 9, callId, 35, "Not allowed to look up " + name + ", check the namespace-access tag setting in orion-application.xml for details");
            } else if (object == null && !this.m_context.hasRemoteableBindingInParentHierarchy(name)) {
                this.writeNormalResponse(out, 9, callId, 1);
            } else {
                this.writeNormalResponse(out, 9, callId, 2);
                try {
                    out.writeMainObject(object, name);
                }
                catch (NotSerializableException e) {
                    m_logger.warning("Unable to send found object: " + e);
                    LoggingUtils.logWarningStackTrace(m_logger, e);
                }
            }
            out.flush();
            out.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rejectLookup(RMIOutputStream out, int callId, int reason, String explanation) throws IOException {
        RMIOutputStream rMIOutputStream = out;
        synchronized (rMIOutputStream) {
            this.writeErrorResponse(out, 9, callId, reason, explanation);
            out.flush();
            out.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBindObject(ObjectInputStream in, RMIOutputStream out, int callId, AddressContainer addressContainer) throws IOException {
        block20: {
            try {
                this.getProtocol().getInterceptorManager().fireReceiveRequestInterceptor(this.m_serverInterceptors, callId, this.createInterceptorContext(addressContainer));
                String name = in.readUTF();
                m_logger.log(Level.FINE, "handle bind of name {0}", name);
                Object object = in.readObject();
                if (!this.m_context.hasWriteAccess(name, this.getActiveUser(), addressContainer)) {
                    RMIOutputStream rMIOutputStream = out;
                    synchronized (rMIOutputStream) {
                        this.writeErrorResponse(out, 15, callId, 23, "User does not have a bind-permission for " + name);
                        out.flush();
                        break block20;
                    }
                }
                this.m_context.rebind(name, object, 3);
                RMIOutputStream rMIOutputStream = out;
                synchronized (rMIOutputStream) {
                    this.writeNormalResponse(out, 15, callId, 16);
                    out.flush();
                }
            }
            catch (ClassNotFoundException e) {
                RMIOutputStream rMIOutputStream = out;
                synchronized (rMIOutputStream) {
                    this.writeErrorResponse(out, 15, callId, 7, "Class not found: " + e.getMessage());
                    out.flush();
                }
                throw new IOException("Class not found: " + e.getMessage());
            }
            catch (NamingException namingException) {
                RMIOutputStream rMIOutputStream = out;
                synchronized (rMIOutputStream) {
                    this.writeErrorResponse(out, 15, callId, 7, namingException.getMessage());
                    out.flush();
                }
                throw new IOException(namingException.getMessage());
            }
            catch (RMIInterceptorException e) {
                RMIOutputStream rMIOutputStream = out;
                synchronized (rMIOutputStream) {
                    this.writeErrorResponse(out, 15, callId, 7, e.toString());
                    out.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUnbindObject(ObjectInputStream in, RMIOutputStream out, int callId, AddressContainer addressContainer) throws IOException {
        try {
            this.getProtocol().getInterceptorManager().fireReceiveRequestInterceptor(this.m_serverInterceptors, callId, this.createInterceptorContext(addressContainer));
            String name = in.readUTF();
            m_logger.log(Level.FINE, "handle unbind of name {0}", name);
            if (!this.m_context.hasWriteAccess(name, this.getActiveUser(), addressContainer)) {
                RMIOutputStream rMIOutputStream = out;
                synchronized (rMIOutputStream) {
                    this.writeErrorResponse(out, 18, callId, 23, "User does not have a unbind-permission for " + name);
                    out.flush();
                }
                return;
            }
            this.m_context.unbind(name);
            RMIOutputStream rMIOutputStream = out;
            synchronized (rMIOutputStream) {
                this.writeNormalResponse(out, 18, callId, 19);
                out.flush();
            }
        }
        catch (NamingException namingException) {
            RMIOutputStream rMIOutputStream = out;
            synchronized (rMIOutputStream) {
                this.writeErrorResponse(out, 18, callId, 7, namingException.getMessage());
                out.flush();
            }
            throw new IOException(namingException.getMessage());
        }
        catch (RMIInterceptorException e) {
            RMIOutputStream rMIOutputStream = out;
            synchronized (rMIOutputStream) {
                this.writeErrorResponse(out, 18, callId, 7, e.toString());
                out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListContext(ObjectInputStream in, RMIOutputStream out, int callId, AddressContainer addressContainer) throws IOException {
        try {
            this.getProtocol().getInterceptorManager().fireReceiveRequestInterceptor(this.m_serverInterceptors, callId, this.createInterceptorContext(addressContainer));
            String name = in.readUTF();
            m_logger.log(Level.FINE, "handle list of context {0}", name);
            boolean bindings = in.readBoolean();
            Map values = this.m_context.listLocalContext(name, bindings, this.getActiveUser(), addressContainer, true);
            RMIOutputStream rMIOutputStream = out;
            synchronized (rMIOutputStream) {
                this.writeNormalResponse(out, 39, callId, 34);
                out.writeObject(values);
                out.flush();
                out.reset();
            }
        }
        catch (RMIInterceptorException e) {
            RMIOutputStream rMIOutputStream = out;
            synchronized (rMIOutputStream) {
                this.writeErrorResponse(out, 39, callId, 7, e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetClassData(ObjectInputStream in, RMIOutputStream out, int callId, AddressContainer addressContainer) throws IOException {
        try {
            this.getProtocol().getInterceptorManager().fireReceiveRequestInterceptor(this.m_serverInterceptors, callId, this.createInterceptorContext(addressContainer));
            String name = in.readUTF();
            m_logger.log(Level.FINE, "handle get class data for {0}", name);
            long lastModified = in.readLong();
            ApplicationClientConnector connector = (ApplicationClientConnector)this.m_context.lookupRemoteableObject("java:comp/ApplicationClientConnector");
            RemoteData data = null;
            try {
                data = connector.getClassData(name, lastModified);
            }
            catch (Throwable t) {
                // empty catch block
            }
            RMIOutputStream rMIOutputStream = out;
            synchronized (rMIOutputStream) {
                int status = data == null ? 0 : 2;
                this.writeNormalResponse(out, 41, callId, status);
                if (data != null) {
                    out.writeLong(data.getLastModified());
                    if (data.getData() != null) {
                        IOUtils.writeCompressedInt(out, data.getData().length);
                        out.write(data.getData());
                    } else {
                        IOUtils.writeCompressedInt(out, -1);
                    }
                }
                out.flush();
            }
        }
        catch (NamingException e) {
            throw new IOException(e.getMessage());
        }
        catch (RMIInterceptorException e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleObjectRelease(ObjectInputStream objectInputStream, RMIOutputStream out, int callId, AddressContainer addressContainer) throws IOException {
        try {
            BoundObject bound;
            this.getProtocol().getInterceptorManager().fireReceiveRequestInterceptor(this.m_serverInterceptors, callId, this.createInterceptorContext(addressContainer));
            long id = objectInputStream.readLong();
            Object object = this.usedObjects;
            synchronized (object) {
                bound = (BoundObject)this.usedObjects.remove(id);
            }
            if (bound != null && bound.getObject() instanceof ReleasableResource) {
                ((ReleasableResource)bound.getObject()).releaseResource();
            }
            object = out;
            synchronized (object) {
                this.writeNormalResponse(out, 52, callId, 0);
                this.getProtocol().writeObjectResponseId(out, id);
                out.flush();
            }
        }
        catch (RMIInterceptorException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void handleMethodInvocation(ObjectInputStream in, RMIOutputStream out, RMIServerConnection connection, int callId, AddressContainer addressContainer, ClassLoader domainClassLoader) throws IOException {
        m_logger.fine("handle a method invocation");
        long id = in.readLong();
        long checksum = in.readLong();
        try {
            Method method = this.m_methodCache.readMethod(in, domainClassLoader);
            Class<?>[] paramTypes = method.getParameterTypes();
            int argCount = IOUtils.readCompressedInt(in);
            Object[] args = new Object[argCount];
            for (int i = 0; i < argCount; ++i) {
                args[i] = this.m_protocol.readValue(paramTypes[i], in);
            }
            BoundObject object = this.validateBoundObjectForMethodInvocation(this.getBoundObject(id), checksum);
            if (object != null) {
                this.doMethodCall(out, connection, callId, addressContainer, method, object.getObject(), args);
            }
        }
        catch (ObjectStreamException e) {
            this.sendExceptionResponse(e, out, callId);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (this.m_context != null && !this.m_context.isApplicationRunning()) {
                this.sendExceptionResponse(new OracleRemoteException("Application was stopped"), out, callId);
            } else {
                this.sendExceptionResponse(e, out, callId);
            }
        }
        catch (Throwable e) {
            this.sendExceptionResponse(e, out, callId);
        }
    }

    private BoundObject validateBoundObjectForMethodInvocation(BoundObject object, long checksum) throws IOException {
        if (object == null) {
            throw new IOException("Invalid/gc'ed object");
        }
        if (object.getChecksum() != checksum) {
            throw new IOException("Invalid checksum");
        }
        return object;
    }

    private void doMethodCall(RMIOutputStream out, RMIServerConnection connection, int callID, AddressContainer addressContainer, Method method, Object object, Object[] args) {
        RmiMethodCall methodCall = new RmiMethodCall(this, addressContainer, callID, out, connection, method, object, args);
        if (this.m_launcher == null) {
            methodCall.run();
        } else {
            this.m_launcher.launch(methodCall);
        }
    }

    void establishCallingContext(ThreadState state, AddressContainer addressContainer) {
        this.m_threadMediator.establishCallingContext(state, this.getAuthenticatingUser(), this.m_executionContext, addressContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendExceptionResponse(Throwable t, RMIOutputStream out, int callID) throws IOException {
        LoggingUtils.logWarningStackTrace(m_logger, t);
        RMIOutputStream rMIOutputStream = out;
        synchronized (rMIOutputStream) {
            try {
                this.writeExceptionResponse(out, 10, callID, true, t);
            }
            finally {
                out.flush();
                out.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnException(RMIOutputStream out, int callID, boolean systemException, Throwable e) throws IOException {
        RMIOutputStream rMIOutputStream = out;
        synchronized (rMIOutputStream) {
            try {
                this.writeExceptionResponse(out, 10, callID, systemException, e);
            }
            finally {
                out.flush();
                out.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnMethodInvocationResponse(RMIOutputStream out, int callID, Method method, Object response) throws IOException {
        RMIOutputStream rMIOutputStream = out;
        synchronized (rMIOutputStream) {
            try {
                this.writeNormalResponse(out, 10, callID, 5);
                this.m_protocol.writeValue(method.getReturnType(), out, response);
            }
            catch (NotSerializableException se) {
                m_logger.log(Level.FINE, "Socket Write Error (3): {0}", se);
            }
            finally {
                out.flush();
                out.reset();
            }
        }
    }

    private void writeNormalResponse(RMIOutputStream out, int response, int callId, int status) throws IOException {
        m_logger.log(Level.FINE, "writeNormalResponse response : " + response + " callId : " + callId);
        this.getProtocol().writeNormalResponse(out, response, callId, status, this.m_serverInterceptors);
    }

    private void writeErrorResponse(RMIOutputStream out, int response, int callId, int status, String explanation) throws IOException {
        m_logger.log(Level.FINE, "writeErrorResponse response : " + response + " callId : " + callId);
        this.writeNormalResponse(out, response, callId, status);
        out.writeUTF(explanation);
    }

    private void writeExceptionResponse(RMIOutputStream out, int command, int callId, boolean systemException, Throwable exception) throws IOException {
        this.writeCommandByte(out, command);
        IOUtils.writeCompressedInt(out, callId);
        if (systemException) {
            this.m_protocol.getInterceptorManager().fireSendExceptionInterceptor(this.m_serverInterceptors, out, callId, exception);
        } else {
            this.m_protocol.getInterceptorManager().fireSendReplyInterceptor(this.m_serverInterceptors, out, callId);
        }
        try {
            IOUtils.writeCompressedInt(out, 7);
            out.writeException(exception);
        }
        catch (NotSerializableException se) {
            out.writeException(se);
        }
    }

    private void writeCommandByte(RMIOutputStream out, int command) throws IOException {
        out.write(command);
    }
}

