/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.servlet;

import com.evermind.server.http.HttpDateFormat;
import java.io.File;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;

public class StylesheetCache {
    public Source source;
    public Templates templates;
    public File file;
    public long lastModified;
    public long lastModifiedCheck;
    public String contentType;
    public int availableTransformersCount;
    public Transformer[] availableTransformers = new Transformer[4];

    public boolean isValid() {
        long currentTime = HttpDateFormat.currentTimeMillis();
        if (this.file != null && currentTime > this.lastModifiedCheck) {
            if (this.file.lastModified() != this.lastModified) {
                return false;
            }
            this.lastModifiedCheck = currentTime + 1000L;
        }
        return true;
    }

    public synchronized Transformer getTransformer() throws TransformerConfigurationException {
        if (this.availableTransformersCount > 0) {
            return this.availableTransformers[--this.availableTransformersCount];
        }
        return this.templates.newTransformer();
    }

    public synchronized void releaseTransformer(Transformer transformer) {
        if (this.availableTransformersCount >= this.availableTransformers.length) {
            Transformer[] newTransformers = new Transformer[this.availableTransformers.length * 2];
            System.arraycopy(this.availableTransformers, 0, newTransformers, 0, this.availableTransformers.length);
            this.availableTransformers = newTransformers;
        }
        this.availableTransformers[this.availableTransformersCount++] = transformer;
    }
}

