/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.servlet;

import com.evermind.servlet.StylesheetCache;
import com.evermind.servlet.XMLCache;
import com.evermind.servlet.XSLResult;
import com.evermind.servlet.XSLTransformationHandler;
import com.evermind.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSLServlet
extends HttpServlet
implements URIResolver {
    public static final int SOURCE_STREAM = 1;
    public static final int SOURCE_SAX = 2;
    public static final int SOURCE_DOM = 3;
    protected Map documents = new WeakHashMap();
    protected Map stylesheets = new WeakHashMap();
    private int sourceType = 3;
    private int cacheMaxSize = 50;
    private String defaultContentType;
    private TransformerFactory[] factories = new TransformerFactory[4];
    private int factoriesCount;
    private DocumentBuilder[] documentBuilders = new DocumentBuilder[4];
    private int documentBuildersCount;

    public void init() {
        this.defaultContentType = this.getInitParameter("defaultContentType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XMLCache cache;
        byte[] data = new byte[request.getContentLength()];
        ServletInputStream requestIn = request.getInputStream();
        requestIn.read(data);
        requestIn.close();
        String requestURI = request.getServletPath();
        String realPath = this.getServletContext().getRealPath(requestURI);
        realPath = realPath == null ? "module:" + requestURI : (!(realPath = realPath.replace(File.separatorChar, '/')).startsWith("/") ? "file:/".concat(realPath) : "file:".concat(realPath));
        String client = request.getHeader("User-Agent");
        String charset = request.getCharacterEncoding();
        Map map = this.documents;
        synchronized (map) {
            cache = (XMLCache)this.documents.get(requestURI);
        }
        ServletOutputStream out = response.getOutputStream();
        if (cache != null) {
            if (!Arrays.equals(data, cache.data)) {
                cache = null;
            }
            if (cache != null) {
                XMLCache xMLCache = cache;
                synchronized (xMLCache) {
                    for (int i = 0; i < cache.resultCount; ++i) {
                        XSLResult result = cache.results[i];
                        if (!XSLServlet.equals(client, result.client) || !XSLServlet.equals(charset, result.charset)) continue;
                        if (result.stylesheet.isValid()) {
                            this.writeResult(response, result);
                            return;
                        }
                        cache.removeResult(i);
                        --i;
                    }
                }
            }
        }
        if (cache == null) {
            cache = new XMLCache(data);
        }
        try {
            XSLTransformationHandler handler = new XSLTransformationHandler(this.getServletContext(), request);
            if (cache.source == null) {
                switch (this.sourceType) {
                    case 3: {
                        DocumentBuilder documentBuilder = this.getDocumentBuilder();
                        documentBuilder.setErrorHandler(handler);
                        InputSource inputSource = new InputSource(new ByteArrayInputStream(data));
                        inputSource.setSystemId(realPath);
                        try {
                            Document document = documentBuilder.parse(inputSource);
                            this.releaseDocumentBuilder(documentBuilder);
                            cache.source = new DOMSource(document, realPath);
                            break;
                        }
                        catch (SAXException e) {
                            this.displayError(response, "Error parsing source XML for " + requestURI, handler.getProblems().length() > 0 ? handler.getProblems() : e.getMessage());
                            return;
                        }
                    }
                    case 1: {
                        cache.source = new StreamSource(charset == null ? new InputStreamReader(new ByteArrayInputStream(data)) : new InputStreamReader((InputStream)new ByteArrayInputStream(data), charset), realPath);
                    }
                    case 2: {
                        try {
                            InputSource inputSource = new InputSource(new ByteArrayInputStream(data));
                            inputSource.setSystemId(realPath);
                            cache.source = new SAXSource(SAXParserFactory.newInstance().newSAXParser().getXMLReader(), inputSource);
                            break;
                        }
                        catch (SAXException e) {
                            this.displayError(response, "Error reading XML source", e.getMessage());
                            return;
                        }
                    }
                }
                Map e = this.documents;
                synchronized (e) {
                    this.documents.put(requestURI, cache);
                }
            }
            TransformerFactory factory = this.getFactory();
            factory.setErrorListener(handler);
            String specifiedClient = client;
            String specifiedCharset = charset;
            try {
                StylesheetCache xslCache;
                Source xsl = factory.getAssociatedStylesheet(cache.source, client, null, charset);
                try {
                    if (xsl == null) {
                        xsl = factory.getAssociatedStylesheet(cache.source, client, null, null);
                    }
                    specifiedCharset = null;
                }
                catch (TransformerException e) {
                    // empty catch block
                }
                try {
                    if (xsl == null) {
                        xsl = factory.getAssociatedStylesheet(cache.source, null, null, charset);
                    }
                    specifiedClient = null;
                }
                catch (TransformerException e) {
                    // empty catch block
                }
                if (xsl == null) {
                    xsl = factory.getAssociatedStylesheet(cache.source, null, null, null);
                }
                if (xsl == null) {
                    response.setContentType(request.getContentType());
                    response.setContentLength(data.length);
                    response.getOutputStream().write(data);
                    response.getOutputStream().close();
                    return;
                }
                String xslID = xsl.getSystemId();
                if (xslID == null) {
                    this.displayError(response, "Transformer implementation error", "Stylesheet didnt have a system ID, check the TRAX implementation used");
                    return;
                }
                Object object = this.stylesheets;
                synchronized (object) {
                    xslCache = (StylesheetCache)this.stylesheets.get(xslID);
                    if (xslCache != null && !xslCache.isValid()) {
                        xslCache = null;
                    }
                    if (xslCache == null) {
                        xslCache = new StylesheetCache();
                        xslCache.source = xsl;
                        xslCache.file = new File(new URL(xslID).getFile());
                        xslCache.lastModified = xslCache.file.lastModified();
                        if (xslCache.lastModified <= 0L) {
                            xslCache.file = null;
                        }
                        xslCache.templates = factory.newTemplates(xslCache.source);
                        try {
                            xslCache.contentType = (String)xslCache.templates.getOutputProperties().get("media-type");
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        this.stylesheets.put(xslID, xslCache);
                    }
                }
                object = cache;
                synchronized (object) {
                    for (int i = 0; i < cache.resultCount; ++i) {
                        XSLResult result = cache.results[i];
                        if (result.stylesheet != xslCache) continue;
                        cache.addResult(new XSLResult(client, charset, xslCache, result.output));
                        this.writeResult(response, result);
                        return;
                    }
                }
                Transformer transformer = xslCache.getTransformer();
                transformer.setErrorListener(handler);
                transformer.setURIResolver(this);
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                try {
                    transformer.transform(cache.source, new StreamResult(output));
                }
                catch (TransformerException e) {
                    this.displayError(response, "Error applying XSL", handler.getProblems().length() > 0 ? handler.getProblems() : e.getMessage());
                    this.releaseFactory(factory);
                    return;
                }
                xslCache.releaseTransformer(transformer);
                byte[] outputData = output.toByteArray();
                XSLResult result = new XSLResult(client, charset, xslCache, outputData);
                cache.addResult(result);
                this.writeResult(response, result);
                return;
            }
            finally {
                this.releaseFactory(factory);
            }
        }
        catch (ParserConfigurationException e) {
            this.displayError(response, "Error initializing XML parser, configuration error", e.getMessage());
            return;
        }
        catch (TransformerConfigurationException e) {
            this.displayError(response, "Error initializing XSL transformer, configuration error", e.getMessage());
        }
    }

    public synchronized TransformerFactory getFactory() {
        if (this.factoriesCount > 0) {
            return this.factories[--this.factoriesCount];
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setURIResolver(this);
        return factory;
    }

    public synchronized void releaseFactory(TransformerFactory factory) {
        if (this.factoriesCount >= this.factories.length) {
            TransformerFactory[] newFactories = new TransformerFactory[this.factories.length * 2];
            System.arraycopy(this.factories, 0, newFactories, 0, this.factories.length);
            this.factories = newFactories;
        }
        this.factories[this.factoriesCount++] = factory;
    }

    public synchronized DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.documentBuildersCount > 0) {
            return this.documentBuilders[--this.documentBuildersCount];
        }
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder;
    }

    public synchronized void releaseDocumentBuilder(DocumentBuilder builder) {
        if (this.documentBuildersCount >= this.documentBuilders.length) {
            DocumentBuilder[] newDocumentBuilders = new DocumentBuilder[this.documentBuilders.length * 2];
            System.arraycopy(this.documentBuilders, 0, newDocumentBuilders, 0, this.documentBuilders.length);
            this.documentBuilders = newDocumentBuilders;
        }
        this.documentBuilders[this.documentBuildersCount++] = builder;
    }

    /*
     * WARNING - void declaration
     */
    public Source resolve(String href, String base) throws TransformerException {
        void var3_3;
        InputStream input;
        if (!href.startsWith("/")) {
            if (base != null && !base.endsWith("/")) {
                base = base.substring(0, base.lastIndexOf(47) + 1);
            }
            if (base.startsWith("module:")) {
                href = (base = base.substring("module:".length())).endsWith("/") ? base.concat(href) : base + '/' + href;
                input = this.getServletContext().getResourceAsStream(href);
            } else {
                href = base.endsWith("/") ? base.concat(href) : base + '/' + href;
                try {
                    input = new URL(href).openStream();
                }
                catch (MalformedURLException e) {
                    throw new TransformerException("Resource " + href + " does not exist, malformed URL: " + e.getMessage());
                }
                catch (IOException e) {
                    throw new TransformerException("Error loading resource " + href + ": " + e.getMessage());
                }
            }
        } else {
            try {
                input = new FileInputStream(href);
            }
            catch (IOException e) {
                throw new TransformerException("Resource " + href + " does not exist: " + e.getMessage());
            }
        }
        if (var3_3 != null) {
            return new StreamSource((InputStream)var3_3, href);
        }
        throw new TransformerException("Resource " + href + " does not exist");
    }

    public static boolean equals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public void writeResult(HttpServletResponse response, XSLResult result) throws IOException {
        response.setHeader("Last-Modified", null);
        if (result.stylesheet.contentType != null) {
            response.setContentType(result.stylesheet.contentType);
        } else if (this.defaultContentType != null) {
            response.setContentType(this.defaultContentType);
        }
        response.setContentLength(result.output.length);
        response.getOutputStream().write(result.output);
        response.getOutputStream().close();
    }

    public void displayError(HttpServletResponse response, String title, String message) throws IOException {
        if (message != null) {
            message = StringUtils.replace(message, "<", "&lt;");
            message = StringUtils.replace(message, ">", "&gt;");
        }
        response.setHeader("Last-Modified", null);
        response.setContentType("text/html");
        response.getOutputStream().println("<HTML><HEAD><TITLE>" + title + "</TITLE></HEAD><BODY><PRE>" + message + "</PRE></BODY></HTML>");
        response.getOutputStream().close();
    }
}

