/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.servlet;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class XSLTransformationHandler
implements ErrorListener,
ErrorHandler {
    private ServletContext context;
    private HttpServletRequest request;
    private PrintWriter problemWriter;
    private CharArrayWriter problemBuffer;

    public XSLTransformationHandler(ServletContext context, HttpServletRequest request) {
        this.context = context;
        this.request = request;
    }

    public void error(TransformerException e) throws TransformerException {
        if (this.problemWriter == null) {
            this.problemBuffer = new CharArrayWriter();
            this.problemWriter = new PrintWriter(this.problemBuffer);
        }
        this.problemWriter.write("Error: " + e.getMessageAndLocation() + "\n");
        throw new TransformerException(this.getProblems());
    }

    public void fatalError(TransformerException e) throws TransformerException {
        if (this.problemWriter == null) {
            this.problemBuffer = new CharArrayWriter();
            this.problemWriter = new PrintWriter(this.problemBuffer);
        }
        this.problemWriter.write("Fatal Error: " + e.getMessageAndLocation() + "\n");
    }

    public void warning(TransformerException e) {
        if (this.problemWriter == null) {
            this.problemBuffer = new CharArrayWriter();
            this.problemWriter = new PrintWriter(this.problemBuffer);
        }
        this.problemWriter.write("Warning: " + e.getMessageAndLocation() + "\n");
    }

    public String getProblems() {
        if (this.problemWriter == null) {
            return "";
        }
        this.problemWriter.flush();
        return new String(this.problemBuffer.toCharArray());
    }

    public void warning(SAXParseException exception) {
        this.handle(exception, "Warning");
    }

    public void handle(SAXParseException e, String level) {
        if (this.problemWriter == null) {
            this.problemBuffer = new CharArrayWriter();
            this.problemWriter = new PrintWriter(this.problemBuffer);
        }
        String location = "";
        if (e.getPublicId() != null) {
            location = " in " + e.getPublicId();
        } else if (e.getSystemId() != null) {
            location = " in " + e.getSystemId();
        }
        if (e.getLineNumber() >= 0) {
            location = location + " at line " + e.getLineNumber();
            if (e.getColumnNumber() >= 0) {
                location = location + " offset " + e.getColumnNumber();
            }
        }
        this.problemWriter.write(level + location + ": ");
        this.problemWriter.write(e.getMessage() + "\n");
    }

    public void error(SAXParseException exception) throws SAXParseException {
        this.handle(exception, "Error");
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXParseException {
        this.handle(exception, "Fatal error");
        throw exception;
    }
}

