/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.Item;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Enumeration;

public class ItemList
implements Cloneable,
Enumeration,
Serializable {
    protected int nrOfItems = 0;
    protected int maxItems = 10;
    protected int expandStepping = 10;
    protected int currentItem = 0;
    protected String sortingFieldName = "";
    protected Item[] item = new Item[this.maxItems];
    protected Field sortingField = null;

    public boolean hasMoreElements() {
        return this.currentItem < this.nrOfItems - 1;
    }

    public Object nextElement() {
        if (this.currentItem < this.nrOfItems - 1) {
            return this.item[++this.currentItem];
        }
        return null;
    }

    public void fix() {
        for (int i = 0; i < this.nrOfItems - 1; ++i) {
            for (int x = i + 1; x < this.nrOfItems; ++x) {
                if (this.item[i] != this.item[x] && !this.item[i].productId.equals(this.item[x].productId)) continue;
                System.err.println("Fixed item (" + i + " and " + x + " where identical)");
                this.item[i] = this.item[--this.nrOfItems];
                this.item[this.nrOfItems] = null;
            }
        }
        if (this.currentItem >= this.nrOfItems) {
            this.currentItem = this.nrOfItems - 1;
        }
    }

    public Item find(String productId) {
        for (int i = 0; i < this.nrOfItems; ++i) {
            if (!this.item[i].productId.equals(productId)) continue;
            return this.item[i];
        }
        return null;
    }

    public Item find(int id) {
        for (int i = 0; i < this.nrOfItems; ++i) {
            if (this.item[i].id != id) continue;
            return this.item[i];
        }
        return null;
    }

    public int add(Item newItem) {
        if (this.nrOfItems >= this.maxItems) {
            this.expand();
        }
        this.item[this.nrOfItems] = newItem;
        this.item[this.nrOfItems].id = this.nrOfItems;
        return ++this.nrOfItems;
    }

    public void add(ItemList otherItemList) {
        otherItemList.moveFirst();
        do {
            this.add(otherItemList.getCurrentItem());
        } while (otherItemList.moveNext());
    }

    protected void expand() {
        this.expand(this.expandStepping);
    }

    protected void expand(int amount) {
        this.maxItems += amount;
        Item[] newItemList = new Item[this.maxItems];
        for (int i = 0; i < this.nrOfItems; ++i) {
            newItemList[i] = this.item[i];
        }
        this.item = newItemList;
    }

    public void remove(Item removeItem) {
        for (int i = 0; i < this.nrOfItems; ++i) {
            if (this.item[i] != removeItem) continue;
            this.item[i] = this.item[--this.nrOfItems];
            this.item[this.nrOfItems] = null;
        }
        if (this.currentItem >= this.nrOfItems) {
            this.currentItem = this.nrOfItems - 1;
        }
    }

    public void remove(String removeItemname) {
        for (int i = 0; i < this.nrOfItems; ++i) {
            if (!this.item[i].productId.equals(removeItemname)) continue;
            this.item[i] = this.item[--this.nrOfItems];
            this.item[this.nrOfItems] = null;
        }
        if (this.currentItem >= this.nrOfItems) {
            this.currentItem = this.nrOfItems - 1;
        }
    }

    public void remove(int removeId) {
        for (int i = 0; i < this.nrOfItems; ++i) {
            if (this.item[i].id != removeId) continue;
            this.item[i] = this.item[--this.nrOfItems];
            this.item[this.nrOfItems] = null;
        }
        if (this.currentItem >= this.nrOfItems) {
            this.currentItem = this.nrOfItems - 1;
        }
    }

    public void sortItemsById() {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < this.nrOfItems - 1; ++i) {
                if (this.item[i].id <= this.item[i + 1].id) continue;
                changed = true;
                Item tempItem = this.item[i];
                this.item[i] = this.item[i + 1];
                this.item[i + 1] = tempItem;
            }
        }
        this.currentItem = 0;
    }

    public void sortItemsByItemname() {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < this.nrOfItems - 1; ++i) {
                if (this.item[i].productId.compareTo(this.item[i + 1].productId) <= 0) continue;
                changed = true;
                Item tempItem = this.item[i];
                this.item[i] = this.item[i + 1];
                this.item[i + 1] = tempItem;
            }
        }
        this.currentItem = 0;
    }

    public Item[] getItems() {
        return this.getItems(this.sortingFieldName);
    }

    public Item[] getItems(String fieldName) {
        Item[] newItems = new Item[this.nrOfItems];
        this.sortingFieldName = fieldName;
        this.sort();
        for (int i = 0; i < this.nrOfItems; ++i) {
            newItems[i] = this.item[i];
        }
        return newItems;
    }

    public int length() {
        return this.nrOfItems;
    }

    public void sort(String fieldName) {
        this.sortingFieldName = fieldName;
        try {
            this.sortingField = this.item[0].getClass().getField(this.sortingFieldName);
        }
        catch (Exception e) {
            return;
        }
        this.sort();
    }

    public void sort() {
        if (this.sortingField == null) {
            return;
        }
        boolean changed = true;
        String dummy = this.sortingField.getType().getName();
        boolean isString = this.sortingField.getType().getName().equals("java.lang.String");
        while (changed) {
            changed = false;
            for (int i = 0; i < this.nrOfItems - 1; ++i) {
                try {
                    if ((!isString || ((String)this.sortingField.get(this.item[i])).compareTo((String)this.sortingField.get(this.item[i + 1])) <= 0) && (isString || Integer.parseInt((String)this.sortingField.get(this.item[i])) <= Integer.parseInt((String)this.sortingField.get(this.item[i + 1])))) continue;
                    changed = true;
                    Item tempItem = this.item[i];
                    this.item[i] = this.item[i + 1];
                    this.item[i + 1] = tempItem;
                    continue;
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        this.currentItem = 0;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.nrOfItems = in.readInt();
        this.maxItems = in.readInt();
        this.expandStepping = in.readInt();
        this.currentItem = in.readInt();
        this.sortingFieldName = in.readUTF();
        this.item = new Item[this.nrOfItems];
        for (int i = 0; i < this.nrOfItems; ++i) {
            this.item[i] = (Item)in.readObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.nrOfItems);
        out.writeInt(this.maxItems);
        out.writeInt(this.expandStepping);
        out.writeInt(this.currentItem);
        out.writeUTF(this.sortingFieldName);
        for (int i = 0; i < this.nrOfItems; ++i) {
            out.writeObject(this.item[i]);
        }
    }

    public static boolean writeItemList(ItemList itemList, String fileName) {
        try {
            FileOutputStream outStream = new FileOutputStream(fileName);
            ObjectOutputStream out = new ObjectOutputStream(outStream);
            out.writeObject(itemList);
            out.flush();
            out.close();
            outStream.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static ItemList readItemList(String fileName) {
        try {
            FileInputStream inStream = new FileInputStream(fileName);
            ObjectInputStream in = new ObjectInputStream(inStream);
            ItemList itemList = (ItemList)in.readObject();
            in.close();
            inStream.close();
            return itemList;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void moveFirst() {
        this.currentItem = 0;
    }

    public void moveLast() {
        this.currentItem = this.nrOfItems - 1;
    }

    public boolean moveNext() {
        if (this.currentItem < this.nrOfItems - 1) {
            ++this.currentItem;
            return true;
        }
        return false;
    }

    public boolean movePrev() {
        if (this.currentItem > 0) {
            --this.currentItem;
            return true;
        }
        return false;
    }

    public Item getCurrentItem() {
        if (this.currentItem >= 0) {
            return this.item[this.currentItem];
        }
        return null;
    }
}

