/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.LogEvent;
import com.evermind.util.Logger;
import com.evermind.util.LoggerContext;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.logging.Level;

public class JavaUtilLoggingLogger
implements Logger {
    private java.util.logging.Logger logger = null;
    private LoggerContext context = null;

    public void setLoggerName(String loggerName) {
        if (loggerName != null) {
            this.logger = java.util.logging.Logger.getLogger(loggerName);
        }
    }

    public void setContext(LoggerContext _context) {
        this.context = _context;
    }

    public void init(Properties properties) {
        if (properties != null) {
            String name = properties.getProperty("name");
            String parentName = properties.getProperty("parentName");
            String urlFileName = properties.getProperty("urlFileName");
            String loggerName = null;
            if (name != null) {
                if (name.equals("system")) {
                    loggerName = "oracle.j2ee.applications.system";
                } else if (name.equals("default")) {
                    loggerName = "oracle.j2ee.applications.default";
                } else if (name.equals("ascontrol")) {
                    loggerName = "oracle.j2ee.applications.ascontrol";
                } else if (parentName != null) {
                    if (parentName.equals("config")) {
                        int i;
                        String nameWithoutExtension = null;
                        if (urlFileName != null && (i = urlFileName.indexOf(".xml")) != -1) {
                            nameWithoutExtension = urlFileName.substring(0, i);
                        }
                        loggerName = nameWithoutExtension != null ? "oracle.j2ee.config." + nameWithoutExtension : "oracle.j2ee.config";
                    } else if (parentName.equals("applications")) {
                        loggerName = "oracle.j2ee.applications." + name;
                    }
                }
            }
            this.setLoggerName(loggerName);
        }
    }

    public void log(LogEvent event) {
        if (event != null && this.logger != null) {
            int msgType = event.getType();
            Level level = Level.INFO;
            if (msgType == 2) {
                level = Level.WARNING;
            } else if (msgType == 3) {
                level = Level.WARNING;
            } else if (msgType == 4) {
                level = Level.SEVERE;
            }
            if (event.getThrowable() != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintWriter printWriter = new PrintWriter(out);
                if (this.context != null) {
                    this.context.printStackTrace(event.getThrowable(), printWriter);
                } else {
                    event.getThrowable().printStackTrace(printWriter);
                }
                this.logger.log(level, event.getMessage(), event.getThrowable());
                printWriter.flush();
            } else {
                this.logger.log(level, event.getMessage());
            }
        }
    }

    public void setLogTimestamp(boolean timestamp) {
    }

    public void close() {
    }

    public String toString() {
        String str = null;
        if (this.logger != null) {
            str = "java.util.logging Logger: " + this.logger.getName();
        }
        return str;
    }
}

