/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.Serializable;

public class LogEvent
implements Serializable {
    public static final long serialVersionUID = -3523880675037507039L;
    public static final int TYPE_NORMAL = 1;
    public static final int TYPE_WARNING = 2;
    public static final int TYPE_ERROR = 3;
    public static final int TYPE_CRITICALERROR = 4;
    private String message;
    private Throwable throwable;
    private String throwableTrace;
    private int type;
    private long time;

    public LogEvent(String message) {
        this(message, null);
    }

    public LogEvent(String message, Throwable throwable) {
        this(message, throwable, throwable == null ? 1 : 3, System.currentTimeMillis());
    }

    public LogEvent(String message, Throwable throwable, int type, long time) {
        this.message = message;
        this.throwable = throwable;
        this.type = type;
        this.time = time;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public int getType() {
        if (this.type < 1) {
            return this.throwable == null ? 1 : 3;
        }
        return this.type;
    }

    public long getTime() {
        return this.time;
    }

    public String getThrowableTrace() {
        if (this.throwableTrace != null) {
            return this.throwableTrace;
        }
        if (this.throwable == null) {
            return null;
        }
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        this.throwable.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        return new String(writer.toCharArray());
    }

    public LogEvent getSerializableVersion() {
        LogEvent serializable = new LogEvent(this.message);
        serializable.type = this.type;
        serializable.time = this.time;
        serializable.throwableTrace = this.getThrowableTrace();
        return serializable;
    }
}

