/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.OC4JPropertyPlaceholder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OC4JPropertiesGenerator {
    protected String xmlFile = "properties.xml";
    protected String oc4jPropertiesTemplateFile = "OC4JProperties.template";
    protected String oc4jPropertiesFile = "OC4JProperties";
    protected String propertyTemplateFile = "Properties.template";
    protected String templateResourceBundleFile = "OC4JPropertiesResource.template";
    protected String generatedResourceBundleFile = "OC4JPropertiesResource";
    protected ArrayList properties;
    protected ArrayList componentCategories;
    protected String homePath = "." + File.separator;
    private FileWriter writer;
    private String indent = "";
    private boolean indentUsed = false;
    private static byte[] sFileBuffer;

    public static void main(String[] args) throws Exception {
        OC4JPropertiesGenerator propGen = new OC4JPropertiesGenerator();
        for (int i = 0; i < args.length; i += 2) {
            if (!args[i].equalsIgnoreCase("-generatedPath")) continue;
            propGen.homePath = args[i + 1];
        }
        propGen.generateProperties();
    }

    public OC4JPropertiesGenerator() {
        this.properties = new ArrayList();
    }

    public void generateProperties() throws Exception {
        this.parseXML();
        this.createComponentCategoriesList();
        Iterator iterator = this.componentCategories.iterator();
        while (iterator.hasNext()) {
            String category = (String)iterator.next();
            ArrayList currentProperties = this.getSimilarProperties(category);
            this.createFile(this.homePath, this.homePath, this.propertyTemplateFile, category + "Properties", currentProperties);
        }
        this.createFile(this.homePath, this.homePath, this.oc4jPropertiesTemplateFile, this.oc4jPropertiesFile, null);
        this.createFile(this.homePath, this.homePath, this.templateResourceBundleFile, this.generatedResourceBundleFile, null);
    }

    private void createComponentCategoriesList() {
        this.componentCategories = new ArrayList();
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            OC4JPropertyPlaceholder propInfo = (OC4JPropertyPlaceholder)iterator.next();
            if (this.componentCategories.indexOf(propInfo.getComponent()) >= 0) continue;
            this.componentCategories.add(propInfo.getComponent());
        }
    }

    protected ArrayList getSimilarProperties(String componentCategory) {
        ArrayList<OC4JPropertyPlaceholder> simProps = new ArrayList<OC4JPropertyPlaceholder>();
        Iterator it = this.properties.iterator();
        while (it.hasNext()) {
            OC4JPropertyPlaceholder prop = (OC4JPropertyPlaceholder)it.next();
            if (!prop.getComponent().equalsIgnoreCase(componentCategory)) continue;
            simProps.add(prop);
        }
        return simProps;
    }

    public void parseXML() {
        File xml = new File(this.homePath + this.xmlFile);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xml);
            NodeList children = doc.getChildNodes();
            this.traverse(children.item(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void traverse(Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            node = childNodes.item(i);
            short type = node.getNodeType();
            if (type != 1 || !node.getNodeName().equals("property")) continue;
            this.parsePropertyNode(node);
        }
    }

    protected void parsePropertyNode(Node propertyNode) {
        OC4JPropertyPlaceholder property = new OC4JPropertyPlaceholder();
        NamedNodeMap attributes = propertyNode.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            String attributeName = node.getNodeName();
            if (attributeName.equalsIgnoreCase("name")) {
                property.setName(node.getNodeValue());
                continue;
            }
            if (attributeName.equalsIgnoreCase("default-value")) {
                property.setDefaultValue(node.getNodeValue());
                continue;
            }
            if (attributeName.equalsIgnoreCase("immutable")) {
                property.setImmutable(this.getBool(node.getNodeValue()));
                continue;
            }
            if (attributeName.equalsIgnoreCase("component-category")) {
                property.setComponent(node.getNodeValue());
                continue;
            }
            if (attributeName.equalsIgnoreCase("primitive-type")) {
                property.setPrimitiveType(node.getNodeValue());
                continue;
            }
            if (attributeName.equalsIgnoreCase("method-name")) {
                property.setMethodName(node.getNodeValue());
                continue;
            }
            if (attributeName.equalsIgnoreCase("internal")) {
                property.setInternal(this.getBool(node.getNodeValue()));
                continue;
            }
            if (attributeName.equalsIgnoreCase("deprecated")) {
                property.setDeprecated(this.getBool(node.getNodeValue()));
                continue;
            }
            if (!attributeName.equalsIgnoreCase("log-value-change")) continue;
            property.setLogValueChange(this.getBool(node.getNodeValue()));
        }
        NodeList childNodes = propertyNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!node.getNodeName().equals("description")) continue;
            property.setDescription(node.getFirstChild().getNodeValue());
        }
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            OC4JPropertyPlaceholder existingProp = (OC4JPropertyPlaceholder)iterator.next();
            if (!property.getName().equalsIgnoreCase(existingProp.getName())) continue;
            System.out.println("Duplicate property entry: " + property.getName());
            System.out.println("Process aborted.");
            System.exit(0);
        }
        this.properties.add(property);
    }

    private String getComponentConstant(String nodeValue) {
        if (nodeValue.equalsIgnoreCase("Datasources")) {
            return "OC4JProperty.fDatasources";
        }
        if (nodeValue.equalsIgnoreCase("DB")) {
            return "OC4JProperty.fDB";
        }
        if (nodeValue.equalsIgnoreCase("EJB")) {
            return "OC4JProperty.fEJB";
        }
        if (nodeValue.equalsIgnoreCase("Compiler")) {
            return "OC4JProperty.fCompiler";
        }
        if (nodeValue.equalsIgnoreCase("JCA")) {
            return "OC4JProperty.fJCA";
        }
        if (nodeValue.equalsIgnoreCase("JDBC")) {
            return "OC4JProperty.fJDBC";
        }
        if (nodeValue.equalsIgnoreCase("JMX")) {
            return "OC4JProperty.fJMX";
        }
        if (nodeValue.equalsIgnoreCase("JMS")) {
            return "OC4JProperty.fJMS";
        }
        if (nodeValue.equalsIgnoreCase("JNDI")) {
            return "OC4JProperty.fJNDI";
        }
        if (nodeValue.equalsIgnoreCase("JSP")) {
            return "OC4JProperty.fJSP";
        }
        if (nodeValue.equalsIgnoreCase("HTTP")) {
            return "OC4JProperty.fHTTP";
        }
        if (nodeValue.equalsIgnoreCase("OC4JRuntime")) {
            return "OC4JProperty.fOC4JRuntime";
        }
        if (nodeValue.equalsIgnoreCase("ORB")) {
            return "OC4JProperty.fORB";
        }
        if (nodeValue.equalsIgnoreCase("Servlet")) {
            return "OC4JProperty.fServlet";
        }
        if (nodeValue.equalsIgnoreCase("Server")) {
            return "OC4JProperty.fServer";
        }
        if (nodeValue.equalsIgnoreCase("Security")) {
            return "OC4JProperty.fSecurity";
        }
        if (nodeValue.equalsIgnoreCase("Services")) {
            return "OC4JProperty.fServices";
        }
        if (nodeValue.equalsIgnoreCase("WebServices")) {
            return "OC4JProperty.fWebServices";
        }
        if (nodeValue.equalsIgnoreCase("IIOP")) {
            return "OC4JProperty.fIIOP";
        }
        if (nodeValue.equalsIgnoreCase("RMI")) {
            return "OC4JProperty.fRMI";
        }
        return "OC4JProperty.fUnknown";
    }

    protected void createFile(String templateFilePath, String generatedFilePath, String templateFile, String oc4jFile, ArrayList currentProperties) throws FileNotFoundException, IOException {
        int i;
        String fileName = generatedFilePath + oc4jFile;
        this.writer = new FileWriter(fileName + ".temp", false);
        FileReader templateReader = new FileReader(templateFilePath + templateFile);
        String currentWord = "";
        while ((i = templateReader.read()) != -1) {
            char c = (char)i;
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                if (currentWord.equals("<description>")) {
                    this.generateDescription(this.writer);
                } else if (currentWord.equals("<oc4j-property-declarations>")) {
                    this.generateCachedOC4JProperties(this.writer);
                } else if (currentWord.equals("<class-name>")) {
                    this.writer.write(oc4jFile + " ");
                } else if (currentWord.equals("<create-property-hashtable>")) {
                    this.generatePropertyHashtable(this.writer);
                } else if (currentWord.equals("<init-properties>")) {
                    this.generateInitProperties(this.writer);
                } else if (currentWord.equals("<property-methods>")) {
                    this.generatePropertyMethods(this.writer, currentProperties);
                } else {
                    if (c == ' ' || c == '\t') {
                        this.indent = this.indent.concat(Character.toString(c));
                        this.indentUsed = false;
                    } else {
                        this.indent = "";
                    }
                    currentWord = currentWord.concat(Character.toString(c));
                    this.writer.write(currentWord);
                }
                currentWord = "";
                continue;
            }
            currentWord = currentWord.concat(Character.toString(c));
        }
        this.writer.close();
        this.compareToOriginal(fileName + ".temp", fileName + ".java");
    }

    public void compareToOriginal(String tempFilePath, String javaFilePath) throws FileNotFoundException, IOException {
        Object tempFile;
        boolean newFileExists = true;
        boolean identical = true;
        FileReader javaFile = null;
        try {
            javaFile = new FileReader(javaFilePath);
        }
        catch (FileNotFoundException e) {
            newFileExists = false;
            identical = false;
        }
        if (newFileExists) {
            int i;
            tempFile = new FileReader(tempFilePath);
            while ((i = ((InputStreamReader)tempFile).read()) != -1) {
                if (javaFile.read() == i) continue;
                identical = false;
                break;
            }
            javaFile.close();
            ((InputStreamReader)tempFile).close();
        }
        if (!identical) {
            this.copyFile(tempFilePath, javaFilePath);
        } else {
            System.out.println("Not overwriting unchanged file: " + javaFilePath);
        }
        tempFile = new File(tempFilePath);
        ((File)tempFile).delete();
    }

    private void copyFile(String tempFilePath, String javaFilePath) throws IOException {
        if (sFileBuffer == null) {
            sFileBuffer = new byte[16384];
        }
        File oldFile = new File(tempFilePath);
        File newFile = new File(javaFilePath);
        if (newFile.createNewFile()) {
            System.out.println("Need to ade mkelem file: " + javaFilePath);
            newFile.delete();
            oldFile.delete();
            System.exit(0);
        }
        if (!newFile.canWrite()) {
            System.out.println("ERROR - file: " + javaFilePath + " is not writable. You must check out this file");
            System.out.println("Operation ended prematurely");
            System.exit(0);
            return;
        }
        FileInputStream fIn = new FileInputStream(oldFile);
        FileOutputStream fOut = new FileOutputStream(newFile);
        int bytesRead = 0;
        while ((bytesRead = fIn.read(sFileBuffer)) > 0) {
            fOut.write(sFileBuffer, 0, bytesRead);
        }
        fOut.flush();
        fIn.close();
        fOut.close();
    }

    protected void generateCachedOC4JProperties(FileWriter writer) throws IOException {
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            OC4JPropertyPlaceholder propData = (OC4JPropertyPlaceholder)iterator.next();
            this.writeln("protected static final OC4JProperty " + propData.getFieldName() + " = new OC4JProperty(\"" + propData.getName() + "\", \"" + propData.getDefaultValue() + "\", " + "System.getProperty(\"" + propData.getName() + "\"), " + propData.getPrimitiveTypeAsConstant() + ", " + this.getComponentConstant(propData.getComponent()) + ", " + propData.isImmutable() + ");");
        }
    }

    protected void generatePropertyHashtable(FileWriter writer) throws IOException {
        this.writeln("properties = new Hashtable(" + this.properties.size() + ");");
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            OC4JPropertyPlaceholder propData = (OC4JPropertyPlaceholder)iterator.next();
            this.writeln("properties.put(\"" + propData.getName() + "\", " + propData.getFieldName() + ");");
        }
    }

    protected void generateInitProperties(FileWriter writer) throws IOException {
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            boolean writeHeader;
            OC4JPropertyPlaceholder propData = (OC4JPropertyPlaceholder)iterator.next();
            boolean bl = writeHeader = propData.isInternal() || propData.isDeprecated() || propData.logValueChange();
            if (writeHeader) {
                this.writeln("/* initializing property " + propData.getName() + " */");
            }
            if (propData.isInternal()) {
                this.writeln(propData.getFieldName() + ".setInternal(" + propData.isInternal() + ");");
            }
            if (propData.isDeprecated()) {
                this.writeln(propData.getFieldName() + ".setDeprecated(" + propData.isDeprecated() + ");");
            }
            if (propData.logValueChange()) {
                this.writeln(propData.getFieldName() + ".logValueChange(" + propData.logValueChange() + ");");
            }
            if (!writeHeader) continue;
            this.writeln("");
        }
    }

    protected void generatePropertyMethods(FileWriter writer, ArrayList properties) throws IOException {
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            OC4JPropertyPlaceholder propData = (OC4JPropertyPlaceholder)iterator.next();
            String javaType = propData.getPrimtiveTypeAsJavaPrimitive();
            if (propData.isImmutable()) {
                this.writeln("// generated getter method for " + propData.getName());
            } else {
                this.writeln("// generated getter and setter method for " + propData.getName());
            }
            this.writeln("// " + propData.getDescription());
            this.writeln("public static " + javaType + " get" + propData.getMethodName() + "() {");
            this.writeln("\treturn OC4JProperties." + propData.getFieldName() + ".get" + propData.getPrimitiveType() + "Value();");
            this.writeln("}");
            this.writeln("");
            if (propData.isImmutable()) continue;
            String arg = "a" + propData.getFieldName();
            this.writeln("public static void set" + propData.getMethodName() + "(" + javaType + " " + arg + ") {");
            this.writeln("\tSystem.setProperty(OC4JProperties." + propData.getFieldName() + ".getName(), String.valueOf(" + arg + "));");
            this.writeln("}");
            this.writeln("");
        }
    }

    protected void generateDescription(FileWriter writer) throws IOException {
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            OC4JPropertyPlaceholder propData = (OC4JPropertyPlaceholder)iterator.next();
            this.write("{ \"" + propData.getName() + "\", \"" + propData.getDescription() + "\" }");
            if (!iterator.hasNext()) continue;
            this.writeln(",");
        }
    }

    private void writeln(String line) throws IOException {
        if (!this.indentUsed) {
            this.indentUsed = true;
        } else {
            this.writer.write(this.indent);
        }
        this.writer.write(line + "\n");
    }

    private void write(String line) throws IOException {
        if (!this.indentUsed) {
            this.indentUsed = true;
        } else {
            this.writer.write(this.indent);
        }
        this.writer.write(line);
        this.indentUsed = false;
    }

    protected boolean getBool(String str) {
        return Boolean.valueOf(str);
    }
}

