/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import java.util.StringTokenizer;

public class OC4JPropertyPlaceholder {
    protected String name;
    protected String description;
    protected String defaultValue;
    protected String value;
    protected String primitiveType = "String";
    protected String fieldName = null;
    protected String methodName = null;
    protected String component = "Unknown";
    protected boolean isImmutable = true;
    protected boolean logValueChange = false;
    protected boolean isDeprecated = false;
    protected boolean isInternal = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.fieldName == null) {
            String fieldName = name.replace('.', '_');
            fieldName = fieldName.toUpperCase();
            this.setFieldName(fieldName);
        }
        if (this.methodName == null) {
            String methodName = "";
            StringTokenizer st = new StringTokenizer(name, ".");
            while (st.hasMoreElements()) {
                String component = (String)st.nextElement();
                String firstLetter = component.substring(0, 1).toUpperCase();
                String restOfWord = component.substring(1);
                component = firstLetter + restOfWord;
                methodName = methodName + component;
            }
            this.setMethodName(methodName);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        if (defaultValue.equals("null")) {
            defaultValue = null;
        }
        this.defaultValue = defaultValue;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public void setImmutable(boolean immutable) {
        this.isImmutable = immutable;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getPrimitiveType() {
        return this.primitiveType;
    }

    public String getPrimtiveTypeAsJavaPrimitive() {
        if (this.primitiveType == "Int") {
            return "int";
        }
        if (this.primitiveType == "String") {
            return "String";
        }
        return this.primitiveType.toLowerCase();
    }

    public String getPrimitiveTypeAsConstant() {
        if (this.primitiveType == "Boolean") {
            return "OC4JProperty.fBooleanType";
        }
        if (this.primitiveType == "Double") {
            return "OC4JProperty.fDoubleType";
        }
        if (this.primitiveType == "Long") {
            return "OC4JProperty.fLongType";
        }
        if (this.primitiveType == "Int") {
            return "OC4JProperty.fIntegerType";
        }
        if (this.primitiveType == "String") {
            return "OC4JProperty.fStringType";
        }
        throw new RuntimeException("Unknown primitiveType: " + this.primitiveType);
    }

    public void setPrimitiveType(String primitiveType) {
        if (primitiveType.equalsIgnoreCase("Boolean")) {
            this.primitiveType = "Boolean";
        } else if (primitiveType.equalsIgnoreCase("Double")) {
            this.primitiveType = "Double";
        } else if (primitiveType.equalsIgnoreCase("Long")) {
            this.primitiveType = "Long";
        } else if (primitiveType.equalsIgnoreCase("Integer")) {
            this.primitiveType = "Int";
        } else if (primitiveType.equalsIgnoreCase("String")) {
            this.primitiveType = "String";
        } else {
            throw new RuntimeException("Unknown primitiveType: " + primitiveType);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean logValueChange() {
        return this.logValueChange;
    }

    public void setLogValueChange(boolean logValueChange) {
        this.logValueChange = logValueChange;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.isDeprecated = deprecated;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public void setInternal(boolean internal) {
        this.isInternal = internal;
    }
}

