/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.server.cluster.ServerIdentification;
import com.evermind.util.OC4JRuntimeProperties;
import com.evermind.util.OpmnException;
import com.evermind.util.RMIProperties;
import com.evermind.util.ServerProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.opmn.optic.IasApplication;
import oracle.ias.opmn.optic.OpmnConn;
import oracle.ias.opmn.optic.OpmnHostPort;
import oracle.ias.opmn.optic.OpmnProcess;
import oracle.ias.opmn.optic.OpmnQuery;
import oracle.ias.opmn.optic.OpticException;
import oracle.j2ee.clustering.ClusteringMessages;
import oracle.j2ee.util.TraceLogger;

public class OpmnHelper {
    public static final String RMI_CONN_TYPE = "rmi";
    public static final String RMIS_CONN_TYPE = "rmis";
    public static final String IIOP_CONN_TYPE = "iiop";
    public static final String AJP_CONN_TYPE = "ajp";
    private static final String ORACLE_HOME = OC4JRuntimeProperties.getOracleHome();
    private static final String _query = "/dump?type=dms&dmsarg=[nountype=opmn_ias_instance&format=xml]";
    private static Logger m_logger = TraceLogger.getLogger(OpmnHelper.class);
    private static final OpmnHelperInternal OPMN_INTERNAL_SINGLETON = new OpmnHelperInternal(new StandardOpmnAccess());

    private static OpmnHelperInternal getInstance() {
        return OPMN_INTERNAL_SINGLETON;
    }

    public static synchronized ServerIdentification[] getOc4jServers(String opmnHost, int opmnPort, String oc4jInstanceName, String connectionType, String applicationName) {
        return OpmnHelper.getInstance().getOc4jServers(opmnHost, opmnPort, oc4jInstanceName, connectionType, applicationName);
    }

    public static int getOrmiPortForOc4jProcess(String processId) throws OpmnException {
        return OpmnHelper.getInstance().getOrmiPortForOc4jProcess(processId);
    }

    public static int getOrmisPortForOc4jProcess(String processId) throws OpmnException {
        return OpmnHelper.getInstance().getOrmisPortForOc4jProcess(processId);
    }

    public static OpmnProcess getOc4jProcess(String processId) throws OpmnException {
        return OpmnHelper.getInstance().getOc4jProcess(processId);
    }

    public static void stopOc4j(String uid) throws OpmnException {
        OpmnHelper.getInstance().stopOc4j(uid);
    }

    private static class StandardOpmnAccess
    implements OpmnAccess {
        private StandardOpmnAccess() {
        }

        public List getProcessList(String opmnHost, int opmnPort, String query) throws OpticException {
            return OpmnQuery.getProc((String)opmnHost, (int)opmnPort, (String)query);
        }

        public List getProcessList(String opmnHost, String query) throws OpticException {
            return OpmnQuery.getProc((String)opmnHost, (String)query);
        }
    }

    static interface OpmnAccess {
        public List getProcessList(String var1, int var2, String var3) throws OpticException;

        public List getProcessList(String var1, String var2) throws OpticException;
    }

    static class OpmnHelperInternal {
        private final OpmnAccess m_opmnAccess;

        protected OpmnHelperInternal(OpmnAccess opmnAccess) {
            this.m_opmnAccess = opmnAccess;
        }

        public synchronized ServerIdentification[] getOc4jServers(String opmnHost, int opmnPort, String oc4jInstanceName, String connectionType, String applicationName) {
            ArrayList<ServerIdentification> list = new ArrayList<ServerIdentification>();
            try {
                List procList = this.m_opmnAccess.getProcessList(opmnHost, opmnPort, OpmnHelper._query);
                for (int i = 0; i < procList.size(); ++i) {
                    OpmnProcess p = (OpmnProcess)procList.get(i);
                    if (ServerProperties.getOpmnQueryDebug()) {
                        m_logger.log(Level.INFO, "OpmnProcess[" + i + "]: " + p);
                    }
                    if (p.getType().equalsIgnoreCase("OC4J") && p.getStatus().equalsIgnoreCase("Alive") && p.getProcessTypeName().equalsIgnoreCase(oc4jInstanceName) && OpmnHelperInternal.OpmnProcContainsApplication(applicationName, p.getAppList())) {
                        List portList = p.getConnList();
                        for (int j = 0; j < portList.size(); ++j) {
                            OpmnConn oc = (OpmnConn)portList.get(j);
                            if (!oc.getType().equalsIgnoreCase(connectionType)) continue;
                            list.add(new ServerIdentification(oc.getHost(), Integer.parseInt(oc.getPort()), -1L));
                        }
                        continue;
                    }
                    if (!p.getType().equalsIgnoreCase("OC4J") || !p.getStatus().equalsIgnoreCase("Init") || !p.getProcessTypeName().equalsIgnoreCase(oc4jInstanceName) || !OpmnHelperInternal.OpmnProcContainsApplication(applicationName, p.getAppList()) || !ServerProperties.getRunningInIAS() || !ServerProperties.getOracleOc4jInstanceName().equalsIgnoreCase(oc4jInstanceName) || !p.getUid().equalsIgnoreCase(ServerProperties.getOracleOnsUID()) || !p.getIasInstanceName().equalsIgnoreCase(ServerProperties.getOracleOnsInstanceName())) continue;
                    if (connectionType.equalsIgnoreCase(OpmnHelper.RMI_CONN_TYPE)) {
                        list.add(new ServerIdentification(opmnHost, RMIProperties.getPortRmi(), -1L));
                    }
                    if (!connectionType.equalsIgnoreCase(OpmnHelper.RMIS_CONN_TYPE)) continue;
                    list.add(new ServerIdentification(opmnHost, RMIProperties.getPortRmis(), -1L));
                }
            }
            catch (OpticException oe) {
                ClusteringMessages.warningInOpmnGetServers(opmnHost, opmnPort, oe);
            }
            return list.toArray(new ServerIdentification[list.size()]);
        }

        public int getOrmiPortForOc4jProcess(String processId) throws OpmnException {
            return this.getOrmiPortForProcess(this.getOc4jProcess(processId));
        }

        public int getOrmisPortForOc4jProcess(String processId) throws OpmnException {
            return this.getOrmisPortForProcess(this.getOc4jProcess(processId));
        }

        public OpmnProcess getOc4jProcess(String processId) throws OpmnException {
            try {
                List procList = this.m_opmnAccess.getProcessList(ORACLE_HOME, OpmnHelper._query);
                if (procList == null) {
                    throw new OpmnException("Candidate process list is null");
                }
                return this.getOpmnProcessForProcessid(procList, processId);
            }
            catch (OpticException e) {
                throw new OpmnException("Unable to obtain OC4J process for id: " + processId + " due to an exception", (Exception)((Object)e));
            }
        }

        OpmnProcess getOpmnProcessForProcessid(List procList, String processId) throws OpmnException {
            for (int procIndx = 0; procIndx < procList.size(); ++procIndx) {
                OpmnProcess proc = (OpmnProcess)procList.get(procIndx);
                if (!proc.getType().equalsIgnoreCase("OC4J")) continue;
                processId = processId.replaceFirst(proc.getProcessTypeName(), "");
                processId = processId.replaceFirst(".", "");
                processId = processId.replaceFirst(proc.getProcessSetName(), "");
                processId = processId.replaceFirst(".", "");
                if (!proc.getIndexInSet().equals(processId)) continue;
                return proc;
            }
            throw new OpmnException("No matching process");
        }

        public void stopOc4j(String uid) throws OpmnException {
            if (uid == null) {
                throw new OpmnException("Unable to stop OC4J. NULL uid");
            }
            try {
                OpmnQuery oq = new OpmnQuery(null, 0, OpmnHostPort.LOCAL, System.getProperty("oracle.ons.oraclehome"));
                oq.getBuf("/stop?mode=async&uniqueid=" + uid);
            }
            catch (Exception e) {
                throw new OpmnException("Unable to stop OC4J", e);
            }
        }

        private int getOrmiPortForProcess(OpmnProcess proc) throws OpmnException {
            List ports = proc.getConnList();
            for (int portIndx = 0; portIndx < ports.size(); ++portIndx) {
                OpmnConn oc = (OpmnConn)ports.get(portIndx);
                if (!OpmnHelper.RMI_CONN_TYPE.equalsIgnoreCase(oc.getType())) continue;
                return Integer.parseInt(oc.getPort());
            }
            throw new OpmnException("Unable to obtain ORMI port for OC4J process: " + proc);
        }

        private int getOrmisPortForProcess(OpmnProcess proc) throws OpmnException {
            List ports = proc.getConnList();
            for (int portIndx = 0; portIndx < ports.size(); ++portIndx) {
                OpmnConn oc = (OpmnConn)ports.get(portIndx);
                if (!OpmnHelper.RMIS_CONN_TYPE.equalsIgnoreCase(oc.getType())) continue;
                return Integer.parseInt(oc.getPort());
            }
            throw new OpmnException("Unable to obtain ORMIS port for OC4J process: " + proc);
        }

        private static boolean OpmnProcContainsApplication(String applicationName, List applications) {
            if (applicationName == null || applicationName.equalsIgnoreCase("") || applications.isEmpty()) {
                return true;
            }
            for (int i = 0; i < applications.size(); ++i) {
                IasApplication iasApplication = (IasApplication)applications.get(i);
                if (!applicationName.equalsIgnoreCase(iasApplication.getName())) continue;
                return true;
            }
            return false;
        }
    }
}

