/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.evermind.util.ThreadPoolFactory;
import oracle.oc4j.util.TaskLauncher;

public class ThreadPool
implements TaskLauncher {
    int nrOfFreeThreads;
    protected boolean alive = false;
    int threadID;
    private PooledExecutor _pool = null;
    private BoundedChannel _queue = null;
    private ThreadPoolFactory _threadPoolFactory = null;
    private int _minPoolSize = 20;
    private int _maxPoolSize = 40;
    private int _maxQueueSize = 80;
    private long _keepAliveTime = 600000L;
    private ThreadGroup _threadGroup = null;
    ClassLoader _classLoader;
    protected boolean _daemon = true;
    protected boolean _debug = false;
    private long _threadStackSize = 0L;

    public ThreadPool(ThreadGroup group, boolean daemon) {
        this._threadGroup = group;
        this._daemon = daemon;
        this._classLoader = Thread.currentThread().getContextClassLoader();
    }

    public void init() {
        this.initThreaded();
    }

    protected void initPooled() {
        PooledExecutor pool = null;
        if (this._maxQueueSize > 0) {
            this._queue = new BoundedBuffer(this._maxQueueSize);
            pool = this.newPooledExecutor(this._queue, this._maxPoolSize);
        } else {
            pool = this.newPooledExecutor(this._maxPoolSize);
        }
        pool.setMinimumPoolSize(this._minPoolSize);
        pool.setKeepAliveTime(this._keepAliveTime);
        pool.waitWhenBlocked();
        if (this._threadPoolFactory == null) {
            this._threadPoolFactory = new ThreadPoolFactory(this, this._daemon);
        }
        pool.setThreadFactory(this._threadPoolFactory);
        pool.createThreads(this._minPoolSize);
        this._pool = pool;
        this.alive = true;
    }

    protected PooledExecutor newPooledExecutor(Channel queue, int maxPoolSize) {
        return new PooledExecutor(queue, maxPoolSize);
    }

    protected PooledExecutor newPooledExecutor(int maxPoolSize) {
        return new PooledExecutor(maxPoolSize);
    }

    protected PooledExecutor newPooledExecutor() {
        return new PooledExecutor();
    }

    protected void initThreaded() {
        PooledExecutor pool = this.newPooledExecutor();
        if (this._threadPoolFactory == null) {
            this._threadPoolFactory = new ThreadPoolFactory(this, this._daemon);
        }
        pool.setThreadFactory(this._threadPoolFactory);
        this._pool = pool;
        this._maxPoolSize = this._pool.getMaximumPoolSize();
        this._minPoolSize = this._pool.getMinimumPoolSize();
        this._keepAliveTime = this._pool.getKeepAliveTime();
        this._maxQueueSize = 0;
        this.alive = true;
    }

    public ThreadGroup getThreadGroup() {
        return this._threadGroup;
    }

    public ThreadPoolFactory getThreadPoolFactory() {
        return this._threadPoolFactory;
    }

    public int getMinPoolSize() {
        return this._minPoolSize;
    }

    public int getMaxPoolSize() {
        return this._maxPoolSize;
    }

    public long getKeepAliveTime() {
        return this._keepAliveTime;
    }

    public long getThreadStackSize() {
        return this._threadStackSize;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public int getPoolSize() {
        int size = this._pool.getPoolSize();
        return size;
    }

    public int getQueueSize() {
        int size = 0;
        if (this._queue != null && this._queue instanceof BoundedBuffer) {
            size = ((BoundedBuffer)this._queue).size();
        }
        return size;
    }

    public int getQueueCapacity() {
        if (this._queue != null) {
            return this._maxQueueSize;
        }
        return 0;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void launch(Runnable target) {
        try {
            this._pool.execute(target);
        }
        catch (InterruptedException e) {
            System.err.println("launch InterruptedException " + e);
        }
    }

    public void setThreadGroup(ThreadGroup group) {
        this._threadGroup = group;
    }

    public void setThreadPoolFactory(ThreadPoolFactory factory) {
        this._threadPoolFactory = factory;
    }

    public synchronized void destroy() {
        this.alive = false;
        if (this._pool != null) {
            this._pool.shutdownNow();
        }
    }

    public void setDebug(boolean _debug) {
        this._debug = _debug;
        this.setDebugConfig(_debug);
    }

    public void setDebugConfig(boolean d) {
    }

    public void setPoolSize(int min, int max) {
        this._minPoolSize = min;
        this._maxPoolSize = max;
        if (this._pool != null) {
            this._pool.setMinimumPoolSize(this._minPoolSize);
            this._pool.setMaximumPoolSize(this._maxPoolSize);
        }
    }

    public void setMinPoolSize(int size) {
        if (this._maxPoolSize < size) {
            this.setMaxPoolSize(size);
        }
        this._minPoolSize = size;
        if (this._pool != null) {
            this._pool.setMinimumPoolSize(this._minPoolSize);
        }
        this.setMinPoolSizeConfig(size);
    }

    public void setMinPoolSizeConfig(int size) {
    }

    public void setMaxPoolSize(int size) {
        if (this._minPoolSize > size) {
            this.setMinPoolSize(size);
        }
        this._maxPoolSize = size;
        if (this._pool != null) {
            this._pool.setMaximumPoolSize(this._maxPoolSize);
        }
        this.setMaxPoolSizeConfig(size);
    }

    public void setMaxPoolSizeConfig(int size) {
    }

    public void setKeepAliveTime(long timeInMs) {
        this._keepAliveTime = timeInMs;
        if (this._pool != null) {
            this._pool.setKeepAliveTime(this._keepAliveTime);
        }
        this.setKeepAliveTimeConfig(timeInMs);
    }

    public void setKeepAliveTimeConfig(long timeInMs) {
    }

    public void setQueueSize(int size) {
        this._maxQueueSize = size;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    protected PooledExecutor getPool() {
        return this._pool;
    }

    public void print() {
        if (this._debug) {
            System.out.println("Application Min Pool Size          : " + this._minPoolSize);
            System.out.println("Application Max Pool Size          : " + this._maxPoolSize);
            System.out.println("Application Queue Size             : " + this._maxQueueSize);
            System.out.println("Application Thread Keep Alive Time : " + this._keepAliveTime);
        }
        System.out.println("Pool Size                          : " + this.getPoolSize());
        System.out.println("Queue Size                         : " + this.getQueueSize());
    }

    public void printShort() {
        System.out.println(System.currentTimeMillis() + ": TPool - P[" + this.getPoolSize() + "] - Q[" + this.getQueueSize() + "]");
    }

    public void setStackSize(long threadStackSize) {
        this._threadStackSize = threadStackSize;
    }
}

