/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jgroups;

import com.oracle.jgroups.InterruptableTestAndWaitLock;
import com.oracle.jgroups.ObjectMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.GetStateEvent;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.SetStateEvent;
import org.jgroups.SuspectEvent;
import org.jgroups.TimeoutException;
import org.jgroups.View;

public class ChannelAdapter {
    protected volatile List members = new ArrayList();
    private MembershipListener primaryMembershipListener;
    private MessageListener primaryMessageListener;
    private List m_listOfMessageListeners = new LinkedList();
    private final Channel channel;
    private final InterruptableTestAndWaitLock blockOutbound = new InterruptableTestAndWaitLock("adapter block");
    private final InterruptableTestAndWaitLock pause = new InterruptableTestAndWaitLock("adapter pause messages");
    private volatile boolean pauseMessages = false;
    private final List queuedMessages = new ArrayList();
    private Thread thread;
    protected ObjectMarshaller marshaller;
    private static Logger m_logger = TraceLogger.getLogger(ChannelAdapter.class);
    private Integer syncObj = new Integer(1);
    private boolean receiverThreadReady = false;

    public ChannelAdapter(Channel channel, ObjectMarshaller marshaller) {
        this.channel = channel;
        this.marshaller = marshaller;
    }

    public ChannelAdapter(Channel channel, ObjectMarshaller marshaller, MembershipListener membershipListener, MessageListener messageListener) {
        this(channel, marshaller);
        this.primaryMembershipListener = membershipListener;
        this.primaryMessageListener = messageListener;
    }

    public void addListener(MessageListener listener) {
        this.m_listOfMessageListeners.add(listener);
    }

    public void removeListener(MessageListener listener) {
        this.m_listOfMessageListeners.remove(listener);
    }

    public int getNumOfListeners() {
        return this.m_listOfMessageListeners.size();
    }

    public ObjectMarshaller getMarshaller() {
        return this.marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String group, boolean getState, int stateTimeout) throws ChannelException {
        if (this.isStarted()) {
            return;
        }
        this.thread = new Thread(this.executor(), "ChannelAdapter for " + group);
        this.thread.setDaemon(true);
        this.thread.start();
        while (!this.receiverThreadReady) {
            Integer n = this.syncObj;
            synchronized (n) {
                try {
                    this.syncObj.wait(10L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "connecting to " + group);
        }
        try {
            View initialView;
            if (!this.channel.isOpen()) {
                this.channel.open();
            }
            if (!this.channel.isConnected()) {
                this.channel.connect(group);
            }
            if (getState) {
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "retrieving state for " + group);
                }
                this.channel.getState(null, (long)stateTimeout);
            }
            if ((initialView = this.getView()) != null) {
                this.members = initialView.getMembers();
            }
        }
        catch (ChannelException e) {
            this.stop();
            throw e;
        }
    }

    public boolean isStarted() {
        return this.thread != null;
    }

    public View getView() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Not connected");
        }
        return this.channel.getView();
    }

    public Address getLocalAddress() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Not connected");
        }
        return this.channel.getLocalAddress();
    }

    public void pause() throws InterruptedException {
        this.pause.freeze();
    }

    public void resume() {
        this.pause.thaw();
    }

    public void pauseInbound() {
        this.pauseMessages = true;
    }

    public void resumeInbound() {
        this.pauseMessages = false;
    }

    public void pauseOutbound() throws InterruptedException {
        this.blockOutbound.freeze();
    }

    public void resumeOutbound() {
        this.blockOutbound.thaw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        block10: {
            if (!this.isStarted()) {
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "adapter already stopped");
                }
                return;
            }
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "stopping");
            }
            try {
                this.pause();
                try {
                    if (m_logger.isLoggable(Level.FINEST)) {
                        m_logger.log(Level.FINEST, "interrupting all blocked threads");
                    }
                    this.thread.interrupt();
                    this.blockOutbound.interrupt();
                    this.pause.interrupt();
                    this.channel.close();
                    this.thread = null;
                    if (m_logger.isLoggable(Level.FINEST)) {
                        m_logger.log(Level.FINEST, "stopped");
                    }
                }
                finally {
                    this.resume();
                }
            }
            catch (InterruptedException ex) {
                if (!m_logger.isLoggable(Level.FINEST)) break block10;
                m_logger.log(Level.FINEST, "Sync Error pausing channel adapter", ex);
            }
        }
    }

    public void send(Address dst, ObjectMarshaller.Marshalled obj) throws ChannelNotConnectedException, ChannelClosedException {
        block5: {
            if (!this.isStarted()) {
                throw new IllegalStateException("Not connected");
            }
            if (dst != null && !this.members.contains(dst)) {
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "discarding message to non member: " + dst);
                }
                return;
            }
            try {
                Message message = new Message();
                message.setDest(dst);
                message.setBuffer(this.marshaller.marshalledToBytes(obj));
                this.channel.send(message);
            }
            catch (Exception e) {
                if (!m_logger.isLoggable(Level.FINEST)) break block5;
                m_logger.log(Level.FINEST, "Exception marshalling message in send", e);
            }
        }
    }

    public void send(Address dst, Serializable serializedMessage) throws ChannelNotConnectedException, ChannelClosedException {
        block5: {
            if (!this.isStarted()) {
                throw new IllegalStateException("Not connected");
            }
            if (dst != null && !this.members.contains(dst)) {
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "discarding message to non member: " + dst);
                }
                return;
            }
            try {
                Message message = new Message();
                message.setDest(dst);
                message.setBuffer(this.marshaller.serializableToBytes(serializedMessage));
                this.channel.send(message);
            }
            catch (Exception e) {
                if (!m_logger.isLoggable(Level.FINEST)) break block5;
                m_logger.log(Level.FINEST, "Exception serializing message in send", e);
            }
        }
    }

    protected void send(Message message) throws ChannelNotConnectedException, ChannelClosedException {
        this.channel.send(message);
    }

    public void setMaxBuffers(int maxBuffers) {
        this.marshaller.setMaxBuffers(maxBuffers);
    }

    public int getMaxBuffers() {
        return this.marshaller.getMaxBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(List recipients, ObjectMarshaller.Marshalled message, boolean block) throws InterruptedException {
        if (!this.isStarted()) {
            throw new IllegalStateException("Not connected");
        }
        if (block) {
            this.blockOutbound.acquire();
        }
        try {
            byte[] bytes;
            if (recipients != null && recipients.size() == 0) {
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "No recipients");
                }
                return;
            }
            try {
                bytes = this.marshaller.marshalledToBytes(message);
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "Broadcasting: {0} to {1} [ {2} bytes]", new Object[]{message, recipients, new Integer(bytes.length)});
                }
            }
            catch (Exception e) {
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "Exception serializing message: " + message, e);
                }
                throw new IllegalStateException("Exception serializing message: " + message + " : " + e);
            }
            if (recipients == null) {
                try {
                    this.channel.send(new Message(null, null, bytes));
                }
                catch (ChannelException e) {
                    if (m_logger.isLoggable(Level.FINEST)) {
                        m_logger.log(Level.FINEST, "Cannot send message", e);
                    }
                }
            } else {
                for (int i = 0; i < recipients.size(); ++i) {
                    Address dst = (Address)recipients.get(i);
                    if (!this.members.contains(dst)) {
                        if (!m_logger.isLoggable(Level.FINEST)) continue;
                        m_logger.log(Level.FINEST, "discarding broadcast message to non member: " + dst);
                        continue;
                    }
                    try {
                        this.channel.send(new Message(dst, null, bytes));
                        continue;
                    }
                    catch (ChannelException e) {
                        if (!m_logger.isLoggable(Level.FINEST)) continue;
                        m_logger.log(Level.FINEST, "Cannot send message", e);
                    }
                }
            }
        }
        finally {
            if (block) {
                this.blockOutbound.release();
            }
        }
    }

    protected void initialize(MembershipListener membershipListener, MessageListener messageListener) {
        this.primaryMembershipListener = membershipListener;
        this.primaryMessageListener = messageListener;
    }

    private Runnable executor() {
        return new Runnable(){

            public void run() {
                ChannelAdapter.this.execute();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        while (this.thread != null) {
            try {
                if (!this.receiverThreadReady) {
                    Integer n = this.syncObj;
                    synchronized (n) {
                        this.receiverThreadReady = true;
                        this.syncObj.notify();
                    }
                }
                if (!this.pauseMessages) {
                    Iterator e = this.queuedMessages.iterator();
                    while (e.hasNext()) {
                        Message msgToDeliver = (Message)e.next();
                        if (this.primaryMessageListener != null) {
                            this.primaryMessageListener.receive(msgToDeliver);
                        }
                        Iterator iterator = this.m_listOfMessageListeners.iterator();
                        while (iterator.hasNext()) {
                            MessageListener listener = (MessageListener)iterator.next();
                            listener.receive(msgToDeliver);
                        }
                    }
                }
                try {
                    if (this.channel != null && this.channel.isConnected()) {
                        this.dispatch(this.channel.receive(100L));
                        continue;
                    }
                    Thread.currentThread();
                    Thread.sleep(10L);
                }
                catch (TimeoutException e) {
                }
                catch (ChannelException e) {
                    if (m_logger.isLoggable(Level.FINEST)) {
                        m_logger.log(Level.FINEST, "Problem with channel, stopping", e);
                    }
                    this.thread = null;
                    return;
                }
            }
            catch (Throwable e) {
                if (!m_logger.isLoggable(Level.FINEST)) continue;
                m_logger.log(Level.FINEST, "Caught exception during top level loop", e);
            }
        }
    }

    protected void dispatch(Object obj) {
        if (obj == null) {
            return;
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "dispatching " + obj.getClass());
        }
        try {
            this.dispatch((Message)obj);
            return;
        }
        catch (ClassCastException e) {
            if (obj instanceof GetStateEvent) {
                this.channel.returnState(this.primaryMessageListener == null ? null : this.primaryMessageListener.getState());
                return;
            }
            try {
                if (this.primaryMessageListener != null) {
                    this.primaryMessageListener.setState(((SetStateEvent)obj).getArg());
                }
                return;
            }
            catch (ClassCastException e2) {
                try {
                    this.viewChanged((View)obj);
                    return;
                }
                catch (ClassCastException e3) {
                    try {
                        if (this.primaryMembershipListener != null) {
                            this.primaryMembershipListener.suspect((Address)((SuspectEvent)obj).getMember());
                        }
                        return;
                    }
                    catch (ClassCastException classCastException) {
                        if (obj instanceof BlockEvent) {
                            if (this.primaryMembershipListener != null) {
                                this.primaryMembershipListener.block();
                            }
                            return;
                        }
                        return;
                    }
                }
            }
        }
    }

    protected void dispatch(Message message) {
        if (this.pauseMessages) {
            this.queuedMessages.add(message);
        } else {
            this.deliver(message);
        }
    }

    protected void deliver(Message message) {
        if (this.primaryMessageListener != null) {
            this.primaryMessageListener.receive(message);
        }
        Iterator iterator = this.m_listOfMessageListeners.iterator();
        while (iterator.hasNext()) {
            MessageListener listener = (MessageListener)iterator.next();
            listener.receive(message);
        }
    }

    protected void viewChanged(View newView) {
        this.members = new ArrayList(newView.getMembers());
        if (this.primaryMembershipListener != null) {
            this.primaryMembershipListener.viewAccepted(newView);
        }
    }

    public List getMembers() {
        return this.members;
    }

    public int getNumMessages() {
        return this.channel.getNumMessages();
    }

    public String getGroupName() {
        return this.channel.getChannelName();
    }

    public String getChannelProtocolStack() {
        return ((JChannel)this.channel).getProperties();
    }
}

