/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jgroups;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import com.oracle.jgroups.InterruptableLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;

public class TestAndWait
implements Sync {
    private String name;
    private SynchronizedBoolean block = new SynchronizedBoolean(false);
    private volatile int count = 0;
    private volatile InterruptableLatch leash = new InterruptableLatch();
    private static final Logger m_logger = TraceLogger.getLogger(TestAndWait.class);

    public TestAndWait(String name) {
        this.name = name;
    }

    public TestAndWait() {
        this.name = "Unnamed";
    }

    public void acquire() throws InterruptedException {
        if (this.block.get()) {
            Exception e;
            if (m_logger.isLoggable(Level.FINEST)) {
                e = new Exception();
                e.fillInStackTrace();
                m_logger.log(Level.FINEST, this.name + " blocked", e);
            }
            this.leash.acquire();
            if (m_logger.isLoggable(Level.FINEST)) {
                e = new Exception();
                e.fillInStackTrace();
                m_logger.log(Level.FINEST, this.name + " unblocked", e);
            }
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (this.block.get()) {
            return this.leash.attempt(msecs);
        }
        return true;
    }

    public synchronized void release() {
        if (--this.count == 0) {
            InterruptableLatch oldLeash = this.leash;
            this.block.set(false);
            this.leash = new InterruptableLatch();
            oldLeash.release();
            if (m_logger.isLoggable(Level.FINEST)) {
                Exception e = new Exception();
                e.fillInStackTrace();
                m_logger.log(Level.FINEST, this.name + " releasing", e);
            }
        } else {
            if (this.count < 0) {
                IllegalStateException e = new IllegalStateException("Count has fallen below zero!");
                e.fillInStackTrace();
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, this.name + " Count has fallen below zero!", e);
                }
                throw e;
            }
            if (m_logger.isLoggable(Level.FINEST)) {
                Exception e = new Exception();
                e.fillInStackTrace();
                m_logger.log(Level.FINEST, this.name + " releasing, count=" + this.count, e);
            }
        }
    }

    public synchronized void squelch() {
        this.block.set(true);
        ++this.count;
        if (m_logger.isLoggable(Level.FINEST)) {
            Exception e = new Exception();
            e.fillInStackTrace();
            m_logger.log(Level.FINEST, this.name + " squelching, count=" + this.count, e);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void interrupt() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "Interrupting");
        }
        this.leash.interrupt();
    }
}

